/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shogun2.service;

import de.terrestris.shogun2.dao.ApplicationDao;
import de.terrestris.shogun2.dao.LayoutDao;
import de.terrestris.shogun2.dao.ModuleDao;
import de.terrestris.shogun2.dao.RoleDao;
import de.terrestris.shogun2.dao.UserDao;
import de.terrestris.shogun2.dao.UserGroupDao;
import de.terrestris.shogun2.model.Application;
import de.terrestris.shogun2.model.PersistentObject;
import de.terrestris.shogun2.model.Role;
import de.terrestris.shogun2.model.User;
import de.terrestris.shogun2.model.UserGroup;
import de.terrestris.shogun2.model.layout.Layout;
import de.terrestris.shogun2.model.module.Module;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="initializationService")
@Transactional(value="transactionManager")
public class InitializationService {
    private static final Logger LOG = Logger.getLogger(InitializationService.class);
    @Autowired
    private RoleDao roleDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private UserGroupDao userGroupDao;
    @Autowired
    private LayoutDao layoutDao;
    @Autowired
    private ModuleDao moduleDao;
    @Autowired
    private ApplicationDao applicationDao;
    @Autowired
    private PasswordEncoder passwordEncoder;

    public Role createRole(Role role) {
        this.roleDao.saveOrUpdate((PersistentObject)role);
        LOG.trace((Object)("Created the role " + role));
        return role;
    }

    public User createUser(User user) {
        String pwHash = this.passwordEncoder.encode((CharSequence)user.getPassword());
        user.setPassword(pwHash);
        this.userDao.saveOrUpdate((PersistentObject)user);
        LOG.trace((Object)("Created the user " + user));
        return user;
    }

    public UserGroup createUserGroup(UserGroup userGroup) {
        this.userGroupDao.saveOrUpdate((PersistentObject)userGroup);
        LOG.trace((Object)("Created the user group " + userGroup));
        return userGroup;
    }

    public Layout createLayout(Layout layout) {
        this.layoutDao.saveOrUpdate((PersistentObject)layout);
        LOG.trace((Object)("Created the layout " + layout));
        return layout;
    }

    public Module createModule(Module module) {
        this.moduleDao.saveOrUpdate((PersistentObject)module);
        LOG.trace((Object)("Created the module " + module));
        return module;
    }

    public Application createApplication(Application application) {
        this.applicationDao.saveOrUpdate((PersistentObject)application);
        LOG.trace((Object)("Created the application " + application));
        return application;
    }
}

