/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shogun2.init;

import de.terrestris.shogun2.model.Application;
import de.terrestris.shogun2.model.PersistentObject;
import de.terrestris.shogun2.model.Role;
import de.terrestris.shogun2.model.User;
import de.terrestris.shogun2.model.UserGroup;
import de.terrestris.shogun2.model.layout.Layout;
import de.terrestris.shogun2.model.module.Module;
import de.terrestris.shogun2.security.acl.AclUtil;
import de.terrestris.shogun2.service.InitializationService;
import java.sql.SQLException;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.jdbc.datasource.init.ScriptException;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class ContentInitializer {
    protected final Logger LOG = Logger.getLogger(this.getClass());
    @Autowired
    @Qualifier(value="shogunInitEnabled")
    private Boolean shogunInitEnabled;
    @Autowired
    @Qualifier(value="cleanupAclTables")
    private Boolean cleanupAclTables;
    @Autowired
    @Qualifier(value="cleanupAclTablesScriptPath")
    private String cleanupAclTablesScriptPath;
    @Autowired
    @Qualifier(value="createDefaultRoles")
    private Boolean createDefaultRoles;
    @Autowired
    @Qualifier(value="createDefaultUsers")
    private Boolean createDefaultUsers;
    @Autowired
    @Qualifier(value="createDefaultUserGroups")
    private Boolean createDefaultUserGroups;
    @Autowired
    @Qualifier(value="createDefaultLayouts")
    private Boolean createDefaultLayouts;
    @Autowired
    @Qualifier(value="createDefaultModules")
    private Boolean createDefaultModules;
    @Autowired
    @Qualifier(value="createDefaultApplications")
    private Boolean createDefaultApplications;
    @Autowired
    protected InitializationService initService;
    @Autowired
    @Qualifier(value="aclDataSource")
    protected DataSource aclDataSource;
    @Autowired
    protected AclUtil aclSecurityUtil;
    @Autowired
    @Qualifier(value="shogun2AuthenticationProvider")
    protected AuthenticationProvider authenticationProvider;
    @Autowired(required=false)
    private Set<Role> defaultRoles;
    @Autowired(required=false)
    private Set<User> defaultUsers;
    @Autowired(required=false)
    private Set<UserGroup> defaultUserGroups;
    @Autowired(required=false)
    private Set<Layout> defaultLayouts;
    @Autowired(required=false)
    private Set<Module> defaultModules;
    @Autowired(required=false)
    private Set<Application> defaultApplications;

    public void initializeDatabaseContent() {
        if (this.shogunInitEnabled.booleanValue()) {
            this.LOG.info((Object)"Initializing SHOGun2 content");
            User adminUser = null;
            String rawAdminPassword = null;
            for (User user : this.defaultUsers) {
                if (!user.getAccountName().equals("admin")) continue;
                adminUser = user;
                rawAdminPassword = user.getPassword();
            }
            if (this.cleanupAclTables.booleanValue()) {
                this.cleanupAclTables();
            }
            if (this.createDefaultRoles.booleanValue()) {
                this.createDefaultRoles();
            }
            if (this.createDefaultUsers.booleanValue()) {
                this.createDefaultUsers();
            }
            if (this.createDefaultUserGroups.booleanValue()) {
                this.createDefaultUserGroups();
            }
            if (this.createDefaultLayouts.booleanValue()) {
                this.createDefaultLayouts();
            }
            if (this.createDefaultModules.booleanValue()) {
                this.createDefaultModules();
            }
            if (this.createDefaultApplications.booleanValue()) {
                this.createDefaultApplications();
            }
            if (adminUser != null) {
                this.logInUser(adminUser, rawAdminPassword);
                for (Application application : this.defaultApplications) {
                    this.aclSecurityUtil.addPermission((PersistentObject)application, adminUser, BasePermission.READ);
                }
                this.LOG.info((Object)"Managed security/ACL");
                this.logoutUser();
            }
        } else {
            this.LOG.info((Object)"Not initializing anything for SHOGun2.");
        }
    }

    private void createDefaultRoles() {
        this.LOG.info((Object)"Creating a set of default roles.");
        for (Role role : this.defaultRoles) {
            this.initService.createRole(role);
        }
        this.LOG.info((Object)("Created a total of " + this.defaultRoles.size() + " default roles."));
    }

    private void createDefaultUsers() {
        this.LOG.info((Object)"Creating a set of default users.");
        for (User user : this.defaultUsers) {
            this.initService.createUser(user);
        }
        this.LOG.info((Object)("Created a total of " + this.defaultUsers.size() + " default users."));
    }

    private void createDefaultUserGroups() {
        this.LOG.info((Object)"Creating a set of default user groups.");
        for (UserGroup userGroup : this.defaultUserGroups) {
            this.initService.createUserGroup(userGroup);
        }
        this.LOG.info((Object)("Created a total of " + this.defaultUserGroups.size() + " default user groups."));
    }

    private void createDefaultLayouts() {
        this.LOG.info((Object)"Creating a set of default layouts.");
        for (Layout layout : this.defaultLayouts) {
            this.initService.createLayout(layout);
        }
        this.LOG.info((Object)("Created a total of " + this.defaultLayouts.size() + " default layouts."));
    }

    private void createDefaultModules() {
        this.LOG.info((Object)"Creating a set of default modules.");
        for (Module module : this.defaultModules) {
            this.initService.createModule(module);
        }
        this.LOG.info((Object)("Created a total of " + this.defaultModules.size() + " default modules."));
    }

    private void createDefaultApplications() {
        this.LOG.info((Object)"Creating a set of default applications.");
        for (Application app : this.defaultApplications) {
            this.initService.createApplication(app);
        }
        this.LOG.info((Object)("Created a total of " + this.defaultApplications.size() + " default applications."));
    }

    private void logInUser(User user, String rawPassword) {
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)user.getAccountName(), (Object)rawPassword);
        Authentication authResult = this.authenticationProvider.authenticate((Authentication)authRequest);
        SecurityContextHolder.getContext().setAuthentication(authResult);
    }

    private void logoutUser() {
        SecurityContextHolder.clearContext();
    }

    private void cleanupAclTables() {
        ResourceDatabasePopulator rdp = new ResourceDatabasePopulator(new Resource[]{new ClassPathResource(this.cleanupAclTablesScriptPath)});
        this.LOG.info((Object)"Trying to clean up ACL tables.");
        try {
            rdp.populate(this.aclDataSource.getConnection());
            this.LOG.info((Object)"Cleaned up ACL tables.");
        }
        catch (SQLException | ScriptException e) {
            this.LOG.error((Object)("Could not clean up ACL tables: " + e.getMessage()));
        }
    }
}

