/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shogun2.init;

import de.terrestris.shogun2.model.Application;
import de.terrestris.shogun2.model.Role;
import de.terrestris.shogun2.model.User;
import de.terrestris.shogun2.model.UserGroup;
import de.terrestris.shogun2.model.layout.Layout;
import de.terrestris.shogun2.model.module.Module;
import de.terrestris.shogun2.service.InitializationService;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.authentication.AuthenticationProvider;

public class ContentInitializer {
    protected final Logger LOG = Logger.getLogger(this.getClass());
    @Autowired
    @Qualifier(value="shogunInitEnabled")
    private Boolean shogunInitEnabled;
    @Autowired
    @Qualifier(value="createDefaultRoles")
    private Boolean createDefaultRoles;
    @Autowired
    @Qualifier(value="createDefaultUsers")
    private Boolean createDefaultUsers;
    @Autowired
    @Qualifier(value="createDefaultUserGroups")
    private Boolean createDefaultUserGroups;
    @Autowired
    @Qualifier(value="createDefaultLayouts")
    private Boolean createDefaultLayouts;
    @Autowired
    @Qualifier(value="createDefaultModules")
    private Boolean createDefaultModules;
    @Autowired
    @Qualifier(value="createDefaultApplications")
    private Boolean createDefaultApplications;
    @Autowired
    protected InitializationService initService;
    @Autowired
    @Qualifier(value="shogun2AuthenticationProvider")
    protected AuthenticationProvider authenticationProvider;
    @Autowired(required=false)
    private Set<Role> defaultRoles;
    @Autowired(required=false)
    private Set<User> defaultUsers;
    @Autowired(required=false)
    private Set<UserGroup> defaultUserGroups;
    @Autowired(required=false)
    private Set<Layout> defaultLayouts;
    @Autowired(required=false)
    private Set<Module> defaultModules;
    @Autowired(required=false)
    private Set<Application> defaultApplications;

    public void initializeDatabaseContent() {
        if (this.shogunInitEnabled.booleanValue()) {
            this.LOG.info((Object)"Initializing SHOGun2 content");
            if (this.createDefaultRoles.booleanValue()) {
                this.createDefaultRoles();
            }
            if (this.createDefaultUsers.booleanValue()) {
                this.createDefaultUsers();
            }
            if (this.createDefaultUserGroups.booleanValue()) {
                this.createDefaultUserGroups();
            }
            if (this.createDefaultLayouts.booleanValue()) {
                this.createDefaultLayouts();
            }
            if (this.createDefaultModules.booleanValue()) {
                this.createDefaultModules();
            }
            if (this.createDefaultApplications.booleanValue()) {
                this.createDefaultApplications();
            }
        } else {
            this.LOG.info((Object)"Not initializing anything for SHOGun2.");
        }
    }

    private void createDefaultRoles() {
        this.LOG.info((Object)"Creating a set of default roles.");
        for (Role role : this.defaultRoles) {
            this.initService.createRole(role);
        }
        this.LOG.info((Object)("Created a total of " + this.defaultRoles.size() + " default roles."));
    }

    private void createDefaultUsers() {
        this.LOG.info((Object)"Creating a set of default users.");
        for (User user : this.defaultUsers) {
            this.initService.createUser(user);
        }
        this.LOG.info((Object)("Created a total of " + this.defaultUsers.size() + " default users."));
    }

    private void createDefaultUserGroups() {
        this.LOG.info((Object)"Creating a set of default user groups.");
        for (UserGroup userGroup : this.defaultUserGroups) {
            this.initService.createUserGroup(userGroup);
        }
        this.LOG.info((Object)("Created a total of " + this.defaultUserGroups.size() + " default user groups."));
    }

    private void createDefaultLayouts() {
        this.LOG.info((Object)"Creating a set of default layouts.");
        for (Layout layout : this.defaultLayouts) {
            this.initService.createLayout(layout);
        }
        this.LOG.info((Object)("Created a total of " + this.defaultLayouts.size() + " default layouts."));
    }

    private void createDefaultModules() {
        this.LOG.info((Object)"Creating a set of default modules.");
        for (Module module : this.defaultModules) {
            this.initService.createModule(module);
        }
        this.LOG.info((Object)("Created a total of " + this.defaultModules.size() + " default modules."));
    }

    private void createDefaultApplications() {
        this.LOG.info((Object)"Creating a set of default applications.");
        for (Application app : this.defaultApplications) {
            this.initService.createApplication(app);
        }
        this.LOG.info((Object)("Created a total of " + this.defaultApplications.size() + " default applications."));
    }
}

