/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shogun2.init;

import de.terrestris.shogun2.model.PersistentObject;
import de.terrestris.shogun2.model.User;
import de.terrestris.shogun2.service.InitializationService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.authentication.AuthenticationProvider;

public class ContentInitializer {
    protected final Logger LOG = Logger.getLogger(this.getClass());
    @Autowired
    @Qualifier(value="shogunInitEnabled")
    private Boolean shogunInitEnabled;
    @Autowired
    protected InitializationService initService;
    @Autowired
    @Qualifier(value="shogun2AuthenticationProvider")
    protected AuthenticationProvider authenticationProvider;
    @Resource
    @Qualifier(value="objectsToCreate")
    private List<PersistentObject> objectsToCreate;

    public void initializeDatabaseContent() {
        if (this.shogunInitEnabled.booleanValue()) {
            this.LOG.info((Object)"Initializing SHOGun2 content");
            for (PersistentObject object : this.objectsToCreate) {
                if (object instanceof User) {
                    this.initService.saveUser((User)object);
                    continue;
                }
                this.initService.savePersistentObject(object);
            }
        } else {
            this.LOG.info((Object)"Not initializing anything for SHOGun2.");
        }
    }
}

