/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shogun2.service;

import de.terrestris.shogun2.dao.GenericHibernateDao;
import de.terrestris.shogun2.model.PersistentObject;
import de.terrestris.shogun2.model.User;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="initializationService")
@Transactional(value="transactionManager")
public class InitializationService {
    private static final Logger LOG = Logger.getLogger(InitializationService.class);
    @Autowired
    @Qualifier(value="genericDao")
    private GenericHibernateDao<PersistentObject, Integer> dao;
    @Autowired
    private PasswordEncoder passwordEncoder;

    public void savePersistentObject(PersistentObject object) {
        String type = object.getClass().getSimpleName();
        LOG.trace((Object)("Trying to create a new " + type));
        this.dao.saveOrUpdate(object);
        LOG.info((Object)("Created the " + type + " with id " + object.getId()));
    }

    public void saveUser(User user) {
        LOG.trace((Object)"Trying to create a new user");
        String pwHash = this.passwordEncoder.encode((CharSequence)user.getPassword());
        user.setPassword(pwHash);
        this.dao.saveOrUpdate((PersistentObject)user);
        LOG.info((Object)("Created the user " + user.getAccountName()));
    }
}

