/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shogun2.util.naming;

import org.apache.commons.lang3.StringUtils;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.PhysicalNamingStrategyStandardImpl;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class PhysicalNamingStrategyShogun2
extends PhysicalNamingStrategyStandardImpl {
    private static final long serialVersionUID = 1L;
    protected static final int LENGTH_LIMIT_ORACLE = 30;
    protected static final int LENGTH_LIMIT_POSTGRESQL = 63;
    @Autowired(required=false)
    @Qualifier(value="tablePrefix")
    private String tablePrefix;

    public Identifier toPhysicalTableName(Identifier name, JdbcEnvironment context) {
        Identifier tableIdentifier = super.toPhysicalTableName(name, context);
        return this.convertToLimitedLowerCase(context, tableIdentifier, this.tablePrefix);
    }

    public Identifier toPhysicalColumnName(Identifier name, JdbcEnvironment context) {
        Identifier columnIdentifier = super.toPhysicalColumnName(name, context);
        return this.convertToLimitedLowerCase(context, columnIdentifier, null);
    }

    private Identifier convertToLimitedLowerCase(JdbcEnvironment context, Identifier identifier, String prefix) {
        String identifierText = identifier.getText();
        if (prefix != null) {
            identifierText = prefix + identifierText;
        }
        identifierText = identifierText.toLowerCase();
        Integer lengthLimit = this.getIdentifierLengthLimit(context);
        if (lengthLimit != null && identifierText.length() > lengthLimit) {
            identifierText = StringUtils.substring((String)identifierText, (int)0, (int)lengthLimit);
        }
        return Identifier.toIdentifier((String)identifierText);
    }

    private Integer getIdentifierLengthLimit(JdbcEnvironment context) {
        String dialectName = context.getDialect().getClass().getSimpleName();
        if (dialectName.startsWith("Oracle")) {
            return 30;
        }
        if (dialectName.startsWith("PostgreSQL")) {
            return 63;
        }
        return null;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }
}

