/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shogun2.util.mail;

import java.io.File;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;

@Component
public class MailPublisher {
    private static final Logger LOG = Logger.getLogger(MailPublisher.class);
    @Autowired
    @Qualifier(value="mailSender")
    private JavaMailSender mailSender;
    @Autowired
    @Qualifier(value="defaultMailSender")
    private String defaultMailSender;

    public void sendMail(String from, String replyTo, String[] to, String[] cc, String[] bcc, String subject, String msg) throws Exception {
        SimpleMailMessage simpleMailMassage = new SimpleMailMessage();
        if (from == null || from.isEmpty()) {
            from = this.defaultMailSender;
        }
        simpleMailMassage.setFrom(from);
        simpleMailMassage.setReplyTo(replyTo);
        simpleMailMassage.setTo(to);
        simpleMailMassage.setBcc(bcc);
        simpleMailMassage.setCc(cc);
        simpleMailMassage.setSubject(subject);
        simpleMailMassage.setText(msg);
        this.sendMail(simpleMailMassage);
    }

    public void sendMimeMail(String from, String replyTo, String[] to, String[] cc, String[] bcc, String subject, String msg, Boolean html, String attachmentFilename, File attachmentFile) throws MessagingException, MailException {
        Boolean multipart = false;
        if (attachmentFilename != null && attachmentFile != null) {
            multipart = true;
        }
        MimeMessage mimeMailMessage = this.mailSender.createMimeMessage();
        MimeMessageHelper mimeHelper = new MimeMessageHelper(mimeMailMessage, multipart.booleanValue());
        if (from == null || from.isEmpty()) {
            from = this.defaultMailSender;
        }
        mimeHelper.setFrom(from);
        mimeHelper.setTo(to);
        mimeHelper.setSubject(subject);
        mimeHelper.setText(msg, html.booleanValue());
        if (replyTo != null && !replyTo.isEmpty()) {
            mimeHelper.setReplyTo(replyTo);
        }
        if (bcc != null && bcc.length > 0) {
            mimeHelper.setBcc(bcc);
        }
        if (cc != null && cc.length > 0) {
            mimeHelper.setCc(cc);
        }
        if (attachmentFilename != null && attachmentFile != null) {
            mimeHelper.addAttachment(attachmentFilename, attachmentFile);
        }
        this.sendMail(mimeMailMessage);
    }

    public void sendMail(SimpleMailMessage mailMessage) throws MailException {
        String subject = mailMessage.getSubject();
        String to = StringUtils.join((Object[])mailMessage.getTo(), (String)", ");
        LOG.debug((Object)("Sending a mail with subject '" + subject + "' to '" + to + "'"));
        this.mailSender.send(mailMessage);
        LOG.debug((Object)("Successfully sent mail to '" + to + "'"));
    }

    public void sendMail(MimeMessage mimeMessage) throws MailException, MessagingException {
        String subject = mimeMessage.getSubject();
        LOG.debug((Object)("Sending a mail (mime) with subject '" + subject + "'"));
        this.mailSender.send(mimeMessage);
        LOG.debug((Object)"Successfully sent mail (mime)");
    }

    public JavaMailSender getMailSender() {
        return this.mailSender;
    }

    public void setMailSender(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }

    public String getDefaultMailSender() {
        return this.defaultMailSender;
    }

    public void setDefaultMailSender(String defaultMailSender) {
        this.defaultMailSender = defaultMailSender;
    }
}

