/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shogun2.rest;

import de.terrestris.shogun2.model.PersistentObject;
import de.terrestris.shogun2.service.AbstractCrudService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@RequestMapping(value={"/rest"})
public abstract class AbstractRestController<E extends PersistentObject> {
    private static final Logger LOG = Logger.getLogger(AbstractRestController.class);
    @Autowired
    private AbstractCrudService<E> service;

    @RequestMapping(method={RequestMethod.GET})
    public ResponseEntity<List<E>> findAll() {
        List resultList = this.service.findAll();
        if (resultList != null && !resultList.isEmpty()) {
            LOG.trace((Object)("Found a total of " + resultList.size() + " entities of type " + ((PersistentObject)resultList.get(0)).getClass().getSimpleName()));
        }
        return new ResponseEntity((Object)resultList, HttpStatus.OK);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<E> findById(@PathVariable Integer id) {
        try {
            PersistentObject entity = this.service.findById(id);
            LOG.trace((Object)("Found " + entity.getClass().getSimpleName() + " with ID " + entity.getId()));
            return new ResponseEntity((Object)entity, HttpStatus.OK);
        }
        catch (Exception e) {
            LOG.error((Object)("Error finding entity with id " + id + ": " + e.getMessage()));
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<E> save(@RequestBody E entity) {
        String simpleClassName = entity.getClass().getSimpleName();
        String errorMessagePrefix = "Error when saving entity of type " + simpleClassName + ": ";
        Integer id = entity.getId();
        if (id != null) {
            LOG.error((Object)(errorMessagePrefix + "ID value is set to " + id + ", but MUST be null"));
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        try {
            entity = this.service.saveOrUpdate(entity);
            LOG.trace((Object)("Created " + simpleClassName + " with ID " + entity.getId()));
            return new ResponseEntity(entity, HttpStatus.CREATED);
        }
        catch (Exception e) {
            LOG.error((Object)(errorMessagePrefix + e.getMessage()));
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT})
    public ResponseEntity<E> update(@PathVariable int id, @RequestBody E entity) {
        String simpleClassName = entity.getClass().getSimpleName();
        Integer payloadId = entity.getId();
        if (payloadId == id) {
            try {
                PersistentObject updated = this.service.saveOrUpdate(entity);
                LOG.trace((Object)("Updated " + simpleClassName + " with ID " + id));
                return new ResponseEntity((Object)updated, HttpStatus.OK);
            }
            catch (Exception e) {
                LOG.error((Object)("Error updating " + simpleClassName + ":" + e.getMessage()));
                return new ResponseEntity(HttpStatus.NOT_FOUND);
            }
        }
        LOG.error((Object)("Error updating " + simpleClassName + ": Requested to update entity with ID " + id + ", but payload ID is " + payloadId));
        return new ResponseEntity(HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<E> delete(@PathVariable int id) {
        try {
            PersistentObject entityToDelete = this.service.loadById(id);
            this.service.delete(entityToDelete);
            String proxyClassName = entityToDelete.getClass().getSimpleName();
            String simpleClassName = StringUtils.substringBefore((String)proxyClassName, (String)"_$$_");
            LOG.trace((Object)("Deleted " + simpleClassName + " with ID " + id));
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        catch (Exception e) {
            LOG.error((Object)("Error deleting entity with ID " + id + ": " + e.getMessage()));
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
    }
}

