/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shogun2.web;

import de.terrestris.shogun2.model.Application;
import de.terrestris.shogun2.model.PersistentObject;
import de.terrestris.shogun2.service.ApplicationService;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/application"})
public class ApplicationController {
    private static final Logger LOG = Logger.getLogger(ApplicationController.class);
    @Autowired
    private ApplicationService applicationService;

    @RequestMapping(value={"/create.action"}, method={RequestMethod.GET})
    @ResponseBody
    public Application createApplication(String name, String description) {
        LOG.info((Object)"Requested to create a new Application.");
        Application application = new Application();
        application.setName(name);
        application.setDescription(description);
        application.setLanguage(Locale.getDefault());
        return (Application)this.applicationService.saveOrUpdate((PersistentObject)application);
    }

    @RequestMapping(value={"/findAll.action"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Application> findAllApplications() {
        LOG.info((Object)"Trying to find all Applications.");
        return this.applicationService.findAll();
    }

    @RequestMapping(value={"/get.action"}, method={RequestMethod.GET})
    @ResponseBody
    public Application get(Integer id) {
        LOG.info((Object)("Trying to get application with ID " + id));
        return (Application)this.applicationService.findById(id);
    }
}

