/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shogun2.web;

import ch.rasc.extclassgenerator.IncludeValidation;
import ch.rasc.extclassgenerator.ModelGenerator;
import ch.rasc.extclassgenerator.OutputFormat;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ExtModelController {
    @Autowired
    @Qualifier(value="modelPackageCandidates")
    private ArrayList<String> modelPackageCandidates;

    @RequestMapping(value={"/{className}.js"})
    public void buildExtModel(HttpServletRequest request, HttpServletResponse response, @PathVariable String className) throws IOException {
        Class<?> clazz = null;
        for (String modelPackage : this.modelPackageCandidates) {
            try {
                String fullyQualifiedClassName = modelPackage + "." + className;
                clazz = Class.forName(fullyQualifiedClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        boolean success = false;
        if (clazz != null) {
            try {
                ModelGenerator.writeModel((HttpServletRequest)request, (HttpServletResponse)response, clazz, (OutputFormat)OutputFormat.EXTJS4, (IncludeValidation)IncludeValidation.BUILTIN, (boolean)true);
                success = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!success) {
            response.setStatus(404);
            response.getWriter().write("Could generate EXT class for " + className);
            response.getWriter().flush();
            response.getWriter().close();
        }
    }
}

