/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shogun2.web;

import de.terrestris.shogun2.model.User;
import de.terrestris.shogun2.service.PasswordResetTokenService;
import de.terrestris.shogun2.service.UserService;
import de.terrestris.shogun2.web.AbstractWebController;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/user"})
public class UserController
extends AbstractWebController {
    private static final Logger LOG = Logger.getLogger(UserController.class);
    @Autowired
    private UserService userService;
    @Autowired
    private PasswordResetTokenService passwordResetTokenService;

    @RequestMapping(value={"/register.action"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> registerUser(HttpServletRequest request, @RequestParam String email, @RequestParam String password) {
        User user = new User();
        user.setEmail(email);
        user.setAccountName(email);
        user.setPassword(password);
        user.setActive(false);
        try {
            user = this.userService.registerUser(user, request);
            return this.getModelMapSuccess("You have been registered. Please check your mails (" + user.getEmail() + ") for further instructions.");
        }
        catch (Exception e) {
            LOG.error((Object)("Could not register a new user: " + e.getMessage()));
            return this.getModelMapError("Could not register a new user.");
        }
    }

    @RequestMapping(value={"/activate.action"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> activateUser(@RequestParam String token) {
        try {
            this.userService.activateUser(token);
            return this.getModelMapSuccess("Your account has successfully been activated.");
        }
        catch (Exception e) {
            LOG.error((Object)("Account could not be activated: " + e.getMessage()));
            return this.getModelMapError("Account could not be activated.");
        }
    }

    @RequestMapping(value={"/resetPassword.action"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> resetPassword(HttpServletRequest request, @RequestParam(value="email") String email) {
        LOG.debug((Object)("Requested to reset the password for '" + email + "'"));
        try {
            this.passwordResetTokenService.sendResetPasswordMail(request, email);
            return this.getModelMapSuccess("Password reset has been requested. Please check your mails!");
        }
        catch (Exception e) {
            LOG.error((Object)("Could not request a password reset: " + e.getMessage()));
            return this.getModelMapError("An error has occured during passwort reset request.");
        }
    }

    @RequestMapping(value={"/changePassword.action"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> changePassword(@RequestParam(value="password") String password, @RequestParam(value="token") String token) {
        LOG.debug((Object)("Requested to change a password for token " + token));
        try {
            this.passwordResetTokenService.validateTokenAndUpdatePassword(password, token);
            return this.getModelMapSuccess("Your password was changed successfully.");
        }
        catch (Exception e) {
            LOG.error((Object)("Could not change the password: " + e.getMessage()));
            return this.getModelMapError("Could not change the password. Please contact your administrator.");
        }
    }

    @RequestMapping(value={"/getUserBySession.action"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> getUserBySession() {
        LOG.debug((Object)"Requested to return the logged in user");
        try {
            return this.getModelMapSuccess(this.userService.getUserBySession());
        }
        catch (Exception e) {
            return this.getModelMapError("Could not obtain the user by session: " + e.getMessage());
        }
    }
}

