/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shogun2.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.terrestris.shogun2.dao.GenericHibernateDao;
import de.terrestris.shogun2.model.PersistentObject;
import de.terrestris.shogun2.service.AbstractCrudService;
import de.terrestris.shogun2.web.AbstractWebController;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@RequestMapping(value={"/rest"})
public abstract class AbstractRestController<E extends PersistentObject, D extends GenericHibernateDao<E, Integer>, S extends AbstractCrudService<E, D>>
extends AbstractWebController<E, D, S> {
    @Autowired
    protected ObjectMapper objectMapper;

    protected AbstractRestController(Class<E> entityClass) {
        super(entityClass);
    }

    @RequestMapping(method={RequestMethod.GET})
    public ResponseEntity<List<E>> findAll() {
        List resultList = this.service.findAll();
        if (resultList != null && !resultList.isEmpty()) {
            this.LOG.trace((Object)("Found a total of " + resultList.size() + " entities of type " + ((PersistentObject)resultList.get(0)).getClass().getSimpleName()));
        }
        return new ResponseEntity((Object)resultList, HttpStatus.OK);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<E> findById(@PathVariable Integer id) {
        try {
            PersistentObject entity = this.service.findById(id);
            this.LOG.trace((Object)("Found " + entity.getClass().getSimpleName() + " with ID " + entity.getId()));
            return new ResponseEntity((Object)entity, HttpStatus.OK);
        }
        catch (Exception e) {
            this.LOG.error((Object)("Error finding entity with id " + id + ": " + e.getMessage()));
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<E> save(@RequestBody E entity) {
        String simpleClassName = entity.getClass().getSimpleName();
        String errorMessagePrefix = "Error when saving entity of type " + simpleClassName + ": ";
        Integer id = entity.getId();
        if (id != null) {
            this.LOG.error((Object)(errorMessagePrefix + "ID value is set to " + id + ", but MUST be null"));
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        try {
            entity = this.service.saveOrUpdate(entity);
            this.LOG.trace((Object)("Created " + simpleClassName + " with ID " + entity.getId()));
            return new ResponseEntity(entity, HttpStatus.CREATED);
        }
        catch (Exception e) {
            this.LOG.error((Object)(errorMessagePrefix + e.getMessage()));
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT})
    public ResponseEntity<E> update(@PathVariable int id, HttpServletRequest request) {
        String errorPrefix = "Error updating " + this.getEntityClass().getSimpleName() + " with ID " + id + ": ";
        BufferedReader reader = null;
        try {
            reader = request.getReader();
            JsonNode jsonObject = this.objectMapper.readTree((Reader)reader);
            if (jsonObject == null || !jsonObject.has("id")) {
                this.LOG.error((Object)(errorPrefix + "The JSON body is empty or has no 'id' property."));
                ResponseEntity responseEntity = new ResponseEntity(HttpStatus.BAD_REQUEST);
                return responseEntity;
            }
            int payloadId = jsonObject.get("id").asInt();
            if (payloadId != id) {
                this.LOG.error((Object)(errorPrefix + "Requested to update entity with ID " + id + ", but payload ID is " + payloadId));
                ResponseEntity responseEntity = new ResponseEntity(HttpStatus.BAD_REQUEST);
                return responseEntity;
            }
            PersistentObject entity = this.service.findById(Integer.valueOf(id));
            if (entity != null) {
                entity = (PersistentObject)this.objectMapper.readerForUpdating((Object)entity).readValue(jsonObject);
                this.service.saveOrUpdate(entity);
                ResponseEntity responseEntity = new ResponseEntity((Object)entity, HttpStatus.OK);
                return responseEntity;
            }
            ResponseEntity responseEntity = new ResponseEntity(HttpStatus.NOT_FOUND);
            return responseEntity;
        }
        catch (Exception e) {
            this.LOG.error((Object)(errorPrefix + e.getMessage()));
            ResponseEntity responseEntity = new ResponseEntity(HttpStatus.NOT_FOUND);
            return responseEntity;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<E> delete(@PathVariable int id) {
        try {
            PersistentObject entityToDelete = this.service.loadById(id);
            this.service.delete(entityToDelete);
            String proxyClassName = entityToDelete.getClass().getSimpleName();
            String simpleClassName = StringUtils.substringBefore((String)proxyClassName, (String)"_$$_");
            this.LOG.trace((Object)("Deleted " + simpleClassName + " with ID " + id));
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        catch (Exception e) {
            this.LOG.error((Object)("Error deleting entity with ID " + id + ": " + e.getMessage()));
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
    }
}

