/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shogun2.web;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.terrestris.shogun2.dao.ImageFileDao;
import de.terrestris.shogun2.model.ImageFile;
import de.terrestris.shogun2.service.ImageFileService;
import de.terrestris.shogun2.util.data.ResultSet;
import de.terrestris.shogun2.web.FileController;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/image"})
public class ImageFileController<E extends ImageFile, D extends ImageFileDao<E>, S extends ImageFileService<E, D>>
extends FileController<E, D, S> {
    private boolean createThumbnail = true;
    private Integer thumbnailDimensions = 100;

    public ImageFileController() {
        this(ImageFile.class);
    }

    protected ImageFileController(Class<E> entityClass) {
        super(entityClass);
    }

    @Override
    @Autowired
    @Qualifier(value="imageFileService")
    public void setService(S service) {
        this.service = service;
    }

    @Override
    @RequestMapping(value={"/upload.action"}, method={RequestMethod.POST})
    public ResponseEntity<String> uploadFile(@RequestParam(value="file") MultipartFile uploadedImage) {
        this.LOG.debug((Object)"Requested to upload an image");
        Map responseMap = new HashMap();
        HttpHeaders responseHeaders = new HttpHeaders();
        HttpStatus responseStatus = HttpStatus.OK;
        String responseMapAsString = null;
        ObjectMapper mapper = new ObjectMapper();
        responseHeaders.setContentType(MediaType.TEXT_HTML);
        if (uploadedImage.isEmpty()) {
            this.LOG.error((Object)("Upload failed. Image " + uploadedImage + " is empty."));
            responseMap = ResultSet.error((String)("Upload failed. Image " + uploadedImage.getOriginalFilename() + " is empty."));
        }
        try {
            ImageFile image = ((ImageFileService)this.service).uploadImage(uploadedImage, this.createThumbnail, this.thumbnailDimensions);
            this.LOG.info((Object)("Successfully uploaded image " + image.getFileName()));
            responseMap = ResultSet.success((Object)image);
        }
        catch (Exception e) {
            this.LOG.error((Object)("Could not upload the image: " + e.getMessage()));
            responseMap = ResultSet.error((String)("Could not upload the image: " + e.getMessage()));
        }
        try {
            responseMapAsString = mapper.writeValueAsString(responseMap);
        }
        catch (JsonProcessingException e) {
            this.LOG.error((Object)("Error while rewriting the response Map to a String" + e.getMessage()));
            responseMap = ResultSet.error((String)("Error while rewriting the response Map to a String" + e.getMessage()));
        }
        return new ResponseEntity((Object)responseMapAsString, (MultiValueMap)responseHeaders, responseStatus);
    }

    @RequestMapping(value={"/getThumbnail.action"}, method={RequestMethod.GET})
    public ResponseEntity<?> getThumbnail(@RequestParam Integer id) {
        HttpHeaders responseHeaders = new HttpHeaders();
        Map responseMap = new HashMap();
        try {
            ImageFile image = ((ImageFileService)this.service).getImage(id);
            byte[] imageBytes = null;
            imageBytes = image.getThumbnail();
            responseHeaders.setContentType(MediaType.parseMediaType((String)image.getFileType()));
            this.LOG.info((Object)("Successfully got the image thumbnail " + image.getFileName()));
            responseMap = ResultSet.success((Object)image);
            return new ResponseEntity((Object)imageBytes, (MultiValueMap)responseHeaders, HttpStatus.OK);
        }
        catch (Exception e) {
            this.LOG.error((Object)("Could not get the image thumbnail: " + e.getMessage()));
            responseMap = ResultSet.error((String)("Could not get the image thumbnail: " + e.getMessage()));
            responseHeaders.setContentType(MediaType.APPLICATION_JSON);
            return new ResponseEntity(responseMap, (MultiValueMap)responseHeaders, HttpStatus.OK);
        }
    }
}

