/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shogun2.web;

import de.terrestris.shogun2.dao.PasswordResetTokenDao;
import de.terrestris.shogun2.dao.UserDao;
import de.terrestris.shogun2.model.User;
import de.terrestris.shogun2.model.token.PasswordResetToken;
import de.terrestris.shogun2.service.PasswordResetTokenService;
import de.terrestris.shogun2.service.UserService;
import de.terrestris.shogun2.util.data.ResultSet;
import de.terrestris.shogun2.web.AbstractWebController;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/user"})
public class UserController<E extends User, D extends UserDao<E>, S extends UserService<E, D>>
extends AbstractWebController<E, D, S> {
    @Autowired
    private PasswordResetTokenService<PasswordResetToken, PasswordResetTokenDao<PasswordResetToken>> passwordResetTokenService;

    public UserController() {
        this(User.class);
    }

    protected UserController(Class<E> entityClass) {
        super(entityClass);
    }

    @Override
    @Autowired
    @Qualifier(value="userService")
    public void setService(S service) {
        this.service = service;
    }

    @RequestMapping(value={"/register.action"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> registerUser(HttpServletRequest request, @RequestParam String email, @RequestParam String password) {
        try {
            User user = (User)this.getEntityClass().newInstance();
            user.setEmail(email);
            user.setAccountName(email);
            user.setPassword(password);
            user.setActive(false);
            user = ((UserService)this.service).registerUser(user, request);
            return ResultSet.success((Object)("You have been registered. Please check your mails (" + user.getEmail() + ") for further instructions."));
        }
        catch (Exception e) {
            this.LOG.error((Object)("Could not register a new user: " + e.getMessage()));
            return ResultSet.error((String)"Could not register a new user.");
        }
    }

    @RequestMapping(value={"/activate.action"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> activateUser(@RequestParam String token) {
        try {
            ((UserService)this.service).activateUser(token);
            return ResultSet.success((Object)"Your account has successfully been activated.");
        }
        catch (Exception e) {
            this.LOG.error((Object)("Account could not be activated: " + e.getMessage()));
            return ResultSet.error((String)"Account could not be activated.");
        }
    }

    @RequestMapping(value={"/resetPassword.action"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> resetPassword(HttpServletRequest request, @RequestParam(value="email") String email) {
        this.LOG.debug((Object)("Requested to reset the password for '" + email + "'"));
        try {
            this.passwordResetTokenService.sendResetPasswordMail(request, email);
            return ResultSet.success((Object)"Password reset has been requested. Please check your mails!");
        }
        catch (Exception e) {
            this.LOG.error((Object)("Could not request a password reset: " + e.getMessage()));
            return ResultSet.error((String)"An error has occured during passwort reset request.");
        }
    }

    @RequestMapping(value={"/changePassword.action"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> changePassword(@RequestParam(value="password") String password, @RequestParam(value="token") String token) {
        this.LOG.debug((Object)("Requested to change a password for token " + token));
        try {
            this.passwordResetTokenService.validateTokenAndUpdatePassword(password, token);
            return ResultSet.success((Object)"Your password was changed successfully.");
        }
        catch (Exception e) {
            this.LOG.error((Object)("Could not change the password: " + e.getMessage()));
            return ResultSet.error((String)"Could not change the password. Please contact your administrator.");
        }
    }

    @RequestMapping(value={"/getUserBySession.action"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> getUserBySession() {
        this.LOG.debug((Object)"Requested to return the logged in user");
        try {
            return ResultSet.success((Object)((UserService)this.service).getUserBySession());
        }
        catch (Exception e) {
            return ResultSet.error((String)("Could not obtain the user by session: " + e.getMessage()));
        }
    }

    public PasswordResetTokenService<PasswordResetToken, PasswordResetTokenDao<PasswordResetToken>> getPasswordResetTokenService() {
        return this.passwordResetTokenService;
    }

    public void setPasswordResetTokenService(PasswordResetTokenService<PasswordResetToken, PasswordResetTokenDao<PasswordResetToken>> passwordResetTokenService) {
        this.passwordResetTokenService = passwordResetTokenService;
    }
}

