/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shogun2.rest;

import de.terrestris.shogun2.dao.UserDao;
import de.terrestris.shogun2.model.User;
import de.terrestris.shogun2.model.UserGroup;
import de.terrestris.shogun2.rest.AbstractRestController;
import de.terrestris.shogun2.service.UserService;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/users"})
public class UserRestController<E extends User, D extends UserDao<E>, S extends UserService<E, D>>
extends AbstractRestController<E, D, S> {
    public UserRestController() {
        this(User.class);
    }

    protected UserRestController(Class<E> entityClass) {
        super(entityClass);
    }

    @Override
    @Autowired
    @Qualifier(value="userService")
    public void setService(S service) {
        this.service = service;
    }

    @RequestMapping(value={"/{userId}/userGroups"}, method={RequestMethod.GET})
    public ResponseEntity<Set<UserGroup>> findGroupsOfUser(@PathVariable Integer userId) {
        try {
            Set userGroupsSet = ((UserService)this.service).getGroupsOfUser(userId);
            return new ResponseEntity((Object)userGroupsSet, HttpStatus.OK);
        }
        catch (Exception e) {
            this.LOG.error((Object)("Error finding user with id " + userId + ": " + e.getMessage()));
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
    }
}

