/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shogun2.web;

import de.terrestris.shogun2.dao.AbstractLayerDao;
import de.terrestris.shogun2.model.layer.AbstractLayer;
import de.terrestris.shogun2.service.AbstractLayerService;
import de.terrestris.shogun2.util.data.ResultSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/abstractlayers"})
public class AbstractLayerController<E extends AbstractLayer, D extends AbstractLayerDao<E>, S extends AbstractLayerService<E, D>> {
    protected S service;

    @Autowired
    @Qualifier(value="abstractLayerService")
    public void setService(S service) {
        this.service = service;
    }

    public AbstractLayerController() {
        this(AbstractLayer.class);
    }

    protected AbstractLayerController(Class<E> type) {
    }

    @RequestMapping(value={"/getLayerGroupsOfLayer.action"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> getLayerGroupsOfLayer(Integer abstractLayerId) {
        AbstractLayer abstractLayer = (AbstractLayer)this.service.findById(abstractLayerId);
        try {
            Set layergroups = this.service.findLayerGroupsOfAbstractLayer(abstractLayer);
            return ResultSet.success((Collection)layergroups);
        }
        catch (Exception e) {
            return ResultSet.error((String)("Could not get Layergroups of layer " + abstractLayer.getName() + "."));
        }
    }

    @RequestMapping(value={"/setLayersForLayerGroup.action"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> setLayersForLayerGroup(@RequestParam(value="layerGroupId") Integer layerGroupId, @RequestParam(value="abstractLayerIds") List<Integer> abstractLayerIds) {
        try {
            List layers = this.service.setLayersForLayerGroup(layerGroupId, abstractLayerIds);
            return ResultSet.success((Collection)layers);
        }
        catch (Exception e) {
            return ResultSet.error((String)"Could not set Layers for LayerGroup");
        }
    }
}

