/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shogun2.web;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.terrestris.shogun2.dao.FileDao;
import de.terrestris.shogun2.model.File;
import de.terrestris.shogun2.service.FileService;
import de.terrestris.shogun2.util.data.ResultSet;
import de.terrestris.shogun2.web.AbstractWebController;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/file"})
public class FileController<E extends File, D extends FileDao<E>, S extends FileService<E, D>>
extends AbstractWebController<E, D, S> {
    @Autowired(required=false)
    private ObjectMapper objectMapper;

    public FileController() {
        this(File.class);
    }

    protected FileController(Class<E> entityClass) {
        super(entityClass);
    }

    @Override
    @Autowired
    @Qualifier(value="fileService")
    public void setService(S service) {
        this.service = service;
    }

    @RequestMapping(value={"/upload.action"}, method={RequestMethod.POST})
    public ResponseEntity<String> uploadFile(@RequestParam(value="file") MultipartFile uploadedFile) {
        this.LOG.debug((Object)"Requested to upload a multipart-file");
        Map responseMap = new HashMap();
        try {
            File file = ((FileService)this.service).uploadFile(uploadedFile);
            this.LOG.info((Object)("Successfully uploaded file " + file.getFileName()));
            responseMap = ResultSet.success((Object)file);
        }
        catch (Exception e) {
            this.LOG.error((Object)("Could not upload the file: " + e.getMessage()));
            responseMap = ResultSet.error((String)("Could not upload the file: " + e.getMessage()));
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.TEXT_HTML);
        String responseMapAsString = null;
        try {
            ObjectMapper om = this.objectMapper != null ? this.objectMapper : new ObjectMapper();
            responseMapAsString = om.writeValueAsString(responseMap);
        }
        catch (JsonProcessingException e) {
            String errMsg = "Error while rewriting the response Map to a String: " + e.getMessage();
            this.LOG.error((Object)errMsg);
            responseMapAsString = errMsg;
        }
        return new ResponseEntity((Object)responseMapAsString, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    @RequestMapping(value={"/get.action"}, method={RequestMethod.GET})
    public ResponseEntity<?> getFile(@RequestParam Integer id) {
        HttpHeaders responseHeaders = new HttpHeaders();
        Map responseMap = new HashMap();
        try {
            File file = (File)((FileService)this.service).findById(id);
            if (file == null) {
                throw new Exception("Could not find the file with id " + id);
            }
            byte[] fileBytes = file.getFile();
            responseHeaders.setContentType(MediaType.parseMediaType((String)file.getFileType()));
            this.LOG.info((Object)("Successfully got the file " + file.getFileName()));
            responseMap = ResultSet.success((Object)file);
            return new ResponseEntity((Object)fileBytes, (MultiValueMap)responseHeaders, HttpStatus.OK);
        }
        catch (Exception e) {
            this.LOG.error((Object)("Could not get the file: " + e.getMessage()));
            responseMap = ResultSet.error((String)("Could not get the file: " + e.getMessage()));
            responseHeaders.setContentType(MediaType.APPLICATION_JSON);
            return new ResponseEntity(responseMap, (MultiValueMap)responseHeaders, HttpStatus.OK);
        }
    }
}

