/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shogun2.web;

import de.terrestris.shogun2.service.GeoServerInterceptorService;
import de.terrestris.shogun2.util.data.ResultSet;
import de.terrestris.shogun2.util.model.Response;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class GeoServerInterceptorController<S extends GeoServerInterceptorService> {
    private static final Logger LOG = Logger.getLogger(GeoServerInterceptorController.class);
    protected S service;
    private static final String ERROR_MESSAGE = "Error while requesting a GeoServer resource: ";

    @RequestMapping(value={"/geoserver.action"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseEntity<?> interceptGeoServerRequest(HttpServletRequest request) {
        HttpHeaders responseHeaders = new HttpHeaders();
        HttpStatus responseStatus = HttpStatus.OK;
        byte[] responseBody = null;
        Response httpResponse = null;
        try {
            LOG.debug((Object)"Trying to intercept a GeoServer resource.");
            httpResponse = this.service.interceptGeoServerRequest(request);
            responseStatus = httpResponse.getStatusCode();
            responseBody = httpResponse.getBody();
            responseHeaders = httpResponse.getHeaders();
            LOG.debug((Object)"Successfully intercepted a GeoServer resource.");
            return new ResponseEntity((Object)responseBody, (MultiValueMap)responseHeaders, responseStatus);
        }
        catch (Exception e) {
            LOG.error((Object)(ERROR_MESSAGE + e.getMessage()));
            responseHeaders.setContentType(MediaType.APPLICATION_JSON);
            Map responseMsg = ResultSet.error((String)(ERROR_MESSAGE + e.getMessage()));
            return new ResponseEntity((Object)responseMsg, (MultiValueMap)responseHeaders, responseStatus);
        }
    }

    @Autowired
    public void setService(S service) {
        this.service = service;
    }
}

