/*
 * Decompiled with CFR 0.152.
 */
package multex;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ResourceBundle;
import multex.AssertionFailure;
import multex.AwtExceptionHandler;
import multex.Failure;
import multex.Msg;
import multex.Util;

public class Awt {
    static final String titlePrefix = "Error Message for ";
    private static final String _className = Awt.class.getName();
    private static final Frame _sharedOwnerFrame = new Frame();

    public static void report(Component io_ownerHook, Throwable i_throwable) {
        Awt.report(io_ownerHook, i_throwable, null);
    }

    public static void report(Component io_ownerHook, Throwable i_throwable, ResourceBundle i_resourceBundle) {
        boolean modal = io_ownerHook != null;
        try {
            Window ownerWindow = Awt.getOwnerWindow(io_ownerHook);
            new Dialog(ownerWindow, modal, i_throwable, i_resourceBundle);
        }
        catch (Throwable ex) {
            Awt.reportNoWindow(_className, ex, i_throwable);
        }
    }

    static Window getOwnerWindow(Component i_component) {
        if (i_component == null) {
            return _sharedOwnerFrame;
        }
        for (Component c = i_component; c != null; c = c.getParent()) {
            if (!(c instanceof Window)) continue;
            return (Window)c;
        }
        Util.printErrorString(_className);
        Util.printErrorString(": NO OWNER Window FOUND FOR Component ");
        Util.printErrorString(i_component.toString());
        Util.printErrorLine();
        return _sharedOwnerFrame;
    }

    static void reportNoWindow(String i_className, Throwable i_problem, Throwable i_reportee) {
        Util.printErrorLine();
        Util.printErrorString(_className);
        Util.printErrorString(": THE FOLLOWING EXCEPTION OCCURED:");
        Util.printErrorLine();
        i_problem.printStackTrace();
        Util.printErrorString(_className);
        Util.printErrorString(": WHEN CONSTRUCTING THE MESSAGE WINDOW FOR EXCEPTION:");
        Util.printErrorLine();
        i_reportee.printStackTrace();
    }

    private static void _append(TextArea io_textArea, String i_text) {
        io_textArea.setRows(io_textArea.getRows() + Awt.countLines(i_text));
        io_textArea.append(i_text);
    }

    public static int countLines(String i_text) {
        BufferedReader br = new BufferedReader(new StringReader(i_text));
        int result = 0;
        while (true) {
            String line;
            try {
                line = br.readLine();
            }
            catch (IOException ex) {
                line = null;
            }
            if (line == null) {
                return result;
            }
            ++result;
        }
    }

    public static void setAwtExceptionHandlerClass(AwtExceptionHandler i_exceptionHandler) throws Failure {
        try {
            Class<?> exceptionHandlerClass = i_exceptionHandler.getClass();
            exceptionHandlerClass.newInstance();
            System.setProperty("sun.awt.exception.handler", exceptionHandlerClass.getName());
        }
        catch (Exception e) {
            throw new Failure("Failure registering class of {0} as global AWT/Swing exception handler.", (Throwable)e, i_exceptionHandler);
        }
    }

    private Awt() {
    }

    private static class Dialog {
        private final java.awt.Dialog _dialog;
        private boolean _stackTraceShown = false;

        /*
         * WARNING - void declaration
         */
        private Dialog(Window io_owner, boolean i_modal, Throwable i_throwable, ResourceBundle i_resourceBundle) {
            void var5_7;
            String ownerTitle;
            if (io_owner instanceof Frame) {
                Frame owner = (Frame)io_owner;
                this._dialog = new java.awt.Dialog(owner);
                ownerTitle = owner.getTitle();
            } else if (io_owner instanceof java.awt.Dialog) {
                java.awt.Dialog owner = (java.awt.Dialog)io_owner;
                this._dialog = new java.awt.Dialog(owner);
                ownerTitle = owner.getTitle();
            } else {
                throw new AssertionFailure("Owner window {0} is not of class java.awt.Frame nor java.awt.Dialog", io_owner);
            }
            this._dialog.setTitle(Awt.titlePrefix + (String)var5_7);
            this._dialog.setModal(i_modal);
            this._initialize(i_throwable);
            EventQueue.invokeLater(new WindowShower(this._dialog));
        }

        private void _initialize(Throwable i_throwable) {
            Button okButton = new Button(" O  K ");
            Button traceButton = new Button("Show Stack Trace");
            Panel buttonPanel = new Panel(new BorderLayout());
            buttonPanel.add(okButton);
            buttonPanel.add((Component)traceButton, "East");
            this._dialog.add((Component)buttonPanel, "South");
            TextArea textArea = new TextArea(1, 80);
            StringBuffer messageChain = new StringBuffer();
            Msg.printMessages(messageChain, i_throwable, null);
            textArea.setBackground(Color.white);
            textArea.setForeground(Color.black);
            Awt._append(textArea, messageChain.toString());
            textArea.setEditable(false);
            this._dialog.add((Component)textArea, "Center");
            okButton.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent ev) {
                    if (ev.getKeyChar() == '\n') {
                        this._dispose();
                    }
                }
            });
            okButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ Dialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent i_) {
                    Dialog.access$200(this.this$0);
                }
            });
            traceButton.addKeyListener(new KeyAdapter(this, traceButton, textArea, i_throwable){
                private final /* synthetic */ Button val$traceButton;
                private final /* synthetic */ TextArea val$textArea;
                private final /* synthetic */ Throwable val$i_throwable;
                private final /* synthetic */ Dialog this$0;
                {
                    this.this$0 = this$0;
                    this.val$traceButton = val$traceButton;
                    this.val$textArea = val$textArea;
                    this.val$i_throwable = val$i_throwable;
                }

                public void keyTyped(KeyEvent ev) {
                    if (ev.getKeyChar() == '\n') {
                        Dialog.access$300(this.this$0, this.val$traceButton, this.val$textArea, this.val$i_throwable);
                    }
                }
            });
            traceButton.addActionListener(new ActionListener(this, traceButton, textArea, i_throwable){
                private final /* synthetic */ Button val$traceButton;
                private final /* synthetic */ TextArea val$textArea;
                private final /* synthetic */ Throwable val$i_throwable;
                private final /* synthetic */ Dialog this$0;
                {
                    this.this$0 = this$0;
                    this.val$traceButton = val$traceButton;
                    this.val$textArea = val$textArea;
                    this.val$i_throwable = val$i_throwable;
                }

                public void actionPerformed(ActionEvent i_) {
                    Dialog.access$300(this.this$0, this.val$traceButton, this.val$textArea, this.val$i_throwable);
                }
            });
            this._dialog.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ Dialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void windowClosing(WindowEvent i_) {
                    Dialog.access$200(this.this$0);
                }
            });
            Toolkit toolkit = this._dialog.getToolkit();
            toolkit.beep();
        }

        private void _dispose() {
            this._dialog.dispose();
        }

        private void _fireTraceButton(Button io_traceButton, TextArea io_textArea, Throwable i_throwable) {
            io_traceButton.setVisible(false);
            StringBuffer buffer = new StringBuffer();
            buffer.append(Util.lineSeparator);
            buffer.append(Util.lineSeparator);
            buffer.append(Msg.stackTraceFollows);
            buffer.append(Util.lineSeparator);
            Msg.printStackTrace(buffer, i_throwable);
            String stackTrace = buffer.toString();
            Awt._append(io_textArea, stackTrace);
            io_textArea.insert("", 0);
            this._dialog.pack();
            this._stackTraceShown = true;
        }

        static /* synthetic */ void access$300(Dialog x0, Button x1, TextArea x2, Throwable x3) {
            x0._fireTraceButton(x1, x2, x3);
        }
    }

    static class WindowShower
    implements Runnable {
        final Window _window;

        public WindowShower(Window io_window) {
            this._window = io_window;
        }

        public void run() {
            this._window.pack();
            this._window.show();
        }
    }
}

