/*
 * Decompiled with CFR 0.152.
 */
package multex;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ResourceBundle;
import multex.MsgText;
import multex.Util;

public class Msg {
    private static final String _className = new Msg().getClass().getName();
    private static final String _beep = "\u0007";
    public static String stackTraceFollows = "----------Stack Trace follows:----------";

    public static void printReport(Throwable i_throwable) {
        Msg.printReport(System.err, i_throwable);
        System.err.print(_beep);
    }

    public static void printReport(PrintStream io_destination, Throwable i_throwable) {
        io_destination.println(Msg.getReport(i_throwable));
        Msg._flushPrint(io_destination, i_throwable, "REPORT");
    }

    public static void printReport(PrintWriter io_destination, Throwable i_throwable) {
        io_destination.println(Msg.getReport(i_throwable));
        Msg._flushPrint(io_destination, i_throwable, "REPORT");
    }

    public static void printReport(StringBuffer io_destination, Throwable i_throwable) {
        Msg.printReport(io_destination, i_throwable, null);
    }

    public static void printReport(StringBuffer io_destination, Throwable i_throwable, ResourceBundle i_resourceBundle) {
        Msg.printMessages(io_destination, i_throwable, i_resourceBundle);
        io_destination.append(Util.lineSeparator);
        io_destination.append(stackTraceFollows);
        io_destination.append(Util.lineSeparator);
        Msg.printStackTrace(io_destination, i_throwable);
    }

    public static String getReport(Throwable i_throwable) {
        StringBuffer result = new StringBuffer();
        Msg.printReport(result, i_throwable);
        return result.toString();
    }

    public static void printMessages(Throwable i_throwable) {
        Msg.printMessages(System.err, i_throwable);
    }

    public static void printMessages(PrintStream io_destination, Throwable i_throwable) {
        Msg.printMessages(new PrintWriter(io_destination, true), i_throwable);
    }

    public static void printMessages(PrintWriter io_destination, Throwable i_throwable) {
        io_destination.print(_beep);
        StringBuffer text = new StringBuffer();
        Msg.printMessages(text, i_throwable);
        io_destination.println(text);
        Msg._flushPrint(io_destination, i_throwable, "MESSAGES");
    }

    private static void _flushPrint(PrintWriter io_destination, Throwable i_throwable, String i_what) {
        io_destination.flush();
        Msg.checkPrintError(io_destination.checkError(), i_throwable, i_what);
    }

    private static void _flushPrint(PrintStream io_destination, Throwable i_throwable, String i_what) {
        io_destination.flush();
        Msg.checkPrintError(io_destination.checkError(), i_throwable, i_what);
    }

    private static void checkPrintError(boolean i_error, Throwable i_throwable, String i_what) {
        if (i_error) {
            Util.printErrorString(_beep);
            Util.printErrorLine();
            Util.printErrorString(_className);
            Util.printErrorString(": COULD NOT PRINT ");
            Util.printErrorString(i_what);
            Util.printErrorString(" FOR:");
            Util.printErrorLine();
            i_throwable.printStackTrace();
        }
    }

    public static String getMessages(Throwable i_throwable) {
        StringBuffer result = new StringBuffer();
        MsgText.appendMessageTree(result, i_throwable, null);
        return result.toString();
    }

    public static void printMessages(StringBuffer io_destination, Throwable i_throwable) {
        Msg.printMessages(io_destination, i_throwable, null);
    }

    public static void printMessages(StringBuffer io_destination, Throwable i_throwable, ResourceBundle i_resourceBundle) {
        MsgText.appendMessageTree(io_destination, i_throwable, i_resourceBundle);
    }

    public static void printStackTrace(Throwable i_throwable) {
        Msg.printStackTrace(System.err, i_throwable);
    }

    public static void printStackTrace(PrintStream io_destination, Throwable i_throwable) {
        Msg.printStackTrace(new PrintWriter(io_destination, true), i_throwable);
    }

    public static void printStackTrace(PrintWriter io_destination, Throwable i_throwable) {
        io_destination.print(Msg.getStackTrace(i_throwable));
        io_destination.flush();
    }

    public static String getStackTrace(Throwable i_throwable) {
        StringBuffer result = new StringBuffer();
        Util.appendCompactStackTrace(result, i_throwable);
        return result.toString();
    }

    public static void printStackTrace(StringBuffer io_destination, Throwable i_throwable) {
        Util.appendCompactStackTrace(io_destination, i_throwable);
    }

    private Msg() {
    }
}

