/*
 * Decompiled with CFR 0.152.
 */
package multex;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import multex.Failure;
import multex.MultexException;
import multex.Util;

public class MsgText {
    private static final String _className = MsgText.class.getName();
    public static final String resourceBundleName = "MsgText";
    public static final String causeMarker = "CAUSE: ";
    public static final String causeMarkerKey = _className + ".causeMarker";
    private static final int _maxNumberOfIndexParams = 10;
    private static boolean _internationalization = false;
    private static ResourceBundle _resourceBundle = null;
    private static boolean _loadMessagesTried = false;

    public static synchronized void setInternationalization(boolean i_internationalization) {
        _internationalization = i_internationalization;
        _resourceBundle = _internationalization ? MsgText._tryLoadMessages() : null;
    }

    public static synchronized void setInternationalization(ResourceBundle i_resourceBundle) throws IllegalArgumentException {
        if (i_resourceBundle == null) {
            throw new IllegalArgumentException("ResourceBundle must not be null");
        }
        _internationalization = true;
        _resourceBundle = i_resourceBundle;
    }

    public static ResourceBundle getResourceBundle() {
        return _resourceBundle;
    }

    protected static void appendMessageTree(StringBuffer io_destination, Throwable i_throwable, ResourceBundle i_resourceBundle) {
        ResourceBundle resourceBundle = i_resourceBundle != null ? i_resourceBundle : MsgText.getResourceBundle();
        String causeMarker = MsgText._getCauseMarker(resourceBundle);
        if (null == i_throwable) {
            io_destination.append("null Throwable provided to ").append(_className).append(".appendMessageTree(...)");
            return;
        }
        int level = 0;
        MsgText._appendMessageTreeRecursively(io_destination, i_throwable, resourceBundle, causeMarker, level);
    }

    private static void _appendMessageTreeRecursively(StringBuffer io_destination, Throwable i_throwable, ResourceBundle i_resourceBundle, String i_causeMarker, int i_level) {
        Failure failure;
        Throwable directCause = Util.getCause(i_throwable);
        boolean isTunnelling = i_throwable instanceof Failure ? ((failure = (Failure)i_throwable).getDefaultMessageTextPattern() == null && !failure.hasParameters() ? directCause != null : false) : false;
        if (!isTunnelling) {
            MsgText._appendCauseLine(io_destination, i_throwable, i_resourceBundle, i_causeMarker, i_level);
        }
        if (directCause != null) {
            MsgText._appendMessageTreeRecursively(io_destination, directCause, i_resourceBundle, i_causeMarker, i_level + (isTunnelling ? 0 : 1));
        }
        if (!(i_throwable instanceof MultexException)) {
            return;
        }
        MultexException multexException = (MultexException)((Object)i_throwable);
        Object[] params = multexException.getParameters();
        if (null == params) {
            return;
        }
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            if (!(param instanceof Throwable)) continue;
            Throwable cause = (Throwable)param;
            MsgText._appendMessageTreeRecursively(io_destination, cause, i_resourceBundle, i_causeMarker, i_level + 1);
        }
    }

    private static void _appendCauseLine(StringBuffer io_destination, Throwable i_throwable, ResourceBundle resourceBundle, String causeMarker, int level) {
        if (level > 0) {
            io_destination.append(Util.lineSeparator);
            Util.appendCauseIndentation(io_destination, level);
            io_destination.append(causeMarker);
        }
        MsgText._appendMessageLineDeletingPreviousOccurence(io_destination, i_throwable, resourceBundle);
    }

    private static void _appendMessageLineDeletingPreviousOccurence(StringBuffer io_destination, Throwable t, ResourceBundle resourceBundle) {
        int firstOccurenceIndex;
        int previousLength = io_destination.length();
        String lastLine = MsgText.appendMessageLine(io_destination, t, resourceBundle);
        if (lastLine != null && (firstOccurenceIndex = io_destination.indexOf(lastLine)) < previousLength) {
            io_destination.replace(firstOccurenceIndex, firstOccurenceIndex + lastLine.length(), "...");
        }
    }

    public static void appendMessageLine(StringBuffer io_destination, Throwable i_throwable) {
        MsgText.appendMessageLine(io_destination, i_throwable, MsgText.getResourceBundle());
    }

    public static String appendMessageLine(StringBuffer io_destination, Throwable i_throwable, ResourceBundle i_resourceBundle) {
        try {
            String textPattern = MsgText.getMessageTextPattern(i_throwable, i_resourceBundle);
            Object[] parameters = MsgText._getParameters(i_throwable);
            if (textPattern != null && parameters != null) {
                Locale locale = i_resourceBundle == null ? null : i_resourceBundle.getLocale();
                MsgText.format(io_destination, textPattern, parameters, locale);
            } else if (textPattern != null && i_throwable instanceof MultexException) {
                io_destination.append(textPattern);
            } else if (textPattern != null) {
                io_destination.append(textPattern);
                String detailMessage = i_throwable.getMessage();
                if (detailMessage != null) {
                    io_destination.append(": ");
                    io_destination.append(detailMessage);
                }
            } else {
                String result = Util.toString(i_throwable);
                io_destination.append(result);
                return result;
            }
            return null;
        }
        catch (Exception ex) {
            Util.printErrorLine();
            Util.printErrorString(_className);
            Util.printErrorString(": WHEN PREPARING MESSAGE LINE OCCURRED EXCEPTION:");
            Util.printErrorLine();
            ex.printStackTrace();
            String result = Util.toString(i_throwable);
            io_destination.append(result);
            return result;
        }
    }

    static void format(StringBuffer io_destination, String i_textPattern, Object[] i_parameters, Locale i_locale) {
        MessageFormat format = new MessageFormat(i_textPattern);
        if (i_locale != null) {
            format.setLocale(i_locale);
        }
        format.format(i_parameters, io_destination, (FieldPosition)null);
    }

    static String getMessageTextPattern(Throwable i_throwable) {
        return MsgText.getMessageTextPattern(i_throwable, _resourceBundle);
    }

    static String getMessageTextPattern(Throwable i_throwable, ResourceBundle i_resourceBundle) {
        String className = i_throwable.getClass().getName();
        String defaultPattern = i_throwable instanceof MultexException ? ((MultexException)((Object)i_throwable)).getDefaultMessageTextPattern() : null;
        return MsgText._getResource(i_resourceBundle, className, defaultPattern);
    }

    private static String _getResource(ResourceBundle i_resourceBundle, String i_key, String i_defaultValue) {
        if (i_resourceBundle == null) {
            return i_defaultValue;
        }
        try {
            return i_resourceBundle.getString(i_key);
        }
        catch (MissingResourceException ex) {
            return i_defaultValue;
        }
    }

    private static Object[] _getParameters(Throwable i_throwable) {
        if (!(i_throwable instanceof MultexException)) {
            return null;
        }
        return ((MultexException)((Object)i_throwable)).getParameters();
    }

    private static ResourceBundle _tryLoadMessages() {
        if (_loadMessagesTried) {
            return null;
        }
        try {
            _loadMessagesTried = true;
            return ResourceBundle.getBundle(resourceBundleName);
        }
        catch (MissingResourceException ex) {
            Util.printErrorString(ex.toString());
            Util.printErrorLine();
            Util.printErrorString(_className);
            Util.printErrorString(": Unable to load exception message texts from the ResourceBundle");
            Util.printErrorLine();
            Util.printErrorString(resourceBundleName);
            Util.printErrorLine();
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static String _getCauseMarker(ResourceBundle i_resourceBundle) {
        return MsgText._getResource(i_resourceBundle, causeMarkerKey, causeMarker);
    }

    private MsgText() {
    }
}

