/*
 * Decompiled with CFR 0.152.
 */
package multex;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import multex.AssertionFailure;
import multex.Awt;
import multex.Msg;
import multex.Util;

public class Swing {
    private static final String _className = Swing.class.getName();

    public static void report(Component io_ownerHook, Throwable i_throwable) {
        Swing.report(io_ownerHook, i_throwable, null);
    }

    public static void report(Component io_ownerHook, Throwable i_throwable, ResourceBundle i_resourceBundle) {
        boolean modal = io_ownerHook != null;
        try {
            Window ownerWindow = Awt.getOwnerWindow(io_ownerHook);
            new Dialog(ownerWindow, modal, i_throwable, i_resourceBundle);
        }
        catch (Throwable ex) {
            Awt.reportNoWindow(_className, ex, i_throwable);
        }
    }

    private static void _append(JTextArea io_textArea, String i_text) {
        io_textArea.setRows(io_textArea.getRows() + Awt.countLines(i_text));
        io_textArea.append(i_text);
    }

    private Swing() {
    }

    private static class Dialog {
        private final JDialog _dialog;
        private boolean _stackTraceShown = false;

        /*
         * WARNING - void declaration
         */
        private Dialog(Window io_owner, boolean i_modal, Throwable i_throwable, ResourceBundle i_resourceBundle) {
            void var5_7;
            String ownerTitle;
            if (io_owner instanceof Frame) {
                Frame owner = (Frame)io_owner;
                this._dialog = new JDialog(owner);
                ownerTitle = owner.getTitle();
            } else if (io_owner instanceof java.awt.Dialog) {
                java.awt.Dialog owner = (java.awt.Dialog)io_owner;
                this._dialog = new JDialog(owner);
                ownerTitle = owner.getTitle();
            } else {
                throw new AssertionFailure("Owner window {0} is not of class java.awt.Frame nor java.awt.Dialog", io_owner);
            }
            this._dialog.setTitle("Error Message for " + (String)var5_7);
            this._dialog.setModal(i_modal);
            this._initialize(i_throwable, i_resourceBundle);
            EventQueue.invokeLater(new Awt.WindowShower(this._dialog));
        }

        private void _initialize(Throwable i_throwable, ResourceBundle i_resourceBundle) {
            StringBuffer messageChain = new StringBuffer();
            Msg.printMessages(messageChain, i_throwable, i_resourceBundle);
            JTextArea textArea = new JTextArea();
            textArea.setBackground(Color.white);
            textArea.setForeground(Color.black);
            Swing._append(textArea, messageChain.toString());
            textArea.setEditable(false);
            JButton okButton = new JButton(" O  K ");
            okButton.requestDefaultFocus();
            JButton traceButton = new JButton("Show Stack Trace");
            traceButton.requestDefaultFocus();
            traceButton.setNextFocusableComponent(okButton);
            okButton.setNextFocusableComponent(traceButton);
            JPanel buttonPanel = new JPanel(new BorderLayout());
            buttonPanel.add(okButton);
            buttonPanel.add((Component)traceButton, "East");
            JPanel contentPanel = new JPanel(new BorderLayout());
            contentPanel.add((Component)textArea, "Center");
            contentPanel.add((Component)buttonPanel, "South");
            JScrollPane scrollPane = new JScrollPane(contentPanel);
            this._dialog.getContentPane().add(scrollPane);
            okButton.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent ev) {
                    if (ev.getKeyChar() == '\n') {
                        this._dispose();
                    }
                }
            });
            okButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ Dialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent i_) {
                    Dialog.access$200(this.this$0);
                }
            });
            traceButton.addKeyListener(new KeyAdapter(this, traceButton, textArea, i_throwable){
                private final /* synthetic */ JButton val$traceButton;
                private final /* synthetic */ JTextArea val$textArea;
                private final /* synthetic */ Throwable val$i_throwable;
                private final /* synthetic */ Dialog this$0;
                {
                    this.this$0 = this$0;
                    this.val$traceButton = val$traceButton;
                    this.val$textArea = val$textArea;
                    this.val$i_throwable = val$i_throwable;
                }

                public void keyTyped(KeyEvent ev) {
                    if (ev.getKeyChar() == '\n') {
                        Dialog.access$300(this.this$0, this.val$traceButton, this.val$textArea, this.val$i_throwable);
                    }
                }
            });
            traceButton.addActionListener(new ActionListener(this, traceButton, textArea, i_throwable){
                private final /* synthetic */ JButton val$traceButton;
                private final /* synthetic */ JTextArea val$textArea;
                private final /* synthetic */ Throwable val$i_throwable;
                private final /* synthetic */ Dialog this$0;
                {
                    this.this$0 = this$0;
                    this.val$traceButton = val$traceButton;
                    this.val$textArea = val$textArea;
                    this.val$i_throwable = val$i_throwable;
                }

                public void actionPerformed(ActionEvent i_) {
                    Dialog.access$300(this.this$0, this.val$traceButton, this.val$textArea, this.val$i_throwable);
                }
            });
            this._dialog.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ Dialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void windowClosing(WindowEvent i_) {
                    Dialog.access$200(this.this$0);
                }
            });
            Toolkit toolkit = this._dialog.getToolkit();
            toolkit.beep();
        }

        private void _dispose() {
            this._dialog.dispose();
        }

        private void _fireTraceButton(JButton io_traceButton, JTextArea io_textArea, Throwable i_throwable) {
            io_traceButton.setVisible(false);
            StringBuffer buffer = new StringBuffer();
            buffer.append(Util.lineSeparator);
            buffer.append(Util.lineSeparator);
            buffer.append(Msg.stackTraceFollows);
            buffer.append(Util.lineSeparator);
            Msg.printStackTrace(buffer, i_throwable);
            String stackTrace = buffer.toString();
            Swing._append(io_textArea, stackTrace);
            io_textArea.insert("", 0);
            this._dialog.pack();
            this._stackTraceShown = true;
        }

        static /* synthetic */ void access$300(Dialog x0, JButton x1, JTextArea x2, Throwable x3) {
            x0._fireTraceButton(x1, x2, x3);
        }
    }
}

