/*
 * Decompiled with CFR 0.152.
 */
package multex;

import multex.CauseGetter;
import multex.Exc;
import multex.MultexException;
import multex.ReflectionCauseGetter;

public class Util {
    private static CauseGetter _causeGetter;
    private static final String _jreVersion;
    private static final String _minimumJreVersion = "1.4";
    private static final boolean _jreHasExceptionChaining;
    public static final String lineSeparator;
    public static final String wasCausing = "WAS CAUSING:";
    public static final char causeIndenter = '+';
    private static final String _className;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Object[] clone(Object[] i_array) {
        if (i_array == null) {
            return null;
        }
        Object[] result = new Object[i_array.length];
        System.arraycopy(i_array, 0, result, 0, i_array.length);
        return result;
    }

    public static final void setCauseGetter(CauseGetter i_causeGetter) {
        _causeGetter = i_causeGetter;
    }

    public static final Throwable[] getCauses(Throwable i_throwable) {
        Object[] params;
        int count = 0;
        Throwable cause = _causeGetter.getCause(i_throwable);
        if (cause != null) {
            ++count;
        }
        if ((count += Util._countThrowables(params = Util._getParams(i_throwable))) <= 0) {
            return null;
        }
        Throwable[] result = new Throwable[count];
        int causeIndex = 0;
        if (cause != null) {
            result[causeIndex] = cause;
            ++causeIndex;
        }
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                Throwable throwable;
                Object param = params[i];
                if (!(param instanceof Throwable)) continue;
                result[causeIndex] = throwable = (Throwable)param;
                ++causeIndex;
            }
        }
        return result;
    }

    private static Object[] _getParams(Throwable i_throwable) {
        if (i_throwable instanceof MultexException) {
            MultexException multexException = (MultexException)((Object)i_throwable);
            return multexException.getParameters();
        }
        return null;
    }

    private static int _countThrowables(Object[] params) {
        int result = 0;
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                Object param = params[i];
                if (!(param instanceof Throwable)) continue;
                ++result;
            }
        }
        return result;
    }

    public static final Throwable getCause(Throwable i_throwable) {
        return _causeGetter.getCause(i_throwable);
    }

    public static boolean jreHasExceptionChaining() {
        return _jreHasExceptionChaining;
    }

    public static Throwable getContainedException(Throwable i_throwableChain, Class i_expectedThrowableClass) {
        Throwable result = i_throwableChain;
        while (result != null) {
            Throwable cause;
            if (i_expectedThrowableClass.isInstance(result)) {
                return result;
            }
            result = cause = Util.getCause(result);
        }
        return result;
    }

    public static final Throwable getOriginalException(Throwable i_throwable) {
        Throwable result = i_throwable;
        Throwable cause;
        while ((cause = Util.getCause(result)) != null) {
            result = cause;
        }
        return result;
    }

    static void printErrorString(String i_string) {
        System.err.print(i_string);
    }

    static void printErrorLine() {
        System.err.println();
    }

    static void appendCompactStackTrace(StringBuffer io_destination, Throwable i_throwable) {
        if (i_throwable == null) {
            io_destination.append("null Throwable provided to ").append(_className).append(".appendCompactStackTrace(...)");
            return;
        }
        Util._appendCompactStackTraceRecursively(io_destination, i_throwable, new StackTraceElement[0], 0);
    }

    static void _appendCompactStackTraceRecursively(StringBuffer io_destination, Throwable i_reportee, StackTraceElement[] i_causeeElements, int level) {
        MultexException multexException;
        Object[] params;
        Throwable directCause = Util.getCause(i_reportee);
        StackTraceElement[] reporteeElements = i_reportee.getStackTrace();
        int causesCount = 0;
        if (directCause != null) {
            ++causesCount;
            Util._appendCompactStackTraceRecursively(io_destination, directCause, reporteeElements, level + 1);
        }
        if (i_reportee instanceof MultexException && null != (params = (multexException = (MultexException)((Object)i_reportee)).getParameters())) {
            for (int i = 0; i < params.length; ++i) {
                Object param = params[i];
                if (!(param instanceof Throwable)) continue;
                ++causesCount;
                Throwable cause = (Throwable)param;
                Util._appendCompactStackTraceRecursively(io_destination, cause, reporteeElements, level + 1);
            }
        }
        if (causesCount > 0) {
            io_destination.append(wasCausing);
            io_destination.append(lineSeparator);
        }
        Util.appendCauseIndentation(io_destination, level);
        String reporteeString = Util.toString(i_reportee);
        io_destination.append(reporteeString);
        io_destination.append(lineSeparator);
        Util.appendIrredundantTraceLines(io_destination, reporteeElements, i_causeeElements);
    }

    static void appendIrredundantTraceLines(StringBuffer io_destination, StackTraceElement[] i_reporteeElements, StackTraceElement[] i_causeeElements) {
        StackTraceElement re;
        if (!$assertionsDisabled && io_destination == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && i_reporteeElements == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && i_causeeElements == null) {
            throw new AssertionError();
        }
        int ri = i_reporteeElements.length - 1;
        for (int ci = i_causeeElements.length - 1; ri >= 0 && ci >= 0 && (re = i_reporteeElements[ri]) != null && re.equals(i_causeeElements[ci]); --ri, --ci) {
        }
        int lastSignificantIndex = ri;
        for (int i = 0; i <= lastSignificantIndex; ++i) {
            io_destination.append("\tat ");
            io_destination.append(i_reporteeElements[i].toString());
            io_destination.append(lineSeparator);
        }
    }

    static String getUserInformation(MultexException i_exception) {
        boolean hasParameters;
        String text = i_exception.getDefaultMessageTextPattern();
        Object[] parameters = i_exception.getParameters();
        boolean hasText = text != null;
        boolean bl = hasParameters = parameters != null;
        if (!hasText && !hasParameters) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        if (hasText) {
            result.append(text);
        }
        if (hasParameters && parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                Object parameter = parameters[i];
                if (parameter instanceof Throwable) continue;
                result.append(lineSeparator);
                result.append("    ");
                Util.appendParam(result, Integer.toString(i), parameter);
            }
        }
        return result.toString();
    }

    static void appendParam(StringBuffer io_buf, String i_name, Object i_value) {
        io_buf.append("{");
        io_buf.append(i_name);
        io_buf.append("} = '");
        io_buf.append(i_value);
        io_buf.append("'");
    }

    static void checkClass(Exception i_exception, String i_suffix) {
        Class<?> exceptionClass = i_exception.getClass();
        String exceptionName = exceptionClass.getName();
        if (!exceptionName.endsWith(i_suffix)) {
            Util.printErrorString("The name of subclass ");
            Util.printErrorString(exceptionName);
            Util.printErrorString(" of ");
            Util.printErrorString(i_suffix);
            Util.printErrorString(" should end in ");
            Util.printErrorString(i_suffix);
            Util.printErrorString("!");
            Util.printErrorLine();
        }
    }

    public static String toString(Throwable i_throwable) {
        String throwableString = i_throwable.toString();
        if (i_throwable instanceof MultexException) {
            return throwableString;
        }
        String className = i_throwable.getClass().getName();
        String detailMessage = i_throwable.getMessage();
        if (throwableString.indexOf(className) >= 0) {
            return throwableString;
        }
        return className + (detailMessage == null ? "" : ": " + detailMessage) + "; Caused by: " + throwableString;
    }

    static void appendCauseIndentation(StringBuffer io_destination, int i_level) {
        for (int i = 0; i < i_level; ++i) {
            io_destination.append('+');
        }
    }

    static {
        $assertionsDisabled = !Util.class.desiredAssertionStatus();
        _causeGetter = new ReflectionCauseGetter();
        _jreVersion = System.getProperty("java.version");
        _jreHasExceptionChaining = _jreVersion.compareTo(_minimumJreVersion) >= 0;
        lineSeparator = System.getProperty("line.separator");
        _className = Util.class.getName();
        if (!_jreHasExceptionChaining) {
            throw new RuntimeException("This version of MulTEx needs a Java Runtime Environment >= 1.4, but runs on " + _jreVersion);
        }
    }

    public static final class MyDemoExc
    extends Exc {
        public MyDemoExc(String i_action, String i_person) {
            super(null, (Object)i_action, (Object)i_person);
        }
    }
}

