/*
 * Decompiled with CFR 0.152.
 */
package multex.tool;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.RootDoc;
import java.io.FileWriter;
import java.io.PrintWriter;
import multex.Failure;

public class ExceptionMessagesDoclet {
    private static final String myClassName = "ExceptionMessagesDoclet";
    private static final String JAVA_LANG_OBJECT = Object.class.getName();
    private static final String JAVA_LANG_THROWABLE = Throwable.class.getName();
    private static String outFileName;
    private static PrintWriter out;

    public static int optionLength(String option) {
        if ("-out".equals(option)) {
            return 2;
        }
        return 0;
    }

    public static boolean start(RootDoc i_rootDoc) throws Exception {
        new ExceptionMessagesDoclet()._execute(i_rootDoc);
        System.out.println("\nAll exception message text patterns have been appended to file " + outFileName);
        return true;
    }

    private void _execute(RootDoc rootDoc) throws Exception {
        outFileName = this._getOutputFilename(rootDoc.options());
        out = new PrintWriter(new FileWriter(outFileName, true));
        this._visitAll(rootDoc);
        out.close();
    }

    private String _getOutputFilename(String[][] options) {
        for (int i = 0; i < options.length; ++i) {
            String[] option = options[i];
            if ("-overview".equals(option[0])) {
                return option[1];
            }
            if (!"-out".equals(option[0])) continue;
            return option[1];
        }
        throw new Failure("Missing name of output file, where to append the extracted exception text property definitions.\nUse Javadoc option -overview or -out to indicate it!", (Throwable)null);
    }

    private void _visitAll(RootDoc rootDoc) throws Exception {
        ClassDoc[] classDocs = rootDoc.classes();
        for (int i = 0; i < classDocs.length; ++i) {
            ClassDoc classDoc = classDocs[i];
            this._visitClass(classDoc);
        }
    }

    private void _visitClass(ClassDoc classDoc) throws TooNestedThrowableException {
        this._printMessageTextPatternOfThrowable(classDoc);
    }

    private void _printMessageTextPatternOfThrowable(ClassDoc classDoc) throws TooNestedThrowableException {
        if (classDoc.isAbstract() || classDoc.isOrdinaryClass()) {
            return;
        }
        if (!this._isSubclassOfThrowable(classDoc)) {
            return;
        }
        String commentText = classDoc.commentText();
        if (commentText.length() < 10) {
            System.err.println("Too short (<10ch) message text \"" + commentText + "\" for Throwable " + classDoc);
            return;
        }
        String key = this._internalClassName(classDoc);
        out.print(key);
        out.print(" = ");
        out.print(commentText);
        out.println();
    }

    private String _internalClassName(ClassDoc classDoc) throws TooNestedThrowableException {
        String canonicalName = classDoc.toString();
        ClassDoc containingClass = classDoc.containingClass();
        if (null == containingClass) {
            return canonicalName;
        }
        if (null != containingClass.containingClass()) {
            throw new TooNestedThrowableException(canonicalName);
        }
        int indexOfLastDollar = canonicalName.lastIndexOf(46);
        char[] characters = canonicalName.toCharArray();
        characters[indexOfLastDollar] = 36;
        String result = new String(characters);
        return result;
    }

    private boolean _isSubclassOfThrowable(ClassDoc classDoc) {
        ClassDoc superClass = classDoc.superclass();
        String superClassName = superClass.toString();
        if (JAVA_LANG_THROWABLE.equals(superClassName)) {
            return true;
        }
        if (JAVA_LANG_OBJECT.equals(superClassName)) {
            return false;
        }
        return this._isSubclassOfThrowable(superClass);
    }

    public static final class TooNestedThrowableException
    extends Exception {
        public TooNestedThrowableException(String canonicalName) {
            super("Throwable class " + canonicalName + " has more than one nesting level. Handling not yet implemented.");
        }
    }
}

