/*
 * (c) Copyright 2018 Thalia Bücher GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.thalia.boot.tracing.hystrix;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import de.thalia.boot.tracing.hystrix.HystrixRequestHolder;

/**
 * Dieser Filter initialisiert den {@link HystrixRequestContext} für den aktuellen Request. Dadurch können
 * {@link com.netflix.hystrix.strategy.concurrency.HystrixRequestVariable} benutzt werden. Außerdem wird der Request in dem
 * {@link HystrixRequestHolder} gespeichert.
 */
public class HystrixRequestContextFilter implements Filter {

    @Override
    public void init(final FilterConfig filterConfig) {
    }

    @Override
    public void doFilter(final ServletRequest request, final ServletResponse response, final FilterChain chain)
            throws IOException, ServletException {
        try (HystrixRequestContext ignored = HystrixRequestContext.initializeContext()) {
            HystrixRequestHolder.getInstance().set((HttpServletRequest) request);
            chain.doFilter(request, response);
        }
    }

    @Override
    public void destroy() {
    }

}
