/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.config;

import ch.qos.logback.classic.LoggerContext;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.jhipster.config.JHipsterProperties;
import io.github.jhipster.config.logging.LoggingUtils;
import java.util.HashMap;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class LoggingConfiguration {
    public LoggingConfiguration(@Value(value="${spring.application.name}") String appName, @Value(value="${server.port}") String serverPort, JHipsterProperties jHipsterProperties, ObjectMapper mapper) throws JsonProcessingException {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("app_name", appName);
        map.put("app_port", serverPort);
        String customFields = mapper.writeValueAsString(map);
        JHipsterProperties.Logging loggingProperties = jHipsterProperties.getLogging();
        JHipsterProperties.Logging.Logstash logstashProperties = loggingProperties.getLogstash();
        if (loggingProperties.isUseJsonFormat()) {
            LoggingUtils.addJsonConsoleAppender((LoggerContext)context, (String)customFields);
        }
        if (logstashProperties.isEnabled()) {
            LoggingUtils.addLogstashTcpSocketAppender((LoggerContext)context, (String)customFields, (JHipsterProperties.Logging.Logstash)logstashProperties);
        }
        if (loggingProperties.isUseJsonFormat() || logstashProperties.isEnabled()) {
            LoggingUtils.addContextListener((LoggerContext)context, (String)customFields, (JHipsterProperties.Logging)loggingProperties);
        }
        if (jHipsterProperties.getMetrics().getLogs().isEnabled()) {
            LoggingUtils.setMetricsMarkerLogbackFilter((LoggerContext)context, (boolean)loggingProperties.isUseJsonFormat());
        }
    }
}

