/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service;

import de.trustable.ca3s.core.config.audit.AuditEventConverter;
import de.trustable.ca3s.core.repository.PersistenceAuditEventRepository;
import io.github.jhipster.config.JHipsterProperties;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AuditEventService {
    private final Logger log = LoggerFactory.getLogger(AuditEventService.class);
    private final JHipsterProperties jHipsterProperties;
    private final PersistenceAuditEventRepository persistenceAuditEventRepository;
    private final AuditEventConverter auditEventConverter;

    public AuditEventService(PersistenceAuditEventRepository persistenceAuditEventRepository, AuditEventConverter auditEventConverter, JHipsterProperties jhipsterProperties) {
        this.persistenceAuditEventRepository = persistenceAuditEventRepository;
        this.auditEventConverter = auditEventConverter;
        this.jHipsterProperties = jhipsterProperties;
    }

    @Scheduled(cron="0 0 12 * * ?")
    public void removeOldAuditEvents() {
        this.persistenceAuditEventRepository.findByAuditEventDateBefore(Instant.now().minus(this.jHipsterProperties.getAuditEvents().getRetentionPeriod(), ChronoUnit.DAYS)).forEach(auditEvent -> {
            this.log.debug("Deleting audit data {}", auditEvent);
            this.persistenceAuditEventRepository.delete(auditEvent);
        });
    }

    public Page<AuditEvent> findAll(Pageable pageable) {
        return this.persistenceAuditEventRepository.findAll(pageable).map(arg_0 -> ((AuditEventConverter)this.auditEventConverter).convertToAuditEvent(arg_0));
    }

    public Page<AuditEvent> findByDates(Instant fromDate, Instant toDate, Pageable pageable) {
        return this.persistenceAuditEventRepository.findAllByAuditEventDateBetween(fromDate, toDate, pageable).map(arg_0 -> ((AuditEventConverter)this.auditEventConverter).convertToAuditEvent(arg_0));
    }

    public Optional<AuditEvent> find(Long id) {
        return this.persistenceAuditEventRepository.findById((Object)id).map(arg_0 -> ((AuditEventConverter)this.auditEventConverter).convertToAuditEvent(arg_0));
    }
}

