/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.dto;

import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.enumeration.CsrStatus;
import de.trustable.ca3s.core.domain.enumeration.PipelineType;
import de.trustable.ca3s.core.service.dto.AuditView;
import de.trustable.ca3s.core.service.util.CSRUtil;
import java.io.Serializable;
import java.time.Instant;
import java.util.Set;

public class CSRView
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private Long certificateId;
    private CsrStatus status;
    private String subject;
    private String sans;
    private PipelineType pipelineType;
    private Instant rejectedOn;
    private String rejectionReason;
    private String requestedBy;
    private String processingCA;
    private String pipelineName;
    private String x509KeySpec;
    private String keyLength;
    private String signingAlgorithm;
    private String publicKeyAlgorithm;
    private Instant requestedOn;
    private AuditView[] auditViewArr;

    public CSRView() {
    }

    public CSRView(CSRUtil csrUtil, CSR csr) {
        this.id = csr.getId();
        this.certificateId = csr.getCertificate().getId();
        this.subject = csr.getSubject();
        this.sans = csr.getSans();
        this.status = csr.getStatus();
        this.publicKeyAlgorithm = csr.getPublicKeyAlgorithm();
        this.signingAlgorithm = csr.getSigningAlgorithm();
        this.x509KeySpec = csr.getx509KeySpec();
        Set attributes = csr.getCsrAttributes();
        this.requestedBy = csrUtil.getCSRAttribute(csr, "REQUESTOR_NAME");
        this.processingCA = csrUtil.getCSRAttribute(csr, "PROCESSING_CA");
        this.pipelineName = csr.getPipeline().getName();
        this.requestedOn = csr.getRequestedOn();
    }

    public Long getId() {
        return this.id;
    }

    public Long getCertificateId() {
        return this.certificateId;
    }

    public CsrStatus getStatus() {
        return this.status;
    }

    public String getProcessingCA() {
        return this.processingCA;
    }

    public String getPipelineName() {
        return this.pipelineName;
    }

    public String getX509KeySpec() {
        return this.x509KeySpec;
    }

    public String getKeyLength() {
        return this.keyLength;
    }

    public String getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public String getPublicKeyAlgorithm() {
        return this.publicKeyAlgorithm;
    }

    public Instant getRequestedOn() {
        return this.requestedOn;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCertificateId(Long certificateId) {
        this.certificateId = certificateId;
    }

    public void setStatus(CsrStatus status) {
        this.status = status;
    }

    public void setProcessingCA(String processingCA) {
        this.processingCA = processingCA;
    }

    public void setPipelineName(String pipelineName) {
        this.pipelineName = pipelineName;
    }

    public void setX509KeySpec(String x509KeySpec) {
        this.x509KeySpec = x509KeySpec;
    }

    public void setKeyLength(String keyLength) {
        this.keyLength = keyLength;
    }

    public void setSigningAlgorithm(String signingAlgorithm) {
        this.signingAlgorithm = signingAlgorithm;
    }

    public void setPublicKeyAlgorithm(String publicKeyAlgorithm) {
        this.publicKeyAlgorithm = publicKeyAlgorithm;
    }

    public void setRequestedOn(Instant requestedOn) {
        this.requestedOn = requestedOn;
    }

    public PipelineType getPipelineType() {
        return this.pipelineType;
    }

    public Instant getRejectedOn() {
        return this.rejectedOn;
    }

    public String getRejectionReason() {
        return this.rejectionReason;
    }

    public void setPipelineType(PipelineType pipelineType) {
        this.pipelineType = pipelineType;
    }

    public void setRejectedOn(Instant rejectedOn) {
        this.rejectedOn = rejectedOn;
    }

    public void setRejectionReason(String rejectionReason) {
        this.rejectionReason = rejectionReason;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getRequestedBy() {
        return this.requestedBy;
    }

    public void setRequestedBy(String requestedBy) {
        this.requestedBy = requestedBy;
    }

    public String getSans() {
        return this.sans;
    }

    public void setSans(String sans) {
        this.sans = sans;
    }

    public AuditView[] getAuditViewArr() {
        return this.auditViewArr;
    }

    public void setAuditViewArr(AuditView[] auditViewArr) {
        this.auditViewArr = auditViewArr;
    }
}

