/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.dto.acme;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.trustable.ca3s.core.domain.AcmeIdentifier;
import de.trustable.ca3s.core.domain.AcmeOrder;
import de.trustable.ca3s.core.domain.enumeration.AcmeOrderStatus;
import de.trustable.ca3s.core.service.dto.acme.IdentifierResponse;
import de.trustable.ca3s.core.service.util.DateUtil;
import java.time.Instant;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Immutable
public class NewOrderResponse {
    @JsonProperty(value="status")
    private AcmeOrderStatus status;
    @JsonProperty(value="expires")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'hh:mm:ss'Z'")
    private Date expires;
    @JsonProperty(value="identifiers")
    private Set<IdentifierResponse> identifiers;
    @JsonProperty(value="authorizations")
    private Set<String> authorizations;
    @JsonProperty(value="finalize")
    private String finalize;

    public NewOrderResponse() {
    }

    public NewOrderResponse(AcmeOrder orderDao, Set<String> authUrlSet, String finalizeUrl) {
        this.setStatus(orderDao.getStatus());
        this.setExpires(DateUtil.asDate((Instant)orderDao.getExpires()));
        HashSet<IdentifierResponse> identifiersResp = new HashSet<IdentifierResponse>();
        for (AcmeIdentifier ident : orderDao.getAcmeIdentifiers()) {
            identifiersResp.add(new IdentifierResponse(ident.getType(), ident.getValue()));
        }
        this.setIdentifiers(identifiersResp);
        this.setAuthorizations(authUrlSet);
        this.setFinalize(finalizeUrl);
    }

    public AcmeOrderStatus getStatus() {
        return this.status;
    }

    public void setStatus(AcmeOrderStatus acmeOrderStatus) {
        this.status = acmeOrderStatus;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'hh:mm:ss'Z'")
    public Date getExpires() {
        return this.expires;
    }

    public void setExpires(Date expires) {
        if (expires != null) {
            this.expires = expires;
        }
    }

    public Set<IdentifierResponse> getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifiers(Set<IdentifierResponse> identifiers) {
        this.identifiers = identifiers;
    }

    public Set<String> getAuthorizations() {
        return this.authorizations;
    }

    public void setAuthorizations(Set<String> authorizations) {
        this.authorizations = authorizations;
    }

    public String getFinalize() {
        return this.finalize;
    }

    public void setFinalize(String finalize) {
        this.finalize = finalize;
    }
}

