/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.service.CSRService;
import de.trustable.ca3s.core.web.rest.errors.BadRequestAlertException;
import io.github.jhipster.web.util.HeaderUtil;
import io.github.jhipster.web.util.ResponseUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class CSRResource {
    private final Logger log = LoggerFactory.getLogger(CSRResource.class);
    private static final String ENTITY_NAME = "cSR";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final CSRService cSRService;

    public CSRResource(CSRService cSRService) {
        this.cSRService = cSRService;
    }

    @PostMapping(value={"/csrs"})
    public ResponseEntity<CSR> createCSR(@Valid @RequestBody CSR cSR) throws URISyntaxException {
        this.log.debug("REST request to save CSR : {}", (Object)cSR);
        if (cSR.getId() != null) {
            throw new BadRequestAlertException("A new cSR cannot already have an ID", ENTITY_NAME, "idexists");
        }
        CSR result = this.cSRService.save(cSR);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/csrs/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/csrs"})
    public ResponseEntity<CSR> updateCSR(@Valid @RequestBody CSR cSR) throws URISyntaxException {
        this.log.debug("REST request to update CSR : {}", (Object)cSR);
        if (cSR.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        CSR result = this.cSRService.save(cSR);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)cSR.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/csrs"})
    public List<CSR> getAllCSRS(@RequestParam(required=false) String filter) {
        if ("certificate-is-null".equals(filter)) {
            this.log.debug("REST request to get all CSRs where certificate is null");
            return this.cSRService.findAllWhereCertificateIsNull();
        }
        this.log.debug("REST request to get all CSRS");
        return this.cSRService.findAll();
    }

    @GetMapping(value={"/csrs/{id}"})
    public ResponseEntity<CSR> getCSR(@PathVariable Long id) {
        this.log.debug("REST request to get CSR : {}", (Object)id);
        Optional cSR = this.cSRService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)cSR);
    }

    @DeleteMapping(value={"/csrs/{id}"})
    public ResponseEntity<Void> deleteCSR(@PathVariable Long id) {
        this.log.debug("REST request to delete CSR : {}", (Object)id);
        this.cSRService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

