/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.ImportedURL;
import de.trustable.ca3s.core.service.ImportedURLService;
import de.trustable.ca3s.core.web.rest.errors.BadRequestAlertException;
import io.github.jhipster.web.util.HeaderUtil;
import io.github.jhipster.web.util.ResponseUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class ImportedURLResource {
    private final Logger log = LoggerFactory.getLogger(ImportedURLResource.class);
    private static final String ENTITY_NAME = "importedURL";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final ImportedURLService importedURLService;

    public ImportedURLResource(ImportedURLService importedURLService) {
        this.importedURLService = importedURLService;
    }

    @PostMapping(value={"/imported-urls"})
    public ResponseEntity<ImportedURL> createImportedURL(@Valid @RequestBody ImportedURL importedURL) throws URISyntaxException {
        this.log.debug("REST request to save ImportedURL : {}", (Object)importedURL);
        if (importedURL.getId() != null) {
            throw new BadRequestAlertException("A new importedURL cannot already have an ID", ENTITY_NAME, "idexists");
        }
        ImportedURL result = this.importedURLService.save(importedURL);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/imported-urls/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/imported-urls"})
    public ResponseEntity<ImportedURL> updateImportedURL(@Valid @RequestBody ImportedURL importedURL) throws URISyntaxException {
        this.log.debug("REST request to update ImportedURL : {}", (Object)importedURL);
        if (importedURL.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        ImportedURL result = this.importedURLService.save(importedURL);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)importedURL.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/imported-urls"})
    public List<ImportedURL> getAllImportedURLS() {
        this.log.debug("REST request to get all ImportedURLS");
        return this.importedURLService.findAll();
    }

    @GetMapping(value={"/imported-urls/{id}"})
    public ResponseEntity<ImportedURL> getImportedURL(@PathVariable Long id) {
        this.log.debug("REST request to get ImportedURL : {}", (Object)id);
        Optional importedURL = this.importedURLService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)importedURL);
    }

    @DeleteMapping(value={"/imported-urls/{id}"})
    public ResponseEntity<Void> deleteImportedURL(@PathVariable Long id) {
        this.log.debug("REST request to delete ImportedURL : {}", (Object)id);
        this.importedURLService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

