/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.bpmn.task;

import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.repository.CAConnectorConfigRepository;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.service.util.CaConnectorAdapter;
import de.trustable.ca3s.core.service.util.ConfigUtil;
import de.trustable.ca3s.core.service.util.DateUtil;
import de.trustable.util.CryptoUtil;
import java.util.Date;
import java.util.Optional;
import org.bouncycastle.asn1.x509.CRLReason;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CaBackendTask
implements JavaDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaBackendTask.class);
    @Autowired
    private CertificateRepository certificateRepository;
    @Autowired
    private CSRRepository csrRepository;
    @Autowired
    private CAConnectorConfigRepository caccRepo;
    @Autowired
    private ConfigUtil configUtil;
    @Autowired
    private CaConnectorAdapter caConnAdapter;
    @Autowired
    private CryptoUtil cryptoUtil;

    @Transactional
    public void execute(DelegateExecution execution) throws Exception {
        block17: {
            String caConfigIdStr;
            long caConfigId;
            Optional caConnOpt;
            execution.setVariable("status", (Object)"Failed");
            execution.setVariable("failureReason", (Object)"");
            String action = (String)execution.getVariable("action");
            LOGGER.debug("execution.getVariable('action') : " + action);
            if (this.caccRepo.count() == 0L) {
                LOGGER.debug("CAConnectorConfig is empty");
            }
            if (!(caConnOpt = this.caccRepo.findById((Object)(caConfigId = Long.parseLong(caConfigIdStr = execution.getVariable("caConfigId").toString())))).isPresent()) {
                execution.setVariable("failureReason", (Object)("certificate Id '" + caConfigId + "' not found."));
                return;
            }
            CAConnectorConfig caConfig = (CAConnectorConfig)caConnOpt.get();
            if (caConfig == null) {
                LOGGER.debug("caName NOT set by calling BPNM process");
                caConfig = this.configUtil.getDefaultConfig();
                if (caConfig == null) {
                    LOGGER.error("no default CA available");
                    return;
                }
                LOGGER.debug("using '{}' as the default CA ", (Object)caConfig.getName());
            }
            try {
                Certificate cert;
                if ("Revoke".equals(action)) {
                    String revocationReasonStr;
                    Certificate revokeCert = (Certificate)execution.getVariable("certificate");
                    if (revokeCert == null) {
                        String revokeCertIdStr = execution.getVariable("certificateId").toString();
                        long certificateId = -1L;
                        try {
                            certificateId = Long.parseLong(revokeCertIdStr);
                            LOGGER.debug("execution.getVariable('certificateId') : " + certificateId);
                            Optional certificateOpt = this.certificateRepository.findById((Object)certificateId);
                            if (!certificateOpt.isPresent()) {
                                execution.setVariable("failureReason", (Object)("certificate Id '" + revokeCertIdStr + "' not found."));
                                return;
                            }
                            revokeCert = (Certificate)certificateOpt.get();
                        }
                        catch (NumberFormatException nfe) {
                            String msg = "unparsable cert id '" + revokeCertIdStr + "'";
                            LOGGER.warn(msg);
                            execution.setVariable("failureReason", (Object)msg);
                            return;
                        }
                    }
                    if ((revocationReasonStr = (String)execution.getVariable("revocationReason")) != null) {
                        revocationReasonStr = revocationReasonStr.trim();
                    }
                    LOGGER.debug("execution.getVariable('revocationReason') : " + revocationReasonStr);
                    if (revokeCert.isRevoked().booleanValue()) {
                        execution.setVariable("failureReason", (Object)("certificate with id '" + revokeCert.getId() + "' already revoked."));
                    }
                    CRLReason crlReason = this.cryptoUtil.crlReasonFromString(revocationReasonStr);
                    String crlReasonStr = this.cryptoUtil.crlReasonAsString(crlReason);
                    LOGGER.debug("crlReason : " + crlReasonStr);
                    Date now = new Date();
                    this.caConnAdapter.revokeCertificate(revokeCert, crlReason, now, caConfig);
                    revokeCert.setRevoked(Boolean.valueOf(true));
                    revokeCert.setRevokedSince(DateUtil.asInstant((Date)now));
                    revokeCert.setRevocationReason(crlReasonStr);
                    revokeCert.setRevocationExecutionId(execution.getProcessInstanceId());
                    execution.setVariable("status", (Object)"Revoked");
                    break block17;
                }
                execution.setVariable("certificateId", (Object)"");
                CSR csr = (CSR)execution.getVariable("csr");
                if (csr == null) {
                    String csrIdString = execution.getVariable("csrId").toString();
                    long csrId = Long.parseLong(csrIdString);
                    Optional csrOpt = this.csrRepository.findById((Object)csrId);
                    if (!csrOpt.isPresent()) {
                        execution.setVariable("failureReason", (Object)("csr Id '" + csrId + "' not found."));
                        return;
                    }
                    csr = (CSR)csrOpt.get();
                }
                if ((cert = this.caConnAdapter.signCertificateRequest(csr, caConfig)) != null) {
                    cert.setCreationExecutionId(execution.getProcessInstanceId());
                    this.certificateRepository.save((Object)cert);
                    LOGGER.debug("certificateId " + cert.getId());
                } else {
                    LOGGER.warn("ceated certificate for csr #" + csr.getId() + " == null!");
                }
                execution.setVariable("certificateId", (Object)cert.getId());
                execution.setVariable("certificate", (Object)cert);
                execution.setVariable("status", (Object)"Created");
            }
            catch (Exception e) {
                execution.setVariable("failureReason", (Object)e.getMessage());
                LOGGER.info("signCertificateRequest failed", (Throwable)e);
            }
        }
    }
}

