/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.schedule;

import de.trustable.ca3s.core.repository.ProtectedContentRepository;
import java.time.Instant;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ProtectedContentCleanupScheduler {
    transient Logger LOG = LoggerFactory.getLogger(ProtectedContentCleanupScheduler.class);
    @Autowired
    ProtectedContentRepository protectedContentRepository;

    @Scheduled(fixedDelay=60000L)
    public void runMinute() {
        List expiredList = this.protectedContentRepository.findByDeleteAfterPassed(Instant.now());
        if (!expiredList.isEmpty()) {
            this.LOG.info("deleting #{} expired ProtectedContent objects", (Object)expiredList.size());
            this.protectedContentRepository.deleteAll((Iterable)expiredList);
        }
    }
}

