/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.repository.CertificateSpecifications;
import de.trustable.ca3s.core.service.dto.CertificateView;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.ldap.LdapName;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class CRLUtil {
    Logger LOG = LoggerFactory.getLogger(CRLUtil.class);
    @Autowired
    private CertificateUtil certUtil;
    @Autowired
    private EntityManager entityManager;

    @Cacheable(value={"CRLs"})
    public X509CRL downloadCRL(String crlURL) throws IOException, CertificateException, CRLException, NamingException {
        long startTime = System.currentTimeMillis();
        X509CRL crl = null;
        if (crlURL.startsWith("http://") || crlURL.startsWith("https://") || crlURL.startsWith("ftp://")) {
            crl = this.downloadCRLFromWeb(crlURL);
        } else if (crlURL.startsWith("ldap://")) {
            crl = this.downloadCRLFromLDAP(crlURL);
        }
        if (crl == null) {
            throw new IOException("Can not download CRL from certificate distribution point: " + crlURL);
        }
        int nRevCerts = 0;
        if (crl.getRevokedCertificates() != null) {
            nRevCerts = crl.getRevokedCertificates().size();
        }
        this.LOG.info("download from '{}' with #{} items took {} mSec", new Object[]{crlURL, nRevCerts, System.currentTimeMillis() - startTime});
        X500Principal principal = crl.getIssuerX500Principal();
        List certList = CertificateSpecifications.findCertificatesBySubject((EntityManager)this.entityManager, (CriteriaBuilder)this.entityManager.getCriteriaBuilder(), new LdapName(principal.getName()).getRdns());
        if (certList.size() == 0) {
            this.LOG.debug("principal '{}' not found to verify CRL '{}'", (Object)principal.getName(), (Object)crlURL);
            return null;
        }
        for (Certificate cert : certList) {
            try {
                X509Certificate x509cert = this.certUtil.convertPemToCertificate(cert.getContent());
                crl.verify(x509cert.getPublicKey());
                return crl;
            }
            catch (GeneralSecurityException gse) {
                this.LOG.debug("principal '{}' / cert id {} does NOT verify CRL '{}'", new Object[]{principal.getName(), cert.getId(), crlURL});
            }
        }
        return null;
    }

    private X509CRL downloadCRLFromLDAP(String ldapURL) throws CertificateException, NamingException, CRLException, IOException {
        this.LOG.debug("loading CRL from LDAP {}", (Object)ldapURL);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapURL);
        InitialDirContext ctx = new InitialDirContext(env);
        Attributes avals = ctx.getAttributes("");
        Attribute aval = avals.get("certificateRevocationList;binary");
        if (aval == null) {
            throw new IOException("Can not download CRL from: " + ldapURL);
        }
        byte[] val = (byte[])aval.get();
        if (val == null || val.length == 0) {
            throw new IOException("Can not download CRL from: " + ldapURL);
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(val);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return (X509CRL)cf.generateCRL(inStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509CRL downloadCRLFromWeb(String crlURL) throws MalformedURLException, IOException, CertificateException, CRLException {
        this.LOG.debug("loading CRL from URL {}", (Object)crlURL);
        URL url = new URL(crlURL);
        try (InputStream crlStream = url.openStream();){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509CRL x509CRL = (X509CRL)cf.generateCRL(crlStream);
            return x509CRL;
        }
    }

    public Page<CertificateView> findSelection(Map<String, String[]> parameterMap) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        return CertificateSpecifications.handleQueryParamsCertificateView((EntityManager)this.entityManager, (CriteriaBuilder)cb, parameterMap);
    }
}

