/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.support;

import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.CsrAttribute;
import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.domain.enumeration.CsrStatus;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.CsrAttributeRepository;
import de.trustable.ca3s.core.repository.UserRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.MailService;
import de.trustable.ca3s.core.service.util.BPMNUtil;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.web.rest.data.AdministrationType;
import de.trustable.ca3s.core.web.rest.data.CSRAdministrationData;
import de.trustable.ca3s.core.web.rest.data.NamedValue;
import java.time.Instant;
import java.util.Locale;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.thymeleaf.context.Context;

@RestController
@RequestMapping(value={"/api"})
public class CSRAdministration {
    private final Logger LOG = LoggerFactory.getLogger(CSRAdministration.class);
    @Autowired
    private CSRRepository csrRepository;
    @Autowired
    private CsrAttributeRepository csrAttributeRepository;
    @Autowired
    private BPMNUtil bpmnUtil;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private MailService mailService;
    @Autowired
    private AuditService auditService;

    @PostMapping(value={"/administerRequest"})
    @Transactional
    public ResponseEntity<Long> administerRequest(@Valid @RequestBody CSRAdministrationData adminData) {
        this.LOG.debug("REST request to reject / accept CSR : {}", (Object)adminData);
        Optional optCSR = this.csrRepository.findById((Object)adminData.getCsrId());
        if (optCSR.isPresent()) {
            CSR csr = (CSR)optCSR.get();
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            csr.setAdministeredBy(auth.getName());
            this.updateComment(adminData, csr);
            if (AdministrationType.ACCEPT.equals((Object)adminData.getAdministrationType())) {
                csr.setApprovedOn(Instant.now());
                this.updateARAttributes(adminData, csr);
                this.csrRepository.save((Object)csr);
                this.auditService.saveAuditTrace(this.auditService.createAuditTraceCsrAccepted(csr));
                Certificate cert = this.bpmnUtil.startCertificateCreationProcess(csr);
                if (cert != null) {
                    Optional optUser = this.userRepository.findOneByLogin(csr.getRequestedBy());
                    if (optUser.isPresent()) {
                        User requestor = (User)optUser.get();
                        if (requestor.getEmail() == null) {
                            this.LOG.debug("Email doesn't exist for user '{}'", (Object)requestor.getLogin());
                        } else {
                            Locale locale = Locale.forLanguageTag(requestor.getLangKey());
                            Context context = new Context(locale);
                            context.setVariable("certId", (Object)cert.getId());
                            context.setVariable("subject", (Object)cert.getSubject());
                            String downloadFilename = CertificateUtil.getDownloadFilename((Certificate)cert);
                            boolean isServersideKeyGeneration = false;
                            if (cert.getCsr() != null) {
                                isServersideKeyGeneration = cert.getCsr().isServersideKeyGeneration();
                            }
                            context.setVariable("isServersideKeyGeneration", (Object)isServersideKeyGeneration);
                            context.setVariable("filenameCrt", (Object)(downloadFilename + ".crt"));
                            context.setVariable("filenamePem", (Object)(downloadFilename + ".pem"));
                            this.mailService.sendEmailFromTemplate(context, requestor, "mail/acceptedRequestEmail", "email.acceptedRequest.title");
                        }
                    } else {
                        this.LOG.warn("certificate requestor '{}' unknown!", (Object)csr.getRequestedBy());
                    }
                    return new ResponseEntity((Object)cert.getId(), HttpStatus.CREATED);
                }
                this.LOG.warn("creation of certificate requested for CSR {} failed ", (Object)csr.getId());
                return new ResponseEntity((Object)adminData.getCsrId(), HttpStatus.BAD_REQUEST);
            }
            if (AdministrationType.REJECT.equals((Object)adminData.getAdministrationType())) {
                csr.setRejectionReason(adminData.getRejectionReason());
                csr.setRejectedOn(Instant.now());
                csr.setStatus(CsrStatus.REJECTED);
                this.csrRepository.save((Object)csr);
                Optional optUser = this.userRepository.findOneByLogin(csr.getRequestedBy());
                if (optUser.isPresent()) {
                    User requestor = (User)optUser.get();
                    if (requestor.getEmail() == null) {
                        this.LOG.debug("Email doesn't exist for user '{}'", (Object)requestor.getLogin());
                    } else {
                        Locale locale = Locale.forLanguageTag(requestor.getLangKey());
                        Context context = new Context(locale);
                        context.setVariable("csr", (Object)csr);
                        this.mailService.sendEmailFromTemplate(context, requestor, "mail/rejectedRequestEmail", "email.request.rejection.title");
                    }
                } else {
                    this.LOG.warn("certificate requestor '{}' unknown!", (Object)csr.getRequestedBy());
                }
                this.auditService.saveAuditTrace(this.auditService.createAuditTraceCsrRejected(csr));
                return new ResponseEntity((Object)adminData.getCsrId(), HttpStatus.OK);
            }
            if (AdministrationType.UPDATE.equals((Object)adminData.getAdministrationType())) {
                this.updateARAttributes(adminData, csr);
                return new ResponseEntity((Object)adminData.getCsrId(), HttpStatus.OK);
            }
            this.LOG.info("administration type '{}' unexpected!", (Object)adminData.getAdministrationType());
            return ResponseEntity.badRequest().build();
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping(value={"/withdrawOwnRequest"})
    @Transactional
    public ResponseEntity<Long> withdrawOwnRequest(@Valid @RequestBody CSRAdministrationData adminData) {
        this.LOG.debug("REST request to withdraw CSR : {}", (Object)adminData);
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        String userName = auth.getName();
        Optional optCSR = this.csrRepository.findById((Object)adminData.getCsrId());
        if (optCSR.isPresent()) {
            CSR csr = (CSR)optCSR.get();
            if (userName == null || !userName.equals(csr.getRequestedBy())) {
                this.LOG.debug("REST request by '{}' to withdraw CSR '{}' rejected ", (Object)userName, (Object)adminData.getCsrId());
                return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).build();
            }
            csr.setAdministeredBy(userName);
            this.updateComment(adminData, csr);
            csr.setRejectionReason(adminData.getRejectionReason());
            csr.setRejectedOn(Instant.now());
            csr.setStatus(CsrStatus.REJECTED);
            this.csrRepository.save((Object)csr);
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceCsrRejected(csr));
            return new ResponseEntity((Object)adminData.getCsrId(), HttpStatus.OK);
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping(value={"/selfAdministerRequest"})
    @Transactional
    public ResponseEntity<Long> selfAdministerRequest(@Valid @RequestBody CSRAdministrationData adminData) {
        this.LOG.debug("REST request to update CSR : {}", (Object)adminData);
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        String userName = auth.getName();
        Optional optCSR = this.csrRepository.findById((Object)adminData.getCsrId());
        if (optCSR.isPresent()) {
            CSR csr = (CSR)optCSR.get();
            if (userName == null || !userName.equals(csr.getRequestedBy())) {
                this.LOG.debug("REST request by '{}' to update CSR '{}' rejected ", (Object)userName, (Object)adminData.getCsrId());
                return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).build();
            }
            csr.setAdministeredBy(userName);
            this.updateComment(adminData, csr);
            this.updateARAttributes(adminData, csr);
            this.csrRepository.save((Object)csr);
            return new ResponseEntity((Object)adminData.getCsrId(), HttpStatus.OK);
        }
        return ResponseEntity.notFound().build();
    }

    private void updateComment(CSRAdministrationData adminData, CSR csr) {
        if (adminData.getComment() != null && !adminData.getComment().trim().isEmpty()) {
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceCsrAttribute("Comment", csr.getAdministrationComment(), adminData.getComment(), csr));
            csr.setAdministrationComment(adminData.getComment());
        }
    }

    private void updateARAttributes(CSRAdministrationData adminData, CSR csr) {
        for (CsrAttribute csrAttr : csr.getCsrAttributes()) {
            if (!csrAttr.getName().startsWith("_ARA_")) continue;
            for (NamedValue nv : adminData.getArAttributeArr()) {
                if (!csrAttr.getName().equals("_ARA_" + nv.getName()) || csrAttr.getValue().equals(nv.getValue())) continue;
                this.auditService.saveAuditTrace(this.auditService.createAuditTraceCsrAttribute(csrAttr.getName(), csrAttr.getValue(), nv.getValue(), csr));
                csrAttr.setValue(nv.getValue());
                this.LOG.debug("CSR attribute {} updated to {}", (Object)csrAttr.getName(), (Object)csrAttr.getValue());
            }
        }
        this.csrAttributeRepository.saveAll((Iterable)csr.getCsrAttributes());
    }
}

