/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core;

import de.trustable.ca3s.core.EndpointConfig;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EndpointConfigs {
    private static final Logger log = LoggerFactory.getLogger(EndpointConfigs.class);
    HashMap<Integer, EndpointConfig> portConfigMap = new HashMap();

    EndpointConfigs() {
    }

    public void addConfig(int port, boolean isHttps, String bindingHost, String usage) {
        if (this.portConfigMap.containsKey(port)) {
            EndpointConfig existingConfig = (EndpointConfig)this.portConfigMap.get(port);
            if (existingConfig.isHttps() != isHttps) {
                log.warn("Https redefinition for port {}, ignoring definition for '{}'", (Object)port, (Object)usage);
            }
            if (!existingConfig.getBindingHost().equalsIgnoreCase(bindingHost)) {
                log.warn("Binding Host redefinition for port {}, ignoring definition for '{}'", (Object)port, (Object)usage);
            }
            existingConfig.usage = existingConfig.usage + ", " + usage;
        } else {
            this.portConfigMap.put(port, new EndpointConfig(port, isHttps, bindingHost, usage));
        }
    }

    public HashMap<Integer, EndpointConfig> getPortConfigMap() {
        return this.portConfigMap;
    }
}

