/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.trustable.ca3s.core.domain.AbstractAuditingEntity;
import de.trustable.ca3s.core.domain.Authority;
import java.io.Serializable;
import java.time.Instant;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.BatchSize;

@Entity
@Table(name="jhi_user")
public class User
extends AbstractAuditingEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotNull
    @Pattern(regexp="^[_.@A-Za-z0-9-]*$")
    @Size(min=1, max=50)
    @Column(length=50, unique=true, nullable=false)
    private @NotNull @Pattern(regexp="^[_.@A-Za-z0-9-]*$") @Size(min=1, max=50) String login;
    @JsonIgnore
    @NotNull
    @Size(min=60, max=60)
    @Column(name="password_hash", length=60, nullable=false)
    private @NotNull @Size(min=60, max=60) String password;
    @Size(max=50)
    @Column(name="first_name", length=50)
    private @Size(max=50) String firstName;
    @Size(max=50)
    @Column(name="last_name", length=50)
    private @Size(max=50) String lastName;
    @Email
    @Size(min=5, max=254)
    @Column(length=254, unique=true)
    private @Email @Size(min=5, max=254) String email;
    @NotNull
    @Column(nullable=false)
    private boolean activated = false;
    @Size(min=2, max=10)
    @Column(name="lang_key", length=10)
    private @Size(min=2, max=10) String langKey;
    @Size(max=256)
    @Column(name="image_url", length=256)
    private @Size(max=256) String imageUrl;
    @Size(max=20)
    @Column(name="activation_key", length=20)
    @JsonIgnore
    private @Size(max=20) String activationKey;
    @Size(max=20)
    @Column(name="reset_key", length=20)
    @JsonIgnore
    private @Size(max=20) String resetKey;
    @Column(name="reset_date")
    private Instant resetDate = null;
    @JsonIgnore
    @ManyToMany
    @JoinTable(name="jhi_user_authority", joinColumns={@JoinColumn(name="user_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="authority_name", referencedColumnName="name")})
    @BatchSize(size=20)
    private Set<Authority> authorities = new HashSet();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = StringUtils.lowerCase((String)login, (Locale)Locale.ENGLISH);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public boolean getActivated() {
        return this.activated;
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    public String getActivationKey() {
        return this.activationKey;
    }

    public void setActivationKey(String activationKey) {
        this.activationKey = activationKey;
    }

    public String getResetKey() {
        return this.resetKey;
    }

    public void setResetKey(String resetKey) {
        this.resetKey = resetKey;
    }

    public Instant getResetDate() {
        return this.resetDate;
    }

    public void setResetDate(Instant resetDate) {
        this.resetDate = resetDate;
    }

    public String getLangKey() {
        return this.langKey;
    }

    public void setLangKey(String langKey) {
        this.langKey = langKey;
    }

    public Set<Authority> getAuthorities() {
        return this.authorities;
    }

    public void setAuthorities(Set<Authority> authorities) {
        this.authorities = authorities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        return this.id != null && this.id.equals(((User)o).id);
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return "User{login='" + this.login + '\'' + ", firstName='" + this.firstName + '\'' + ", lastName='" + this.lastName + '\'' + ", email='" + this.email + '\'' + ", imageUrl='" + this.imageUrl + '\'' + ", activated='" + this.activated + '\'' + ", langKey='" + this.langKey + '\'' + ", activationKey='" + this.activationKey + '\'' + "}";
    }
}

