/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.schedule.spider;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpiderLeg {
    Logger LOGGER = LoggerFactory.getLogger(SpiderLeg.class);
    private static final String USER_AGENT = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/535.1 (KHTML, like Gecko) Chrome/13.0.782.112 Safari/535.1";
    private List<String> links = new LinkedList();
    private Document htmlDocument;

    public boolean crawl(String url, Pattern searchPattern, Set<String> certificateSet) {
        try {
            Document htmlDocument;
            Connection connection = Jsoup.connect((String)url).userAgent(USER_AGENT);
            this.htmlDocument = htmlDocument = connection.get();
            if (connection.response().statusCode() == 200) {
                System.out.println("\n**Visiting** Received web page at " + url);
            }
            if (!connection.response().contentType().contains("text/html")) {
                System.out.println("**Failure** Retrieved something other than HTML");
                return false;
            }
            Elements linksOnPage = htmlDocument.select("a[href]");
            System.out.println("Found (" + linksOnPage.size() + ") links");
            for (Element link : linksOnPage) {
                String href = link.absUrl("href");
                if (searchPattern.matcher(href).matches()) {
                    this.LOGGER.info("found certificate at {}", (Object)href);
                    certificateSet.add(href);
                    continue;
                }
                this.links.add(link.absUrl("href"));
            }
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public List<String> getLinks() {
        return this.links;
    }
}

