/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.security.provider;

import de.trustable.ca3s.cert.bundle.BundleFactory;
import de.trustable.ca3s.cert.bundle.KeyCertBundle;
import de.trustable.util.CryptoUtil;
import de.trustable.util.PKILevel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.x500.X500Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ca3sFallbackBundleFactory
implements BundleFactory {
    private static final Logger LOG = LoggerFactory.getLogger(Ca3sFallbackBundleFactory.class);
    private KeyPair rootKeyPair = null;
    private X509Certificate issuingCertificate = null;
    private X500Name x500Issuer;
    private CryptoUtil cryptoUtil = new CryptoUtil();

    public Ca3sFallbackBundleFactory() {
        try {
            this.x500Issuer = new X500Name("CN=RootOn" + InetAddress.getLocalHost().getCanonicalHostName() + ", OU=temporary bootstrap root " + System.currentTimeMillis() + ", O=trustable solutions, C=DE");
        }
        catch (UnknownHostException uhe) {
            LOG.debug("problem retrieving hostname", (Throwable)uhe);
            this.x500Issuer = new X500Name("CN=CA3SHost, OU=temporary bootstrap root " + System.currentTimeMillis() + ", O=trustable solutions, C=DE");
        }
    }

    private synchronized KeyPair getRootKeyPair() throws GeneralSecurityException {
        if (this.rootKeyPair == null) {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
            kpg.initialize(2048);
            this.rootKeyPair = kpg.generateKeyPair();
            LOG.debug("created new root keypair : {}", (Object)this.rootKeyPair.toString());
        }
        return this.rootKeyPair;
    }

    private synchronized X509Certificate getRootCertificate() throws GeneralSecurityException, IOException {
        if (this.issuingCertificate == null) {
            KeyPair kp = this.getRootKeyPair();
            this.issuingCertificate = this.cryptoUtil.issueCertificate(this.x500Issuer, kp, this.x500Issuer, kp.getPublic().getEncoded(), 2, 1, PKILevel.ROOT);
            LOG.debug("created temp. root certificate with subject : {}", (Object)this.issuingCertificate.getSubjectDN().getName());
            File rootCertFile = File.createTempFile("ca3sTempRoot", ".cer");
            try (FileOutputStream fos = new FileOutputStream(rootCertFile);){
                fos.write(this.issuingCertificate.getEncoded());
            }
            LOG.debug("written temp. root certificate to file : '{}'", (Object)rootCertFile.getAbsolutePath());
        }
        return this.issuingCertificate;
    }

    public KeyCertBundle newKeyBundle(String bundleName, long minValiditySeconds) throws GeneralSecurityException {
        KeyPair localKeyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        try {
            InetAddress ip = InetAddress.getLocalHost();
            String hostname = ip.getHostName();
            LOG.debug("requesting certificate for host : " + hostname);
            X500Name subject = new X500Name("CN=" + hostname);
            X509Certificate issuedCertificate = this.cryptoUtil.issueCertificate(this.x500Issuer, this.getRootKeyPair(), subject, localKeyPair.getPublic().getEncoded(), 10, 1);
            X509Certificate[] certificateChain = new X509Certificate[]{issuedCertificate, this.getRootCertificate()};
            LOG.debug("returning new  certificate : " + issuedCertificate);
            return new KeyCertBundle(bundleName, certificateChain, issuedCertificate, (Key)localKeyPair.getPrivate());
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
    }
}

