/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service;

import de.trustable.ca3s.core.domain.AuditTrace;
import de.trustable.ca3s.core.domain.BPMNProcessInfo;
import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.repository.AuditTraceRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.util.CryptoUtil;
import java.time.Instant;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.audit.listener.AuditApplicationEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AuditService {
    public static final String AUDIT_CSR_ACCEPTED = "CSR_ACCEPTED";
    public static final String AUDIT_CSR_REJECTED = "CSR_REJECTED";
    public static final String AUDIT_WEB_CERTIFICATE_REQUESTED = "WEB_CERTIFICATE_REQUESTED";
    public static final String AUDIT_ACME_CERTIFICATE_REQUESTED = "ACME_CERTIFICATE_REQUESTED";
    public static final String AUDIT_ACME_CERTIFICATE_CREATED = "ACME_CERTIFICATE_CREATED";
    public static final String AUDIT_SCEP_CERTIFICATE_REQUESTED = "SCEP_CERTIFICATE_REQUESTED";
    public static final String AUDIT_SCEP_CERTIFICATE_CREATED = "SCEP_CERTIFICATE_CREATED";
    public static final String AUDIT_REQUEST_RESTRICTIONS_FAILED = "REQUEST_RESTRICTIONS_FAILED";
    public static final String AUDIT_WEB_CERTIFICATE_CREATED = "WEB_CERTIFICATE_CREATED";
    public static final String AUDIT_CERTIFICATE_REVOKED = "CERTIFICATE_REVOKED";
    public static final String AUDIT_CERTIFICATE_REVOKED_BY_CRL = "CERTIFICATE_REVOKED_BY_CRL";
    public static final String AUDIT_MANUAL_CERTIFICATE_IMPORTED = "MANUAL_CERTIFICATE_IMPORTED";
    public static final String AUDIT_ADCS_CERTIFICATE_IMPORTED = "ADCS_CERTIFICATE_IMPORTED";
    public static final String AUDIT_TLS_CERTIFICATE_IMPORTED = "TLS_CERTIFICATE_IMPORTED";
    public static final String AUDIT_TLS_INTERMEDIATE_CERTIFICATE_IMPORTED = "TLS_INTERMEDIATE_CERTIFICATE_IMPORTED";
    public static final String AUDIT_PIPELINE_ATTRIBUTE_CHANGED = "PIPELINE_ATTRIBUTE_CHANGED";
    public static final String AUDIT_CSR_ATTRIBUTE_CHANGED = "CSR_ATTRIBUTE_CHANGED";
    public static final String AUDIT_CERTIFICATE_IMPORTED = "CERTIFICATE_IMPORTED";
    public static final String AUDIT_CERTIFICATE_ATTRIBUTE_CHANGED = "CERTIFICATE_ATTRIBUTE_CHANGED";
    public static final String AUDIT_PIPELINE_CREATED = "PIPELINE_CREATED";
    public static final String AUDIT_PIPELINE_COPIED = "PIPELINE_COPIED";
    public static final String AUDIT_PIPELINE_DELETED = "PIPELINE_DELETED";
    public static final String AUDIT_PIPELINE_NAME_CHANGED = "PIPELINE_NAME_CHANGED";
    public static final String AUDIT_PIPELINE_DESCRIPTION_CHANGED = "PIPELINE_DESCRIPTION_CHANGED";
    public static final String AUDIT_PIPELINE_TYPE_CHANGED = "PIPELINE_TYPE_CHANGED";
    public static final String AUDIT_PIPELINE_URLPART_CHANGED = "PIPELINE_URLPART_CHANGED";
    public static final String AUDIT_PIPELINE_APPROVAL_REQUIRED_CHANGED = "PIPELINE_APPROVAL_REQUIRED_CHANGED";
    public static final String AUDIT_PIPELINE_ACTIVE_CHANGED = "PIPELINE_ACTIVE_CHANGED";
    public static final String AUDIT_CRAWLER_CERTIFICATE_IMPORTED = "CRAWLER_CERTIFICATE_IMPORTED";
    public static final String AUDIT_DIRECTORY_CERTIFICATE_IMPORTED = "DIRECTORY_CERTIFICATE_IMPORTED";
    public static final String AUDIT_CA_CONNECTOR_CREATED = "CA_CONNECTOR_CREATED";
    public static final String AUDIT_CA_CONNECTOR_COPIED = "CA_CONNECTOR_COPIED";
    public static final String AUDIT_CA_CONNECTOR_DELETED = "CA_CONNECTOR_DELETED";
    public static final String AUDIT_CA_CONNECTOR_ATTRIBUTE_CHANGED = "CA_CONNECTOR_ATTRIBUTE_CHANGED";
    private final Logger log = LoggerFactory.getLogger(AuditService.class);
    private AuditTraceRepository auditTraceRepository;
    private ApplicationEventPublisher applicationEventPublisher;

    public AuditService(AuditTraceRepository auditTraceRepository, ApplicationEventPublisher applicationEventPublisher) {
        this.auditTraceRepository = auditTraceRepository;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    String getRole(Authentication auth) {
        this.log.debug("Authorities #{} present", (Object)auth.getAuthorities().size());
        if (auth.getAuthorities().stream().anyMatch(a -> a.getAuthority().equals("ROLE_ADMIN"))) {
            return "ADMIN";
        }
        if (auth.getAuthorities().stream().anyMatch(a -> a.getAuthority().equals("ROLE_RA"))) {
            return "RA";
        }
        if (auth.getAuthorities().stream().anyMatch(a -> a.getAuthority().equals("ROLE_USER"))) {
            return "USER";
        }
        for (GrantedAuthority ga : auth.getAuthorities()) {
            this.log.debug("Authority: {}", (Object)ga.getAuthority());
        }
        return "ANON";
    }

    public AuditTrace createAuditTraceCsrAccepted(CSR csr) {
        NameAndRole nar = this.getNameAndRole();
        return this.createAuditTraceRequest(nar.getName(), nar.getRole(), AUDIT_CSR_ACCEPTED, csr);
    }

    public AuditTrace createAuditTraceCsrRejected(CSR csr) {
        NameAndRole nar = this.getNameAndRole();
        return this.createAuditTraceRequest(nar.getName(), nar.getRole(), AUDIT_CSR_REJECTED, csr);
    }

    public AuditTrace createAuditTraceACMERequest(CSR csr) {
        NameAndRole nar = this.getNameAndRole();
        return this.createAuditTraceRequest(nar.getName(), nar.getRole(), AUDIT_ACME_CERTIFICATE_REQUESTED, csr);
    }

    public AuditTrace createAuditTraceWebRequest(CSR csr) {
        NameAndRole nar = this.getNameAndRole();
        return this.createAuditTraceRequest(nar.getName(), nar.getRole(), AUDIT_WEB_CERTIFICATE_REQUESTED, csr);
    }

    public AuditTrace createAuditTraceCsrRestrictionFailed(CSR csr) {
        NameAndRole nar = this.getNameAndRole();
        return this.createAuditTraceRequest(nar.getName(), nar.getRole(), AUDIT_REQUEST_RESTRICTIONS_FAILED, csr);
    }

    public AuditTrace createAuditTraceRequest(String actor, String actorRole, String template, CSR csr) {
        return this.createAuditTrace(actor, actorRole, template, csr, null, null, null, null);
    }

    public AuditTrace createAuditTraceRequest(String template, CSR csr) {
        NameAndRole nar = this.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), template, csr, null, null, null, null);
    }

    public AuditTrace createAuditTraceCertificate(String template, Certificate certificate) {
        NameAndRole nar = this.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), template, null, certificate, null, null, null);
    }

    public AuditTrace createAuditTraceCAConfigCreated(CAConnectorConfig caConnectorConfig) {
        NameAndRole nar = this.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), AUDIT_CA_CONNECTOR_CREATED, null, caConnectorConfig.getName(), null, null, null, caConnectorConfig, null);
    }

    public AuditTrace createAuditTraceCAConfigDeleted(CAConnectorConfig caConnectorConfig) {
        NameAndRole nar = this.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), AUDIT_CA_CONNECTOR_DELETED, null, caConnectorConfig.getName(), null, null, null, caConnectorConfig, null);
    }

    public AuditTrace createAuditTraceCAConfigSecretChanged(CAConnectorConfig caConnectorConfig) {
        NameAndRole nar = this.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), caConnectorConfig.getName(), null, null, null, caConnectorConfig, null);
    }

    public AuditTrace createAuditTraceCAConfigCreatedChange(String attributeName, String oldVal, String newVal, CAConnectorConfig caConnectorConfig) {
        NameAndRole nar = this.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), AUDIT_CA_CONNECTOR_ATTRIBUTE_CHANGED, attributeName, oldVal, newVal, null, null, null, caConnectorConfig, null);
    }

    public AuditTrace createAuditTracePipeline(String template, Pipeline pipeline) {
        NameAndRole nar = this.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), template, null, null, pipeline, null, null);
    }

    public AuditTrace createAuditTracePipeline(String template, String oldVal, String newVal, Pipeline pipeline) {
        NameAndRole nar = this.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), template, oldVal, newVal, null, null, pipeline, null, null);
    }

    public AuditTrace createAuditTracePipelineAttribute(String attributeName, String oldVal, String newVal, Pipeline pipeline) {
        NameAndRole nar = this.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), AUDIT_PIPELINE_ATTRIBUTE_CHANGED, attributeName, oldVal, newVal, null, null, pipeline, null, null);
    }

    public AuditTrace createAuditTraceCsrAttribute(String attributeName, String oldVal, String newVal, CSR csr) {
        NameAndRole nar = this.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), AUDIT_CSR_ATTRIBUTE_CHANGED, attributeName, oldVal, newVal, csr, null, null, null, null);
    }

    public AuditTrace createAuditTraceCertificateAttribute(String attributeName, String oldVal, String newVal, Certificate certificate) {
        NameAndRole nar = this.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), AUDIT_CERTIFICATE_ATTRIBUTE_CHANGED, attributeName, oldVal, newVal, null, certificate, null, null, null);
    }

    public AuditTrace createAuditTraceCertificateImported(String source, Certificate certificate) {
        NameAndRole nar = this.getNameAndRole();
        return this.createAuditTrace(nar.getName(), nar.getRole(), AUDIT_CERTIFICATE_IMPORTED, source, null, null, null, certificate, null, null, null);
    }

    public AuditTrace createAuditTrace(String actor, String actorRole, String template, CSR csr, Certificate certificate, Pipeline pipeline, CAConnectorConfig caConnector, BPMNProcessInfo processInfo) {
        return this.createAuditTrace(actor, actorRole, template, null, null, csr, certificate, pipeline, caConnector, processInfo);
    }

    public AuditTrace createAuditTrace(String actor, String actorRole, String template, String oldVal, String newVal, CSR csr, Certificate certificate, Pipeline pipeline, CAConnectorConfig caConnector, BPMNProcessInfo processInfo) {
        return this.createAuditTrace(actor, actorRole, template, null, oldVal, newVal, csr, certificate, pipeline, caConnector, processInfo);
    }

    public AuditTrace createAuditTrace(String actor, String actorRole, String template, String attributeName, String oldVal, String newVal, CSR csr, Certificate certificate, Pipeline pipeline, CAConnectorConfig caConnector, BPMNProcessInfo processInfo) {
        String msg = "";
        if (attributeName != null) {
            msg = this.limitAndEscapeContent(attributeName, 30);
        }
        if (oldVal != null || newVal != null) {
            msg = msg + "," + this.limitAndEscapeContent(oldVal, 100) + "," + this.limitAndEscapeContent(newVal, 100);
        }
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new AuditApplicationEvent(actor, template, new String[]{msg}));
        this.log.debug("Audit trace for {}, attribute {}, oldVal {}, newVal {} ", new Object[]{template, attributeName, oldVal, newVal});
        AuditTrace auditTrace = new AuditTrace();
        auditTrace.setActorName(CryptoUtil.limitLength((String)actor, (int)50));
        auditTrace.setActorRole(CryptoUtil.limitLength((String)actorRole, (int)50));
        auditTrace.setPlainContent(msg);
        auditTrace.setContentTemplate(template);
        auditTrace.setCreatedOn(Instant.now());
        auditTrace.setCsr(csr);
        auditTrace.setCertificate(certificate);
        auditTrace.setPipeline(pipeline);
        auditTrace.setCaConnector(caConnector);
        auditTrace.setProcessInfo(processInfo);
        return auditTrace;
    }

    private String limitAndEscapeContent(String in, int maxLen) {
        if (in == null) {
            return "";
        }
        if (in.length() > maxLen) {
            in = CryptoUtil.limitLength((String)in, (int)(maxLen - 3)) + "...";
        }
        return in.replace("%", "%25").replace(",", "%2C");
    }

    public void saveAuditTrace(AuditTrace auditTrace) {
        this.auditTraceRepository.save((Object)auditTrace);
    }

    public void saveAuditTrace(List<AuditTrace> auditTraceList) {
        this.auditTraceRepository.saveAll(auditTraceList);
    }

    NameAndRole getNameAndRole() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null) {
            String role = this.getRole(auth);
            return new NameAndRole(this, auth.getName(), role);
        }
        return new NameAndRole(this, "System", "System");
    }
}

