/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.cmp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class RemoteConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteConnector.class);
    @Autowired
    Environment environment;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] sendHttpReq(String requestUrlParam, byte[] requestBytes) throws IOException {
        if (requestUrlParam == null) {
            throw new IllegalArgumentException("requestUrlParam can not be null.");
        }
        String port = this.environment.getProperty("local.server.port");
        LOGGER.debug("current port is " + port);
        String requestUrl = requestUrlParam;
        if (requestUrl.contains("${server.port}")) {
            requestUrl = requestUrl.replace("${server.port}", "" + port);
        }
        if (requestUrl.contains(":0/")) {
            requestUrl = requestUrl.replace(":0/", ":" + port + "/");
        }
        LOGGER.debug("Sending request to: " + requestUrl);
        long startTime = System.currentTimeMillis();
        URL url = new URL(requestUrl);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setDoOutput(true);
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-Type", "application/octet-stream;charset=UTF-8");
        OutputStream os = con.getOutputStream();
        os.write(requestBytes);
        os.close();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream in = null;){
            in = con.getInputStream();
            byte[] tmpBA = new byte[4096];
            int nBytes = 0;
            while ((nBytes = in.read(tmpBA)) > 0) {
                baos.write(tmpBA, 0, nBytes);
            }
            LOGGER.debug("# " + baos.size() + " response bytes recieved");
        }
        if (con.getResponseCode() != 200) {
            throw new IOException("Error sending CMP request. Response codse != 200 : " + con.getResponseCode());
        }
        LOGGER.debug("Received certificate reply.");
        con.disconnect();
        LOGGER.debug("duration of remote CMP call " + (System.currentTimeMillis() - startTime));
        return baos.toByteArray();
    }
}

