/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.dir;

import com.google.common.collect.ImmutableList;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.schedule.ImportInfo;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import edu.uci.ics.crawler4j.crawler.Page;
import edu.uci.ics.crawler4j.crawler.WebCrawler;
import edu.uci.ics.crawler4j.url.WebURL;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateCrawler
extends WebCrawler {
    Logger LOGGER = LoggerFactory.getLogger(CertificateCrawler.class);
    private static final Pattern filters = Pattern.compile(".*(\\.(css|js|mid|mp2|mp3|mp4|wav|avi|mov|mpeg|ram|m4v|pdf|rm|smil|wmv|swf|wma|zip|rar|gz))$");
    private final List<String> crawlDomains;
    private final Pattern certPatterns;
    private final CertificateUtil certUtil;
    private final AuditService auditService;
    private final ImportInfo importInfo;

    public CertificateCrawler(List<String> crawlDomains, String regEx, CertificateUtil certUtil, AuditService auditService, ImportInfo importInfo) {
        this.crawlDomains = ImmutableList.copyOf(crawlDomains);
        this.certPatterns = Pattern.compile(regEx);
        this.certUtil = certUtil;
        this.auditService = auditService;
        this.importInfo = importInfo;
    }

    public boolean shouldVisit(Page referringPage, WebURL url) {
        String href = url.getURL().toLowerCase();
        if (filters.matcher(href).matches()) {
            return false;
        }
        if (this.certPatterns.matcher(href).matches()) {
            this.LOGGER.debug("visiting {}", (Object)href);
            return true;
        }
        for (String domain : this.crawlDomains) {
            if (!href.startsWith(domain)) continue;
            this.LOGGER.debug("visiting {}", (Object)href);
            return true;
        }
        return false;
    }

    public void visit(Page page) {
        String url = page.getWebURL().getURL();
        if (!this.certPatterns.matcher(url).matches()) {
            return;
        }
        try {
            this.LOGGER.debug("new certificate at '{}' found, importing ...", (Object)url);
            Certificate certificate = this.certUtil.createCertificate(page.getContentData(), null, null, false, url);
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceCertificate("CRAWLER_CERTIFICATE_IMPORTED", certificate));
            this.importInfo.incImported();
        }
        catch (IOException | GeneralSecurityException e) {
            this.LOGGER.info("reading and importing certificate from '{}' causes {}", (Object)url, (Object)e.getLocalizedMessage());
        }
    }
}

