/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.CsrAttribute;
import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.domain.RDNAttribute;
import de.trustable.ca3s.core.domain.RequestAttribute;
import de.trustable.ca3s.core.domain.RequestAttributeValue;
import de.trustable.ca3s.core.domain.enumeration.CsrStatus;
import de.trustable.ca3s.core.domain.enumeration.PipelineType;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.CsrAttributeRepository;
import de.trustable.ca3s.core.repository.RDNAttributeRepository;
import de.trustable.ca3s.core.repository.RDNRepository;
import de.trustable.ca3s.core.repository.RequestAttributeRepository;
import de.trustable.ca3s.core.repository.RequestAttributeValueRepository;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.CryptoService;
import de.trustable.util.CryptoUtil;
import de.trustable.util.OidNameMapper;
import de.trustable.util.Pkcs10RequestHolder;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CSRUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CSRUtil.class);
    @Autowired
    private CSRRepository csrRepository;
    @Autowired
    private RDNRepository rdnRepository;
    @Autowired
    private RequestAttributeRepository rasRepository;
    @Autowired
    private RequestAttributeValueRepository rasvRepository;
    @Autowired
    private RDNAttributeRepository rdnAttRepository;
    @Autowired
    private CsrAttributeRepository csrAttRepository;
    @Autowired
    private CryptoService cryptoUtil;

    public Pkcs10RequestHolder parseBase64CSR(String csrBase64) throws IOException, GeneralSecurityException {
        Pkcs10RequestHolder p10ReqHolder = this.cryptoUtil.parseCertificateRequest(csrBase64);
        return p10ReqHolder;
    }

    public CSR buildCSR(String csrBase64, String requestorName, Pkcs10RequestHolder p10ReqHolder, Pipeline pipeline) throws IOException {
        return this.buildCSR(csrBase64, requestorName, p10ReqHolder, pipeline.getType(), pipeline);
    }

    public CSR buildCSR(String csrBase64, String requestorName, Pkcs10RequestHolder p10ReqHolder, PipelineType pipelineType, Pipeline pipeline) throws IOException {
        HashSet<RDNAttribute> rdnAttributes;
        de.trustable.ca3s.core.domain.RDN rdn;
        String[] parts;
        String sigAlgName;
        CSR csr = new CSR();
        csr.setStatus(CsrStatus.PENDING);
        csr.setPipeline(pipeline);
        csr.setPipelineType(pipelineType);
        csr.setCsrBase64(CryptoUtil.pkcs10RequestToPem((PKCS10CertificationRequest)p10ReqHolder.getP10Req()));
        csr.setSubject(p10ReqHolder.getSubject());
        String keyAlgName = sigAlgName = OidNameMapper.lookupOid((String)p10ReqHolder.getSigningAlgorithm());
        if (sigAlgName.toLowerCase().contains("with") && (parts = sigAlgName.toLowerCase().split("with")).length > 1) {
            if (parts[1].contains("and")) {
                String[] parts2 = parts[1].split("and");
                keyAlgName = parts2[0];
            } else {
                keyAlgName = parts[1];
            }
        }
        csr.setSigningAlgorithm(sigAlgName);
        csr.setIsCSRValid(Boolean.valueOf(p10ReqHolder.isCSRValid()));
        csr.setx509KeySpec(p10ReqHolder.getX509KeySpec());
        csr.setPublicKeyAlgorithm(keyAlgName);
        csr.setPublicKeyHash(p10ReqHolder.getPublicKeyHash());
        csr.setKeyLength(Integer.valueOf(CertificateUtil.getAlignedKeyLength((PublicKey)p10ReqHolder.getPublicSigningKey())));
        csr.setServersideKeyGeneration(Boolean.valueOf(false));
        csr.setSubjectPublicKeyInfoBase64(p10ReqHolder.getSubjectPublicKeyInfoBase64());
        csr.setRequestedOn(Instant.now());
        csr.setRequestedBy(requestorName);
        this.csrRepository.save((Object)csr);
        LOG.debug("RDN arr #" + p10ReqHolder.getSubjectRDNs().length);
        HashSet<de.trustable.ca3s.core.domain.RDN> newRdns = new HashSet<de.trustable.ca3s.core.domain.RDN>();
        for (String string : p10ReqHolder.getSubjectRDNs()) {
            AttributeTypeAndValue[] attrTVArr;
            rdn = new de.trustable.ca3s.core.domain.RDN();
            rdn.csr(csr);
            LOG.debug("AttributeTypeAndValue arr #" + string.size());
            rdnAttributes = new HashSet<RDNAttribute>();
            for (AttributeTypeAndValue attrTV : attrTVArr = string.getTypesAndValues()) {
                RDNAttribute rdnAttr = new RDNAttribute();
                rdnAttr.setRdn(rdn);
                rdnAttr.setAttributeType(attrTV.getType().toString());
                rdnAttr.setAttributeValue(attrTV.getValue().toString());
                rdnAttributes.add(rdnAttr);
            }
            rdn.setRdnAttributes(rdnAttributes);
            newRdns.add(rdn);
        }
        try {
            this.insertNameAttributes(csr, "SUBJECT", new LdapName(p10ReqHolder.getSubject()));
        }
        catch (InvalidNameException e) {
            LOG.info("problem parsing RDN for {}", (Object)p10ReqHolder.getSubject());
        }
        this.insertNameAttributes(csr, "SUBJECT", p10ReqHolder.getSubjectRDNs());
        Set gNameSet = this.getSANList(p10ReqHolder);
        String allSans = "";
        LOG.debug("putting SANs into CSRAttributes");
        for (GeneralName generalName : gNameSet) {
            String sanValue = generalName.getName().toString();
            if (0 == generalName.getTagNo()) {
                sanValue = "--other value--";
            }
            if (allSans.length() > 0) {
                allSans = allSans + ";";
            }
            allSans = allSans + sanValue;
            this.setCsrAttribute(csr, "SAN", sanValue, true);
            if (2 == generalName.getTagNo()) {
                this.setCsrAttribute(csr, "TYPED_SAN", "DNS:" + sanValue, true);
                continue;
            }
            if (7 == generalName.getTagNo()) {
                this.setCsrAttribute(csr, "TYPED_SAN", "IP:" + sanValue, true);
                continue;
            }
            if (5 == generalName.getTagNo()) {
                this.setCsrAttribute(csr, "TYPED_SAN", "EDI:" + sanValue, true);
                continue;
            }
            if (0 == generalName.getTagNo()) {
                this.setCsrAttribute(csr, "TYPED_SAN", "other:" + sanValue, true);
                continue;
            }
            if (8 == generalName.getTagNo()) {
                this.setCsrAttribute(csr, "TYPED_SAN", "regID:" + sanValue, true);
                continue;
            }
            if (1 == generalName.getTagNo()) {
                this.setCsrAttribute(csr, "TYPED_SAN", "rfc822:" + sanValue, true);
                continue;
            }
            if (6 == generalName.getTagNo()) {
                this.setCsrAttribute(csr, "TYPED_SAN", "URI:" + sanValue, true);
                continue;
            }
            if (3 == generalName.getTagNo()) {
                this.setCsrAttribute(csr, "TYPED_SAN", "X400:" + sanValue, true);
                continue;
            }
            if (4 == generalName.getTagNo()) {
                this.setCsrAttribute(csr, "TYPED_SAN", "DirName:" + sanValue, true);
                continue;
            }
            LOG.info("unexpected name / tag '{}' in SANs", (Object)generalName.getTagNo());
        }
        csr.setSans(CryptoUtil.limitLength((String)allSans, (int)250));
        if (p10ReqHolder.getSubjectRDNs().length == 0) {
            LOG.info("Subject empty, using SANs");
            for (GeneralName generalName : gNameSet) {
                if (2 != generalName.getTagNo()) continue;
                rdn = new de.trustable.ca3s.core.domain.RDN();
                rdn.csr(csr);
                rdnAttributes = new HashSet();
                RDNAttribute rdnAttr = new RDNAttribute();
                rdnAttr.setRdn(rdn);
                rdnAttr.setAttributeType(X509ObjectIdentifiers.commonName.toString());
                rdnAttr.setAttributeValue(generalName.getName().toString());
                rdnAttributes.add(rdnAttr);
                rdn.setRdnAttributes(rdnAttributes);
                newRdns.add(rdn);
                LOG.info("First DNS SAN inserted as CN: " + generalName.getName().toString());
                break;
            }
        }
        csr.setRdns(newRdns);
        HashSet<RequestAttribute> newRas = new HashSet<RequestAttribute>();
        for (Attribute attr : p10ReqHolder.getReqAttributes()) {
            RequestAttribute reqAttrs = new RequestAttribute();
            reqAttrs.setCsr(csr);
            reqAttrs.setAttributeType(attr.getAttrType().toString());
            HashSet<RequestAttributeValue> requestAttributes = new HashSet<RequestAttributeValue>();
            String type = attr.getAttrType().toString();
            ASN1Set valueSet = attr.getAttrValues();
            LOG.debug("AttributeSet type " + type + " #" + valueSet.size());
            for (ASN1Encodable asn1Enc : valueSet.toArray()) {
                String value = asn1Enc.toString();
                LOG.debug("Attribute value " + value);
                RequestAttributeValue reqAttrValue = new RequestAttributeValue();
                reqAttrValue.setReqAttr(reqAttrs);
                reqAttrValue.setAttributeValue(asn1Enc.toString());
                requestAttributes.add(reqAttrValue);
            }
            reqAttrs.setRequestAttributeValues(requestAttributes);
            newRas.add(reqAttrs);
        }
        csr.setRas(newRas);
        CsrAttribute csrAttribute = new CsrAttribute();
        csrAttribute.setCsr(csr);
        csrAttribute.setName("REQUESTOR_NAME");
        csrAttribute.setValue(requestorName);
        csr.getCsrAttributes().add(csrAttribute);
        this.rdnRepository.saveAll((Iterable)csr.getRdns());
        for (de.trustable.ca3s.core.domain.RDN rdn2 : csr.getRdns()) {
            this.rdnAttRepository.saveAll((Iterable)rdn2.getRdnAttributes());
        }
        this.rasRepository.saveAll((Iterable)csr.getRas());
        for (RequestAttribute ras : csr.getRas()) {
            this.rasvRepository.saveAll((Iterable)ras.getRequestAttributeValues());
        }
        this.csrAttRepository.saveAll((Iterable)csr.getCsrAttributes());
        this.csrRepository.save((Object)csr);
        LOG.debug("saved #{} csr attributes,  ", (Object)newRas.size());
        return csr;
    }

    Set<GeneralName> getSANList(Pkcs10RequestHolder p10ReqHolder) {
        return CSRUtil.getSANList((Attribute[])p10ReqHolder.getReqAttributes());
    }

    public static void retrieveSANFromCSRAttribute(Set<GeneralName> sanSet, Attribute attrExtension) {
        ASN1Set valueSet = attrExtension.getAttrValues();
        LOG.info("ExtensionRequest / AttrValues has " + valueSet.size() + " elements");
        for (ASN1Encodable asn1Enc : valueSet) {
            if (asn1Enc instanceof DERSequence) {
                DERSequence derSeq = (DERSequence)asn1Enc;
                LOG.debug("ExtensionRequest / DERSequence has " + derSeq.size() + " elements");
                CSRUtil.extractSANsFromArray(sanSet, (ASN1Encodable[])derSeq.toArray());
                continue;
            }
            if (asn1Enc instanceof DLSequence) {
                DLSequence dlSeq = (DLSequence)asn1Enc;
                LOG.debug("ExtensionRequest / DLSequence has " + dlSeq.size() + " elements");
                CSRUtil.extractSANsFromArray(sanSet, (ASN1Encodable[])dlSeq.toArray());
                continue;
            }
            LOG.info("asn1Enc in valueSet is of an unexpected type " + asn1Enc.getClass().getName());
        }
    }

    static void extractSANsFromArray(Set<GeneralName> sanSet, ASN1Encodable[] asn1Array) {
        for (ASN1Encodable asn1Enc : asn1Array) {
            Method[] methods;
            LOG.debug("ExtensionRequest / asn1Enc2 is a " + asn1Enc.getClass().getName());
            ASN1Encodable asn1EncValue = null;
            ASN1ObjectIdentifier objId = null;
            if (asn1Enc instanceof DERSequence) {
                DERSequence derSeq2 = (DERSequence)asn1Enc;
                LOG.debug("ExtensionRequest / DERSequence2 has " + derSeq2.size() + " elements");
                LOG.debug("ExtensionRequest / DERSequence2[0] is a " + derSeq2.getObjectAt(0).getClass().getName());
                objId = (ASN1ObjectIdentifier)derSeq2.getObjectAt(0);
                asn1EncValue = derSeq2.getObjectAt(1);
            } else if (asn1Enc instanceof DLSequence) {
                DLSequence dlSeq = (DLSequence)asn1Enc;
                LOG.debug("DLSequence has " + dlSeq.size() + " elements");
                objId = (ASN1ObjectIdentifier)dlSeq.getObjectAt(0);
                asn1EncValue = dlSeq.getObjectAt(1);
            } else {
                LOG.info("asn1Enc in asn1Array is of an unexpected type " + asn1Enc.getClass().getName());
                continue;
            }
            LOG.debug("ExtensionRequest / DERSequence2[1] (asn1EncValue)is a " + asn1EncValue.getClass().getName());
            String attrReadableName = OidNameMapper.lookupOid((String)objId.getId());
            if (Extension.subjectAlternativeName.equals((ASN1Primitive)objId)) {
                DEROctetString derStr = (DEROctetString)asn1EncValue;
                byte[] valBytes = derStr.getOctets();
                GeneralNames names = GeneralNames.getInstance((Object)valBytes);
                LOG.debug("Attribute value SAN" + names);
                LOG.debug("SAN values #" + names.getNames().length);
                GeneralName[] generalNameArray = names.getNames();
                int n = generalNameArray.length;
                for (int i = 0; i < n; ++i) {
                    GeneralName gnSAN = generalNameArray[i];
                    LOG.debug("GN " + gnSAN.getName().toString());
                    sanSet.add(gnSAN);
                }
                continue;
            }
            String stringValue = asn1EncValue.toString();
            for (Method m : methods = asn1EncValue.getClass().getMethods()) {
                try {
                    if ("getString".equals(m.getName())) {
                        stringValue = (String)m.invoke((Object)asn1EncValue, new Object[0]);
                        break;
                    }
                    if ("getOctets".equals(m.getName())) {
                        stringValue = new String((byte[])m.invoke((Object)asn1EncValue, new Object[0]));
                        break;
                    }
                    if ("getValue".equals(m.getName())) {
                        stringValue = (String)m.invoke((Object)asn1EncValue, new Object[0]);
                        break;
                    }
                    if ("getId".equals(m.getName())) {
                        stringValue = OidNameMapper.lookupOid((String)((String)m.invoke((Object)asn1EncValue, new Object[0])));
                        break;
                    }
                    if (!"getAdjustedDate".equals(m.getName())) continue;
                    stringValue = (String)m.invoke((Object)asn1EncValue, new Object[0]);
                    break;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    LOG.debug("invoking " + m.getName(), (Throwable)e);
                }
            }
            LOG.debug("found attrReadableName '{}' with value '{}'", (Object)attrReadableName, (Object)stringValue);
        }
    }

    public static Set<GeneralName> getSANList(Attribute[] reqAttributes) {
        HashSet<GeneralName> generalNameSet = new HashSet<GeneralName>();
        for (Attribute attr : reqAttributes) {
            if (!PKCSObjectIdentifiers.pkcs_9_at_extensionRequest.equals((ASN1Primitive)attr.getAttrType())) continue;
            CSRUtil.retrieveSANFromCSRAttribute(generalNameSet, (Attribute)attr);
        }
        return generalNameSet;
    }

    public static String getGeneralNameType(GeneralName gName) {
        if (2 == gName.getTagNo()) {
            return "DNS name";
        }
        if (4 == gName.getTagNo()) {
            return "directory name";
        }
        if (5 == gName.getTagNo()) {
            return "edi party name";
        }
        if (7 == gName.getTagNo()) {
            return "ip address";
        }
        if (0 == gName.getTagNo()) {
            return "other name";
        }
        if (1 == gName.getTagNo()) {
            return "rfc822 name";
        }
        if (6 == gName.getTagNo()) {
            return "URI";
        }
        if (3 == gName.getTagNo()) {
            return "x400 address";
        }
        return "unexpected identifier '" + gName.getTagNo() + "'";
    }

    public static String getGeneralNameDescription(GeneralName gName) {
        return CertificateUtil.getTypedSAN((int)gName.getTagNo(), (String)gName.getName().toString());
    }

    public void setStatus(CSR csrDao, CsrStatus status) {
        csrDao.setStatus(status);
        this.csrRepository.save((Object)csrDao);
    }

    public String getCSRAttribute(CSR csrDao, String name) {
        for (CsrAttribute csrAttr : csrDao.getCsrAttributes()) {
            if (!csrAttr.getName().equals(name)) continue;
            return csrAttr.getValue();
        }
        return null;
    }

    public void insertNameAttributes(CSR csr, String attributeName, LdapName ldapName) {
        List<Rdn> rdnList = ldapName.getRdns();
        for (Rdn rdn : rdnList) {
            String rdnExpression = rdn.getType().toLowerCase() + "=" + rdn.getValue().toString().toLowerCase().trim();
            this.setCsrAttribute(csr, attributeName, rdnExpression, true);
        }
    }

    public void insertNameAttributes(CSR csr, String attributeName, RDN[] rdns) {
        for (RDN rdn : rdns) {
            for (AttributeTypeAndValue atv : rdn.getTypesAndValues()) {
                String value = atv.getValue().toString().toLowerCase().trim();
                this.setCsrAttribute(csr, attributeName, value, true);
                String oid = atv.getType().getId().toLowerCase();
                this.setCsrAttribute(csr, attributeName, oid + "=" + value, true);
                if (oid.equals(atv.getType().toString().toLowerCase())) continue;
                this.setCsrAttribute(csr, attributeName, atv.getType().toString().toLowerCase() + "=" + value, true);
            }
        }
    }

    public void setCsrAttribute(CSR csr, String name, String value, boolean multiValue) {
        if (name == null) {
            LOG.warn("no use to insert attribute with name 'null'", (Throwable)new Exception());
            return;
        }
        if (value == null) {
            value = "";
        }
        Set csrAttrList = csr.getCsrAttributes();
        for (CsrAttribute csrAttr : csrAttrList) {
            if (!name.equals(csrAttr.getName())) continue;
            if (value.equals(csrAttr.getValue())) {
                return;
            }
            if (multiValue) continue;
            csrAttr.setValue(value);
            return;
        }
        CsrAttribute cAtt = new CsrAttribute();
        cAtt.setCsr(csr);
        cAtt.setName(name);
        cAtt.setValue(value);
        csr.getCsrAttributes().add(cAtt);
        this.csrAttRepository.save((Object)cAtt);
    }
}

