/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.AcmeContact;
import de.trustable.ca3s.core.service.AcmeContactService;
import de.trustable.ca3s.core.web.rest.errors.BadRequestAlertException;
import io.github.jhipster.web.util.HeaderUtil;
import io.github.jhipster.web.util.ResponseUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class AcmeContactResource {
    private final Logger log = LoggerFactory.getLogger(AcmeContactResource.class);
    private static final String ENTITY_NAME = "acmeContact";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final AcmeContactService acmeContactService;

    public AcmeContactResource(AcmeContactService acmeContactService) {
        this.acmeContactService = acmeContactService;
    }

    @PostMapping(value={"/acme-contacts"})
    public ResponseEntity<AcmeContact> createAcmeContact(@Valid @RequestBody AcmeContact acmeContact) throws URISyntaxException {
        this.log.debug("REST request to save AcmeContact : {}", (Object)acmeContact);
        if (acmeContact.getId() != null) {
            throw new BadRequestAlertException("A new acmeContact cannot already have an ID", ENTITY_NAME, "idexists");
        }
        AcmeContact result = this.acmeContactService.save(acmeContact);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/acme-contacts/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/acme-contacts"})
    public ResponseEntity<AcmeContact> updateAcmeContact(@Valid @RequestBody AcmeContact acmeContact) throws URISyntaxException {
        this.log.debug("REST request to update AcmeContact : {}", (Object)acmeContact);
        if (acmeContact.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        AcmeContact result = this.acmeContactService.save(acmeContact);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)acmeContact.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/acme-contacts"})
    public List<AcmeContact> getAllAcmeContacts() {
        this.log.debug("REST request to get all AcmeContacts");
        return this.acmeContactService.findAll();
    }

    @GetMapping(value={"/acme-contacts/{id}"})
    public ResponseEntity<AcmeContact> getAcmeContact(@PathVariable Long id) {
        this.log.debug("REST request to get AcmeContact : {}", (Object)id);
        Optional acmeContact = this.acmeContactService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)acmeContact);
    }

    @DeleteMapping(value={"/acme-contacts/{id}"})
    public ResponseEntity<Void> deleteAcmeContact(@PathVariable Long id) {
        this.log.debug("REST request to delete AcmeContact : {}", (Object)id);
        this.acmeContactService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

