/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.repository.CSRViewRepository;
import de.trustable.ca3s.core.service.dto.CSRView;
import io.github.jhipster.web.util.PaginationUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api"})
public class CSRListResource {
    @Autowired
    CSRViewRepository csrViewRepository;
    private final Logger log = LoggerFactory.getLogger(CSRListResource.class);

    @GetMapping(value={"/csrList"})
    public ResponseEntity<List<CSRView>> getAllCertificates(Pageable pageable, HttpServletRequest request) {
        this.log.debug("REST request to get a page of CSRViews");
        Page page = this.csrViewRepository.findSelection(request.getParameterMap());
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)page.getContent());
    }
}

