/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.service.CertificateService;
import de.trustable.ca3s.core.web.rest.errors.BadRequestAlertException;
import io.github.jhipster.web.util.HeaderUtil;
import io.github.jhipster.web.util.PaginationUtil;
import io.github.jhipster.web.util.ResponseUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api"})
public class CertificateResource {
    private final Logger log = LoggerFactory.getLogger(CertificateResource.class);
    private static final String ENTITY_NAME = "certificate";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final CertificateService certificateService;

    public CertificateResource(CertificateService certificateService) {
        this.certificateService = certificateService;
    }

    @PostMapping(value={"/certificates"})
    public ResponseEntity<Certificate> createCertificate(@Valid @RequestBody Certificate certificate) throws URISyntaxException {
        this.log.debug("REST request to save Certificate : {}", (Object)certificate);
        if (certificate.getId() != null) {
            throw new BadRequestAlertException("A new certificate cannot already have an ID", ENTITY_NAME, "idexists");
        }
        Certificate result = this.certificateService.save(certificate);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/certificates/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/certificates"})
    public ResponseEntity<Certificate> updateCertificate(@Valid @RequestBody Certificate certificate) throws URISyntaxException {
        this.log.debug("REST request to update Certificate : {}", (Object)certificate);
        if (certificate.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        Certificate result = this.certificateService.save(certificate);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)certificate.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/certificates"})
    public ResponseEntity<List<Certificate>> getAllCertificates(Pageable pageable) {
        this.log.debug("REST request to get a page of Certificates");
        Page page = this.certificateService.findAll(pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)page.getContent());
    }

    @GetMapping(value={"/certificates/{id}"})
    public ResponseEntity<Certificate> getCertificate(@PathVariable Long id) {
        this.log.debug("REST request to get Certificate : {}", (Object)id);
        Optional certificate = this.certificateService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)certificate);
    }

    @DeleteMapping(value={"/certificates/{id}"})
    public ResponseEntity<Void> deleteCertificate(@PathVariable Long id) {
        this.log.debug("REST request to delete Certificate : {}", (Object)id);
        this.certificateService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

