/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.CertificateAttribute;
import de.trustable.ca3s.core.domain.CsrAttribute;
import de.trustable.ca3s.core.domain.ProtectedContent;
import de.trustable.ca3s.core.domain.enumeration.ContentRelationType;
import de.trustable.ca3s.core.domain.enumeration.ProtectedContentType;
import de.trustable.ca3s.core.repository.CertificateAttributeRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.repository.ProtectedContentRepository;
import de.trustable.ca3s.core.service.util.CryptoService;
import de.trustable.ca3s.core.service.util.DateUtil;
import de.trustable.ca3s.core.service.util.ProtectedContentUtil;
import de.trustable.util.CryptoUtil;
import de.trustable.util.OidNameMapper;
import de.trustable.util.Pkcs10RequestHolder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStrictStyle;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.CertificatePolicies;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.JCEECPublicKey;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.bouncycastle.x509.extension.X509ExtensionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CertificateUtil {
    private static final String SERIAL_PADDING_PATTERN = "000000000000000000000000000000000000000000000000000000000000000";
    private static final String TIMESTAMP_PADDING_PATTERN = "000000000000000000";
    public static final int CURRENT_ATTRIBUTES_VERSION = 2;
    static HashSet<Integer> lenSet = new HashSet();
    private static final Logger LOG;
    @Autowired
    private CertificateRepository certificateRepository;
    @Autowired
    private CertificateAttributeRepository certificateAttributeRepository;
    @Autowired
    private ProtectedContentRepository protContentRepository;
    @Autowired
    private ProtectedContentUtil protUtil;
    @Autowired
    private CryptoService cryptoUtil;

    public String getNormalizedName(String inputName) throws InvalidNameException {
        try {
            X500Name x500Name = new X500Name(BCStrictStyle.INSTANCE, inputName);
            return new LdapName(x500Name.toString()).toString();
        }
        catch (Exception ex) {
            LOG.error("problem normalizing name : '" + inputName + "'", (Throwable)ex);
            return inputName;
        }
    }

    X509Certificate getCertifcateFromBase64(String base64Cert) throws CertificateException {
        return this.getCertifcateFromBytes(Base64.decodeBase64((String)base64Cert));
    }

    X509Certificate getCertifcateFromBytes(byte[] encodedCert) throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(encodedCert));
    }

    public Certificate createCertificate(byte[] encodedCert, CSR csr, String executionId, boolean reimport) throws GeneralSecurityException, IOException {
        return this.createCertificate(encodedCert, csr, executionId, reimport, null);
    }

    public Certificate createCertificate(byte[] encodedCert, CSR csr, String executionId, boolean reimport, String importUrl) throws GeneralSecurityException, IOException {
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(encodedCert));
            String pemCert = this.cryptoUtil.x509CertToPem(cert);
            return this.createCertificate(pemCert, csr, executionId, reimport, importUrl);
        }
        catch (IOException | GeneralSecurityException e) {
            LOG.debug("problem importing certificate: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Throwable th) {
            LOG.debug("problem importing certificate: " + th.getMessage(), th);
            throw new GeneralSecurityException("problem importing certificate: " + th.getMessage());
        }
    }

    public Certificate createCertificate(String pemCert, CSR csr, String executionId) throws GeneralSecurityException, IOException {
        return this.createCertificate(pemCert, csr, executionId, false, null);
    }

    public Certificate createCertificate(String pemCert, CSR csr, String executionId, boolean reimport) throws GeneralSecurityException, IOException {
        return this.createCertificate(pemCert, csr, executionId, false, null);
    }

    public Certificate getCertificateByBase64(String b64Cert) throws GeneralSecurityException, IOException {
        X509Certificate x509Cert = this.getCertifcateFromBase64(b64Cert);
        return this.getCertificateByX509(x509Cert);
    }

    public Certificate getCertificateByPEM(String pemCert) throws GeneralSecurityException, IOException {
        X509Certificate x509Cert = CryptoService.convertPemToCertificate((String)pemCert);
        return this.getCertificateByX509(x509Cert);
    }

    public Certificate getCertificateByX509(X509Certificate x509Cert) throws GeneralSecurityException, IOException {
        String tbsDigestBase64 = Base64.encodeBase64String((byte[])this.cryptoUtil.getSHA256Digest(x509Cert.getTBSCertificate())).toLowerCase();
        LOG.debug("looking for TBS hash '" + tbsDigestBase64 + "' in certificate store");
        List certList = this.certificateRepository.findByTBSDigest(tbsDigestBase64);
        if (certList.isEmpty()) {
            return null;
        }
        if (certList.size() > 1) {
            LOG.debug("#{} certificates found in certificate database for TBS hash '{}'", (Object)certList.size(), (Object)tbsDigestBase64);
            return (Certificate)certList.get(0);
        }
        return (Certificate)certList.get(0);
    }

    public Certificate createCertificate(String pemCert, CSR csr, String executionId, boolean reimport, String importUrl) throws GeneralSecurityException, IOException {
        X509Certificate x509Cert = CryptoService.convertPemToCertificate((String)pemCert);
        Certificate cert = this.getCertificateByX509(x509Cert);
        if (cert == null) {
            String tbsDigestBase64 = Base64.encodeBase64String((byte[])this.cryptoUtil.getSHA256Digest(x509Cert.getTBSCertificate())).toLowerCase();
            cert = this.createCertificate(pemCert, csr, executionId, x509Cert, tbsDigestBase64);
            this.setCertAttribute(cert, "SOURCE", importUrl);
        } else {
            LOG.info("certificate '" + cert.getSubject() + "' already exists");
            if (reimport) {
                LOG.debug("existing certificate '" + cert.getSubject() + "' overwriting some attributes, only");
                this.addAdditionalCertificateAttributes(x509Cert, cert);
            }
        }
        return cert;
    }

    private Certificate createCertificate(String pemCert, CSR csr, String executionId, X509Certificate x509Cert, String tbsDigestBase64) throws CertificateEncodingException, IOException, NoSuchAlgorithmException, CertificateParsingException, CertificateException, InvalidKeyException, NoSuchProviderException, SignatureException {
        LOG.debug("creating new certificate '" + x509Cert.getSubjectDN().getName() + "'");
        byte[] certBytes = x509Cert.getEncoded();
        X509CertificateHolder x509CertHolder = new X509CertificateHolder(certBytes);
        Certificate cert = new Certificate();
        cert.setCertificateAttributes(new HashSet());
        String type = "X509V" + x509Cert.getVersion();
        cert.setType(type);
        String serial = x509Cert.getSerialNumber().toString();
        cert.setSerial(serial);
        cert.setContent(pemCert);
        if (csr != null) {
            cert.setCsr(csr);
        }
        cert.setTbsDigest(tbsDigestBase64);
        String desc = this.cryptoUtil.getDescription(x509Cert);
        cert.setDescription(CryptoService.limitLength((String)desc, (int)250));
        String fingerprint = Base64.encodeBase64String((byte[])CertificateUtil.generateSHA1Fingerprint((byte[])certBytes));
        cert.setFingerprint(fingerprint);
        cert.setValidFrom(DateUtil.asInstant((Date)x509Cert.getNotBefore()));
        cert.setValidTo(DateUtil.asInstant((Date)x509Cert.getNotAfter()));
        cert.setActive(Boolean.valueOf(true));
        Date now = new Date();
        if (x509Cert.getNotBefore().after(now)) {
            cert.setActive(Boolean.valueOf(false));
        }
        if (x509Cert.getNotAfter().before(now)) {
            cert.setActive(Boolean.valueOf(false));
        }
        cert.setRevokedSince(null);
        cert.setRevocationReason(null);
        cert.setRevoked(Boolean.valueOf(false));
        if (executionId != null) {
            cert.setCreationExecutionId(executionId);
        }
        cert.setContentAddedAt(Instant.now());
        String issuer = CryptoService.limitLength((String)x509Cert.getIssuerDN().getName(), (int)250);
        cert.setIssuer(issuer);
        String subject = CryptoService.limitLength((String)x509Cert.getSubjectDN().getName(), (int)250);
        cert.setSubject(subject);
        cert.setSelfsigned(Boolean.valueOf(false));
        this.certificateRepository.save((Object)cert);
        int basicConstraint = x509Cert.getBasicConstraints();
        if (Integer.MAX_VALUE == basicConstraint) {
            cert.setEndEntity(Boolean.valueOf(true));
            this.setCertAttribute(cert, "CA3S:CA", "true");
        } else if (-1 == basicConstraint) {
            cert.setEndEntity(Boolean.valueOf(true));
            this.setCertAttribute(cert, "CA3S:END_ENTITY", "true");
        } else {
            cert.setEndEntity(Boolean.valueOf(true));
            this.setCertAttribute(cert, "CA3S:CA", "true");
            this.setCertAttribute(cert, "CA3S:CHAIN_LENGTH", "" + basicConstraint);
        }
        this.usageAsCertAttributes(x509Cert.getKeyUsage(), cert);
        List<String> extKeyUsageList = x509Cert.getExtendedKeyUsage();
        if (extKeyUsageList != null) {
            for (String extUsage : extKeyUsageList) {
                this.setCertMultiValueAttribute(cert, "EXTENDED_USAGE_OID", extUsage);
                this.setCertMultiValueAttribute(cert, "EXTENDED_USAGE", OidNameMapper.lookupOid((String)extUsage));
            }
        }
        this.setCertAttribute(cert, "ISSUER", issuer.toLowerCase());
        X500Name x500NameIssuer = x509CertHolder.getIssuer();
        this.insertNameAttributes(cert, "ISSUER", x500NameIssuer);
        this.setCertAttribute(cert, "SUBJECT", subject.toLowerCase());
        X500Name x500NameSubject = x509CertHolder.getSubject();
        this.insertNameAttributes(cert, "SUBJECT", x500NameSubject);
        this.setCertAttribute(cert, "TYPE", type);
        JcaX509ExtensionUtils util = new JcaX509ExtensionUtils();
        SubjectKeyIdentifier ski = util.createSubjectKeyIdentifier(x509Cert.getPublicKey());
        String b46Ski = Base64.encodeBase64String((byte[])ski.getKeyIdentifier());
        this.setCertAttribute(cert, "SKI", b46Ski);
        SubjectKeyIdentifier skiTruncated = util.createTruncatedSubjectKeyIdentifier(x509Cert.getPublicKey());
        if (!ski.equals((Object)skiTruncated)) {
            this.setCertAttribute(cert, "SKI", Base64.encodeBase64String((byte[])skiTruncated.getKeyIdentifier()));
        }
        this.setCertAttribute(cert, "SERIAL", serial);
        this.setCertAttribute(cert, "SERIAL_PADDED", CertificateUtil.getPaddedSerial((String)serial));
        this.setCertAttribute(cert, "VALID_FROM_TIMESTAMP", "" + x509Cert.getNotBefore().getTime());
        this.setCertAttribute(cert, "VALID_TO_TIMESTAMP", "" + x509Cert.getNotAfter().getTime());
        long validityPeriod = (x509Cert.getNotAfter().getTime() - x509Cert.getNotBefore().getTime()) / 1000L;
        this.setCertAttribute(cert, "VALIDITY_PERIOD", "" + validityPeriod);
        this.addAdditionalCertificateAttributes(x509Cert, cert);
        this.copyArAttributes(csr, cert);
        this.certificateRepository.save((Object)cert);
        this.certificateAttributeRepository.saveAll((Iterable)cert.getCertificateAttributes());
        if (x500NameIssuer.equals((Object)x500NameSubject)) {
            x509Cert.verify(x509Cert.getPublicKey());
            cert.setSelfsigned(Boolean.valueOf(true));
            this.setCertAttribute(cert, "CA3S:SELFSIGNED", "true");
            cert.setIssuingCertificate(null);
            cert.setRootCertificate(null);
            cert.setRoot(cert.getSubject());
            this.setCertAttribute(cert, "ROOT", cert.getSubject().toLowerCase());
            LOG.debug("certificate '" + x509Cert.getSubjectDN().getName() + "' is selfsigned");
        } else {
            try {
                Certificate issuingCert = this.findIssuingCertificate(x509CertHolder);
                if (issuingCert == null) {
                    LOG.info("unable to find issuer for non-self-signed certificate '" + x509Cert.getSubjectDN().getName() + "' right now ...");
                } else {
                    cert.setIssuingCertificate(issuingCert);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("certificate '" + x509Cert.getSubjectDN().getName() + "' issued by " + issuingCert.getSubject());
                    }
                }
                Certificate rootCert = this.findRootCertificate(issuingCert);
                if (rootCert != null) {
                    cert.setRootCertificate(rootCert);
                    cert.setRoot(rootCert.getSubject());
                    this.setCertAttribute(cert, "ROOT", rootCert.getSubject().toLowerCase());
                }
            }
            catch (GeneralSecurityException gse) {
                LOG.info("problem retrieving issuer for certificate '" + x509Cert.getSubjectDN().getName() + "' right now ...");
            }
        }
        this.certificateRepository.save((Object)cert);
        this.certificateAttributeRepository.saveAll((Iterable)cert.getCertificateAttributes());
        LOG.debug("certificate id '{}' saved containing #{} attributes", (Object)cert.getId(), (Object)cert.getCertificateAttributes().size());
        for (CertificateAttribute cad : cert.getCertificateAttributes()) {
            LOG.debug("Name '" + cad.getName() + "' got value '" + cad.getValue() + "'");
        }
        return cert;
    }

    private void copyArAttributes(CSR csr, Certificate cert) {
        if (csr == null || cert == null) {
            return;
        }
        for (CsrAttribute csrAttr : csr.getCsrAttributes()) {
            if (!csrAttr.getName().startsWith("_ARA_")) continue;
            this.setCertAttribute(cert, csrAttr.getName(), csrAttr.getValue());
        }
    }

    public void addAdditionalCertificateAttributes(X509Certificate x509Cert, Certificate cert) throws CertificateParsingException, IOException {
        int version = Integer.parseInt(this.getCertAttribute(cert, "ATTRIBUTES_VERSION", "0"));
        if (version == 0) {
            Collection<List<?>> altNames;
            block33: {
                String[] parts;
                String sigAlgName = x509Cert.getSigAlgName().toLowerCase();
                String keyAlgName = x509Cert.getPublicKey().getAlgorithm();
                String hashAlgName = "undefined";
                String paddingAlgName = "PKCS1";
                if (sigAlgName.contains("with") && (parts = sigAlgName.split("with")).length > 1) {
                    hashAlgName = parts[0];
                    if (parts[1].contains("and")) {
                        String[] parts2 = parts[1].split("and");
                        sigAlgName = parts2[0];
                        if (parts2.length > 1) {
                            paddingAlgName = parts2[1];
                        }
                    } else {
                        sigAlgName = parts[1];
                    }
                }
                cert.setKeyAlgorithm(keyAlgName.toLowerCase());
                cert.setHashingAlgorithm(hashAlgName.toLowerCase());
                cert.setPaddingAlgorithm(paddingAlgName.toLowerCase());
                cert.setSigningAlgorithm(sigAlgName.toLowerCase());
                try {
                    String curveName = CertificateUtil.deriveCurveName((PublicKey)x509Cert.getPublicKey());
                    LOG.info("found curve name " + curveName + " for certificate '" + x509Cert.getSubjectDN().getName() + "' with key algo " + keyAlgName);
                    cert.setCurveName(curveName.toLowerCase());
                }
                catch (GeneralSecurityException e) {
                    if (!keyAlgName.contains("ec")) break block33;
                    LOG.info("unable to derive curve name for certificate '" + x509Cert.getSubjectDN().getName() + "' with key algo " + keyAlgName);
                }
            }
            String subject = x509Cert.getSubjectDN().getName();
            if (subject != null && subject.trim().length() > 0) {
                try {
                    InetAddressValidator inv = InetAddressValidator.getInstance();
                    List<Rdn> rdnList = new LdapName(subject).getRdns();
                    for (Rdn rdn : rdnList) {
                        if (!"CN".equalsIgnoreCase(rdn.getType())) continue;
                        String cn = rdn.getValue().toString();
                        if (inv.isValid(cn)) {
                            LOG.debug("CN found IP in subject: '{}'", (Object)cn);
                            this.setCertMultiValueAttribute(cert, "TYPED_VSAN", "IP:" + cn);
                            continue;
                        }
                        LOG.debug("CN found DNS name in subject: '{}'", (Object)cn);
                        this.setCertMultiValueAttribute(cert, "TYPED_VSAN", "DNS:" + cn);
                    }
                }
                catch (InvalidNameException e) {
                    e.printStackTrace();
                }
            }
            String allSans = "";
            if (x509Cert.getSubjectAlternativeNames() != null && (altNames = x509Cert.getSubjectAlternativeNames()) != null) {
                for (List list : altNames) {
                    int altNameType = (Integer)list.get(0);
                    Object sanValue = "";
                    if (list.get(1) instanceof String) {
                        sanValue = ((String)list.get(1)).toLowerCase();
                    } else if (0 != altNameType) {
                        if (list.get(1) instanceof byte[]) {
                            sanValue = new String((byte[])list.get(1)).toLowerCase();
                        } else {
                            LOG.info("unexpected content type in SANS : {}", (Object)list.get(1).toString());
                        }
                    }
                    if (allSans.length() > 0) {
                        allSans = allSans + ";";
                    }
                    allSans = allSans + (String)sanValue;
                    this.setCertMultiValueAttribute(cert, "SAN", (String)sanValue);
                    this.setCertMultiValueAttribute(cert, "TYPED_SAN", CertificateUtil.getTypedSAN((int)altNameType, (String)sanValue));
                }
            }
            cert.setSans(CryptoUtil.limitLength((String)allSans, (int)250));
            int keyLength = CertificateUtil.getAlignedKeyLength((PublicKey)x509Cert.getPublicKey());
            cert.setKeyLength(Integer.valueOf(keyLength));
            List crlUrls = this.getCrlDistributionPoints(x509Cert);
            for (String crlUrl : crlUrls) {
                this.setCertAttribute(cert, "CRL_URL", crlUrl);
            }
            String string = this.getOCSPUrl(x509Cert);
            if (string != null) {
                this.setCertAttribute(cert, "OCSP_URL", string);
            }
            List certificatePolicyIds = this.getCertificatePolicies(x509Cert);
            for (String polId : certificatePolicyIds) {
                this.setCertAttribute(cert, "POLICY_ID", polId);
            }
        }
        if (version < 2) {
            try {
                this.setCertAttribute(cert, "FINGERPRINT_SHA1", DigestUtils.sha1Hex((byte[])x509Cert.getEncoded()).toLowerCase());
                this.setCertAttribute(cert, "FINGERPRINT_SHA256", DigestUtils.sha3_256Hex((byte[])x509Cert.getEncoded()).toLowerCase());
            }
            catch (CertificateEncodingException e) {
                LOG.error("Problem getting encoded certificate '" + x509Cert.getSubjectDN().getName() + "'", (Throwable)e);
            }
            try {
                X500Name x500Name = new X500Name(cert.getSubject());
                for (RDN rdn : x500Name.getRDNs()) {
                    AttributeTypeAndValue[] attrTVArr;
                    for (AttributeTypeAndValue attrTV : attrTVArr = rdn.getTypesAndValues()) {
                        String rdnReadableName = OidNameMapper.lookupOid((String)attrTV.getType().toString());
                        this.setCertAttribute(cert, "RDN_" + rdnReadableName.toUpperCase(), attrTV.getValue().toString());
                    }
                }
            }
            catch (IllegalArgumentException iae) {
                LOG.error("Problem building X500Name for subject for certificate '" + x509Cert.getSubjectDN().getName() + "'", (Throwable)iae);
            }
        }
        if (version < 2) {
            try {
                String subjectRfc2253 = this.getNormalizedName(cert.getSubject());
                this.setCertAttribute(cert, "SUBJECT_RFC_2253", subjectRfc2253, false);
            }
            catch (InvalidNameException e) {
                LOG.error("Problem building RFC 2253-styled subject for  certificate '" + x509Cert.getSubjectDN().getName() + "'", (Throwable)e);
            }
            this.setCertAttribute(cert, "ATTRIBUTES_VERSION", "2", false);
        }
    }

    public List<String> getCertificatePolicies(X509Certificate x509Cert) {
        ArrayList<String> certificatePolicyIds = new ArrayList<String>();
        byte[] extVal = x509Cert.getExtensionValue(Extension.certificatePolicies.getId());
        if (extVal == null) {
            return certificatePolicyIds;
        }
        try {
            PolicyInformation[] information;
            CertificatePolicies cf = CertificatePolicies.getInstance((Object)X509ExtensionUtil.fromExtensionValue((byte[])extVal));
            for (PolicyInformation p : information = cf.getPolicyInformation()) {
                ASN1ObjectIdentifier aIdentifier = p.getPolicyIdentifier();
                certificatePolicyIds.add(aIdentifier.getId());
            }
        }
        catch (IOException ex) {
            LOG.error("Failed to get OCSP URL for certificate '" + x509Cert.getSubjectDN().getName() + "'", (Throwable)ex);
        }
        return certificatePolicyIds;
    }

    private String getOCSPUrl(X509Certificate x509Cert) {
        AccessDescription[] accessDescriptions;
        ASN1Primitive obj;
        try {
            obj = CertificateUtil.getExtensionValue((X509Certificate)x509Cert, (String)Extension.authorityInfoAccess.getId());
        }
        catch (IOException ex) {
            LOG.error("Failed to get OCSP URL for certificate '" + x509Cert.getSubjectDN().getName() + "'", (Throwable)ex);
            return null;
        }
        if (obj == null) {
            return null;
        }
        AuthorityInformationAccess authorityInformationAccess = AuthorityInformationAccess.getInstance((Object)obj);
        for (AccessDescription accessDescription : accessDescriptions = authorityInformationAccess.getAccessDescriptions()) {
            GeneralName name;
            boolean correctAccessMethod = accessDescription.getAccessMethod().equals((ASN1Primitive)X509ObjectIdentifiers.ocspAccessMethod);
            if (!correctAccessMethod || (name = accessDescription.getAccessLocation()).getTagNo() != 6) continue;
            DERIA5String derStr = DERIA5String.getInstance((ASN1TaggedObject)((ASN1TaggedObject)name.toASN1Primitive()), (boolean)false);
            return derStr.getString();
        }
        return null;
    }

    private static ASN1Primitive getExtensionValue(X509Certificate x509Cert, String oid) throws IOException {
        byte[] bytes = x509Cert.getExtensionValue(oid);
        if (bytes == null) {
            return null;
        }
        ASN1InputStream aIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(bytes));
        ASN1OctetString octs = (ASN1OctetString)aIn.readObject();
        aIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(octs.getOctets()));
        return aIn.readObject();
    }

    public static String getTypedSAN(int altNameType, String sanValue) {
        if (2 == altNameType) {
            return "DNS:" + sanValue;
        }
        if (7 == altNameType) {
            String normalizedIpAddress = sanValue;
            try {
                normalizedIpAddress = InetAddress.getByName(sanValue).getHostAddress();
            }
            catch (UnknownHostException e) {
                LOG.debug("Problem parsing ip address '" + sanValue + "'!", (Object)e.getLocalizedMessage());
            }
            return "IP:" + normalizedIpAddress;
        }
        if (5 == altNameType) {
            return "EDI:" + sanValue;
        }
        if (0 == altNameType) {
            return "other:" + sanValue;
        }
        if (8 == altNameType) {
            return "regID:" + sanValue;
        }
        if (1 == altNameType) {
            return "rfc822:" + sanValue;
        }
        if (6 == altNameType) {
            return "URI:" + sanValue;
        }
        if (3 == altNameType) {
            return "X400:" + sanValue;
        }
        if (4 == altNameType) {
            return "DirName:" + sanValue;
        }
        LOG.warn("unexpected name / tag '{}' in SANs for san {}", (Object)altNameType, (Object)sanValue);
        return "Unknown:" + sanValue;
    }

    public static int getAlignedKeyLength(PublicKey pk) {
        int keyLength = CertificateUtil.getKeyLength((PublicKey)pk);
        if (lenSet.contains(keyLength + 1)) {
            return keyLength + 1;
        }
        if (lenSet.contains(keyLength + 2)) {
            return keyLength + 2;
        }
        return keyLength;
    }

    public static int getKeyLength(PublicKey pk) {
        int len = -1;
        if (pk instanceof RSAPublicKey) {
            RSAPublicKey rsapub = (RSAPublicKey)pk;
            len = rsapub.getModulus().bitLength();
        } else if (pk instanceof JCEECPublicKey) {
            JCEECPublicKey ecpriv = (JCEECPublicKey)pk;
            org.bouncycastle.jce.spec.ECParameterSpec spec = ecpriv.getParameters();
            len = spec != null ? spec.getN().bitLength() : 0;
        } else if (pk instanceof java.security.interfaces.ECPublicKey) {
            java.security.interfaces.ECPublicKey ecpriv = (java.security.interfaces.ECPublicKey)pk;
            ECParameterSpec spec = ecpriv.getParams();
            len = spec != null ? spec.getOrder().bitLength() : 0;
        } else if (pk instanceof DSAPublicKey) {
            DSAPublicKey dsapub = (DSAPublicKey)pk;
            len = dsapub.getParams() != null ? dsapub.getParams().getP().bitLength() : dsapub.getY().bitLength();
        }
        return len;
    }

    public static final String deriveCurveName(org.bouncycastle.jce.spec.ECParameterSpec ecParameterSpec) throws GeneralSecurityException {
        Enumeration names = ECNamedCurveTable.getNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            X9ECParameters params = ECNamedCurveTable.getByName((String)name);
            if (!params.getN().equals(ecParameterSpec.getN()) || !params.getH().equals(ecParameterSpec.getH()) || !params.getCurve().equals(ecParameterSpec.getCurve()) || !params.getG().equals(ecParameterSpec.getG())) continue;
            return name;
        }
        throw new GeneralSecurityException("Could not find name for curve");
    }

    public static final String deriveCurveName(PublicKey publicKey) throws GeneralSecurityException {
        if (publicKey instanceof java.security.interfaces.ECPublicKey) {
            java.security.interfaces.ECPublicKey pk = (java.security.interfaces.ECPublicKey)publicKey;
            ECParameterSpec params = pk.getParams();
            return CertificateUtil.deriveCurveName((org.bouncycastle.jce.spec.ECParameterSpec)EC5Util.convertSpec((ECParameterSpec)params));
        }
        if (publicKey instanceof ECPublicKey) {
            ECPublicKey pk = (ECPublicKey)publicKey;
            return CertificateUtil.deriveCurveName((org.bouncycastle.jce.spec.ECParameterSpec)pk.getParameters());
        }
        throw new GeneralSecurityException("Can only be used with instances of ECPublicKey (either jce or bc implementation)");
    }

    public static final String deriveCurveName(PrivateKey privateKey) throws GeneralSecurityException {
        if (privateKey instanceof java.security.interfaces.ECPrivateKey) {
            java.security.interfaces.ECPrivateKey pk = (java.security.interfaces.ECPrivateKey)privateKey;
            ECParameterSpec params = pk.getParams();
            return CertificateUtil.deriveCurveName((org.bouncycastle.jce.spec.ECParameterSpec)EC5Util.convertSpec((ECParameterSpec)params));
        }
        if (privateKey instanceof ECPrivateKey) {
            ECPrivateKey pk = (ECPrivateKey)privateKey;
            return CertificateUtil.deriveCurveName((org.bouncycastle.jce.spec.ECParameterSpec)pk.getParameters());
        }
        throw new GeneralSecurityException("Can only be used with instances of ECPrivateKey (either jce or bc implementation)");
    }

    public void insertNameAttributes(Certificate cert, String attributeName, X500Name x500NameSubject) {
        try {
            List<Rdn> rdnList = new LdapName(x500NameSubject.toString()).getRdns();
            for (Rdn rdn : rdnList) {
                String rdnExpression = rdn.getType().toLowerCase() + "=" + rdn.getValue().toString().toLowerCase().trim();
                this.setCertMultiValueAttribute(cert, attributeName, rdnExpression);
            }
        }
        catch (InvalidNameException e) {
            LOG.info("problem parsing RDN for {}", (Object)x500NameSubject.toString());
        }
        for (RDN rdn : x500NameSubject.getRDNs()) {
            for (AttributeTypeAndValue atv : rdn.getTypesAndValues()) {
                String value = atv.getValue().toString().toLowerCase().trim();
                this.setCertMultiValueAttribute(cert, attributeName, value);
                String oid = atv.getType().getId().toLowerCase();
                this.setCertMultiValueAttribute(cert, attributeName, oid + "=" + value);
                if (oid.equals(atv.getType().toString().toLowerCase())) continue;
                this.setCertMultiValueAttribute(cert, attributeName, atv.getType().toString().toLowerCase() + "=" + value);
            }
        }
    }

    public String getCertAttribute(Certificate certDao, String name, String defaultValue) {
        String value = this.getCertAttribute(certDao, name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public String getCertAttribute(Certificate certDao, String name) {
        for (CertificateAttribute certAttr : certDao.getCertificateAttributes()) {
            if (!certAttr.getName().equals(name)) continue;
            return certAttr.getValue();
        }
        return null;
    }

    public void setCertAttribute(Certificate certDao, String name, long value) {
        this.setCertAttribute(certDao, name, Long.toString(value));
    }

    public void setCertMultiValueAttribute(Certificate cert, String name, String value) {
        this.setCertAttribute(cert, name, value, true);
    }

    public void setCertAttribute(Certificate cert, String name, String value) {
        this.setCertAttribute(cert, name, value, true);
    }

    public void setCertAttribute(Certificate cert, String name, String value, boolean multiValue) {
        if (name == null) {
            LOG.warn("no use to insert attribute with name 'null'", (Throwable)new Exception());
            return;
        }
        if (value == null) {
            value = "";
        }
        value = CryptoUtil.limitLength((String)value, (int)250);
        Set certAttrList = cert.getCertificateAttributes();
        for (CertificateAttribute certAttr : certAttrList) {
            if (!name.equals(certAttr.getName())) continue;
            if (value.equalsIgnoreCase(certAttr.getValue())) {
                return;
            }
            if (multiValue) continue;
            certAttr.setValue(value);
            return;
        }
        CertificateAttribute cAtt = new CertificateAttribute();
        cAtt.setCertificate(cert);
        cAtt.setName(name);
        cAtt.setValue(value);
        cert.getCertificateAttributes().add(cAtt);
        this.certificateAttributeRepository.save((Object)cAtt);
    }

    public List<Certificate> getCertificateChain(Certificate startCertDao) throws GeneralSecurityException {
        int MAX_CHAIN_LENGTH = 10;
        ArrayList<Certificate> certChain = new ArrayList<Certificate>();
        Certificate certDao = startCertDao;
        LOG.debug("added end entity cert id {} to the chain", (Object)certDao.getId());
        certChain.add(certDao);
        for (int i = 0; i <= MAX_CHAIN_LENGTH; ++i) {
            Certificate issuingCertDao;
            if (i == MAX_CHAIN_LENGTH) {
                String msg = "maximum chain length ecxeeded for  cert id : " + startCertDao.getId();
                LOG.info(msg);
                throw new GeneralSecurityException(msg);
            }
            try {
                issuingCertDao = this.findIssuingCertificate(certDao);
                if (issuingCertDao == null) {
                    String msg = "no issuing certificate available / retrievable for cert id : " + certDao.getId();
                    LOG.info(msg);
                    throw new GeneralSecurityException(msg);
                }
                LOG.debug("added issuing cert id {} to the chain", (Object)issuingCertDao.getId());
                certChain.add(issuingCertDao);
            }
            catch (GeneralSecurityException e) {
                String msg = "Error retrieving issuing certificate for cert id : " + certDao.getId();
                LOG.info(msg);
                throw new GeneralSecurityException(msg);
            }
            if (issuingCertDao.getIssuingCertificate() == null) {
                String msg = "no issuing certificate available / retrievable for cert id : " + issuingCertDao.getId();
                LOG.info(msg);
                break;
            }
            if (issuingCertDao.getId() == issuingCertDao.getIssuingCertificate().getId()) {
                LOG.debug("certificate chain complete, cert id '{}' is selfsigned", (Object)issuingCertDao.getId());
                break;
            }
            certDao = issuingCertDao;
        }
        return certChain;
    }

    public X509Certificate[] getX509CertificateChain(Certificate startCert) throws GeneralSecurityException {
        List certList = this.getCertificateChain(startCert);
        X509Certificate[] chainArr = new X509Certificate[certList.size()];
        for (int i = 0; i < certList.size(); ++i) {
            X509Certificate x509Cert;
            chainArr[i] = x509Cert = CryptoService.convertPemToCertificate((String)((Certificate)certList.get(i)).getContent());
        }
        return chainArr;
    }

    public List<X509Certificate> getX509CertificateChainAsList(Certificate startCert) throws GeneralSecurityException {
        List certList = this.getCertificateChain(startCert);
        ArrayList<X509Certificate> x509chainList = new ArrayList<X509Certificate>();
        for (int i = 0; i < certList.size(); ++i) {
            X509Certificate x509Cert = CryptoService.convertPemToCertificate((String)((Certificate)certList.get(i)).getContent());
            x509chainList.add(x509Cert);
        }
        return x509chainList;
    }

    public static String getPaddedSerial(String serial) {
        if (serial == null) {
            return "000000000000000000000000000000000000000000000000000000000000000";
        }
        int len = serial.length();
        if (len >= "000000000000000000000000000000000000000000000000000000000000000".length()) {
            return serial;
        }
        return "000000000000000000000000000000000000000000000000000000000000000".substring(serial.length()) + serial;
    }

    public static String getPaddedTimestamp(String timestamp) {
        if (timestamp == null) {
            return "000000000000000000";
        }
        int len = timestamp.length();
        if (len >= "000000000000000000".length()) {
            return timestamp;
        }
        return "000000000000000000".substring(timestamp.length()) + timestamp;
    }

    public static byte[] generateSHA1Fingerprint(byte[] ba) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            return md.digest(ba);
        }
        catch (NoSuchAlgorithmException nsae) {
            LOG.error("SHA1 algorithm not supported", (Throwable)nsae);
            return null;
        }
    }

    public static String usageAsString(boolean[] usage) {
        if (usage == null || usage.length == 0) {
            return "unspecified usage";
        }
        String desc = "valid for ";
        if (usage.length > 0 && usage[0]) {
            desc = desc + "digitalSignature ";
        }
        if (usage.length > 1 && usage[1]) {
            desc = desc + "nonRepudiation ";
        }
        if (usage.length > 2 && usage[2]) {
            desc = desc + "keyEncipherment ";
        }
        if (usage.length > 3 && usage[3]) {
            desc = desc + "dataEncipherment ";
        }
        if (usage.length > 4 && usage[4]) {
            desc = desc + "keyAgreement ";
        }
        if (usage.length > 5 && usage[5]) {
            desc = desc + "keyCertSign ";
        }
        if (usage.length > 6 && usage[6]) {
            desc = desc + "cRLSign ";
        }
        if (usage.length > 7 && usage[7]) {
            desc = desc + "encipherOnly ";
        }
        if (usage.length > 8 && usage[8]) {
            desc = desc + "decipherOnly ";
        }
        return desc;
    }

    public void usageAsCertAttributes(boolean[] usage, Certificate cert) {
        if (usage == null || usage.length == 0) {
            this.setCertAttribute(cert, "USAGE", "unspecified");
            return;
        }
        if (usage.length > 0 && usage[0]) {
            this.setCertAttribute(cert, "USAGE", "digitalSignature");
        }
        if (usage.length > 1 && usage[1]) {
            this.setCertAttribute(cert, "USAGE", "nonRepudiation");
        }
        if (usage.length > 2 && usage[2]) {
            this.setCertAttribute(cert, "USAGE", "keyEncipherment");
        }
        if (usage.length > 3 && usage[3]) {
            this.setCertAttribute(cert, "USAGE", "dataEncipherment");
        }
        if (usage.length > 4 && usage[4]) {
            this.setCertAttribute(cert, "USAGE", "keyAgreement");
        }
        if (usage.length > 5 && usage[5]) {
            this.setCertAttribute(cert, "USAGE", "keyCertSign");
        }
        if (usage.length > 6 && usage[6]) {
            this.setCertAttribute(cert, "USAGE", "cRLSign");
        }
        if (usage.length > 7 && usage[7]) {
            this.setCertAttribute(cert, "USAGE", "encipherOnly");
        }
        if (usage.length > 8 && usage[8]) {
            this.setCertAttribute(cert, "USAGE", "decipherOnly");
        }
    }

    public Certificate findIssuingCertificate(Certificate cert) throws GeneralSecurityException {
        if (cert.isSelfsigned().booleanValue()) {
            return cert;
        }
        Certificate issuingCert = cert.getIssuingCertificate();
        if (issuingCert == null) {
            issuingCert = this.findIssuingCertificate(this.convertPemToCertificateHolder(cert.getContent()));
            if (issuingCert != null) {
                if (issuingCert.equals((Object)cert)) {
                    LOG.warn("found untagged self-signed certificate id '{}', '{}'", (Object)cert.getId(), (Object)cert.getDescription());
                    return cert;
                }
                cert.setIssuingCertificate(issuingCert);
                this.certificateRepository.save((Object)cert);
            } else {
                LOG.debug("not able to find and store issuing certificate for '" + cert.getDescription() + "'");
            }
        }
        return issuingCert;
    }

    public X509CertificateHolder convertPemToCertificateHolder(String pem) throws GeneralSecurityException {
        X509Certificate x509Cert = this.convertPemToCertificate(pem);
        try {
            return new X509CertificateHolder(x509Cert.getEncoded());
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
    }

    public X509Certificate convertPemToCertificate(String pem) throws GeneralSecurityException {
        X509Certificate cert;
        block13: {
            cert = null;
            ByteArrayInputStream pemStream = null;
            try {
                pemStream = new ByteArrayInputStream(pem.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                LOG.error("UnsupportedEncodingException, convertPemToPublicKey", (Throwable)ex);
                throw new GeneralSecurityException("Parsing of PublicKey failed due to encoding problem! Not PEM encoded?");
            }
            InputStreamReader pemReader = new InputStreamReader(pemStream);
            PEMParser pemParser = new PEMParser((Reader)pemReader);
            try {
                Object parsedObj = pemParser.readObject();
                if (parsedObj == null) {
                    throw new GeneralSecurityException("Parsing of certificate failed! Not PEM encoded?");
                }
                if (parsedObj instanceof X509CertificateHolder) {
                    cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate((X509CertificateHolder)parsedObj);
                    break block13;
                }
                throw new GeneralSecurityException("Unexpected parsing result: " + parsedObj.getClass().getName());
            }
            catch (IOException ex) {
                LOG.error("IOException, convertPemToCertificate", (Throwable)ex);
                throw new GeneralSecurityException("Parsing of certificate failed! Not PEM encoded?");
            }
            finally {
                try {
                    pemParser.close();
                }
                catch (IOException e) {
                    LOG.debug("IOException on close()", (Throwable)e);
                }
            }
        }
        return cert;
    }

    public PrivateKey convertPemToPrivateKey(String pem) throws GeneralSecurityException {
        PrivateKey privKey;
        block13: {
            privKey = null;
            ByteArrayInputStream pemStream = null;
            try {
                pemStream = new ByteArrayInputStream(pem.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                LOG.error("UnsupportedEncodingException, PrivateKey", (Throwable)ex);
                throw new GeneralSecurityException("Parsing of PEM file failed due to encoding problem! Not PEM encoded?");
            }
            InputStreamReader pemReader = new InputStreamReader(pemStream);
            PEMParser pemParser = new PEMParser((Reader)pemReader);
            try {
                Object parsedObj = pemParser.readObject();
                if (parsedObj == null) {
                    throw new GeneralSecurityException("Parsing of certificate failed! Not PEM encoded?");
                }
                if (parsedObj instanceof PrivateKeyInfo) {
                    privKey = new JcaPEMKeyConverter().setProvider("BC").getPrivateKey((PrivateKeyInfo)parsedObj);
                    break block13;
                }
                throw new GeneralSecurityException("Unexpected parsing result: " + parsedObj.getClass().getName());
            }
            catch (IOException ex) {
                LOG.error("IOException, convertPemToCertificate", (Throwable)ex);
                throw new GeneralSecurityException("Parsing of certificate failed! Not PEM encoded?");
            }
            finally {
                try {
                    pemParser.close();
                }
                catch (IOException e) {
                    LOG.debug("IOException on close()", (Throwable)e);
                }
            }
        }
        return privKey;
    }

    public Certificate findIssuingCertificate(X509CertificateHolder x509CertHolder) throws GeneralSecurityException {
        Object aki;
        Objects.requireNonNull(x509CertHolder, "x509CertHolder can't be null");
        List issuingCertList = new ArrayList();
        if (x509CertHolder != null && x509CertHolder.getExtensions() != null && (aki = AuthorityKeyIdentifier.fromExtensions((Extensions)x509CertHolder.getExtensions())) != null) {
            issuingCertList = this.findCertsByAKI(x509CertHolder, (AuthorityKeyIdentifier)aki);
        }
        if (issuingCertList.isEmpty()) {
            LOG.debug("AKI from crt extension failed, trying to find issuer name");
            issuingCertList = this.certificateRepository.findCACertByIssuer(x509CertHolder.getIssuer().toString());
            if (issuingCertList.size() > 1) {
                LOG.debug("more than one issuer found for certificate id '{}' by matching issuer name '{}'");
            }
        }
        if (issuingCertList.isEmpty()) {
            throw new GeneralSecurityException("no issuing certificate for '" + x509CertHolder.getSubject().toString() + "' in certificate store.");
        }
        if (issuingCertList.size() > 1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("more than one issuer found ");
                for (Certificate issuer : issuingCertList) {
                    LOG.debug("possible issuer id '{}' subject '{}'", (Object)issuer.getId(), (Object)issuer.getSubject());
                }
            }
            throw new GeneralSecurityException("more than one (" + issuingCertList.size() + ") issuing certificate for '" + x509CertHolder.getSubject().toString() + "' in certificate store.");
        }
        Certificate issuerDao = (Certificate)issuingCertList.iterator().next();
        if (LOG.isDebugEnabled()) {
            LOG.debug("issuerDao has attributes: ");
        }
        return issuerDao;
    }

    private Certificate findRootCertificate(Certificate cert) throws GeneralSecurityException {
        for (int i = 0; i < 10; ++i) {
            if (cert.isSelfsigned().booleanValue()) {
                return cert;
            }
            Certificate issuingCert = cert.getIssuingCertificate();
            if (issuingCert == null) {
                issuingCert = this.findIssuingCertificate(cert);
                if (issuingCert == null) break;
                cert.setIssuingCertificate(issuingCert);
                this.certificateRepository.save((Object)cert);
                LOG.debug("determined issuing certificate {} for {}", (Object)issuingCert.getId(), (Object)cert.getId());
            }
            cert = issuingCert;
        }
        LOG.info("unable to determined issuing certificate for {}", (Object)cert.getId());
        return null;
    }

    private List<Certificate> findCertsByAKI(X509CertificateHolder x509CertHolder, AuthorityKeyIdentifier aki) {
        String aKIBase64 = Base64.encodeBase64String((byte[])aki.getKeyIdentifier());
        LOG.debug("looking for issuer of certificate '" + x509CertHolder.getSubject().toString() + "', issuer selected by its SKI '" + aKIBase64 + "'");
        List issuingCertList = this.certificateRepository.findByAttributeValue("SKI", aKIBase64);
        if (issuingCertList.isEmpty()) {
            LOG.debug("no certificate found for AKI {}", (Object)aKIBase64);
        }
        return issuingCertList;
    }

    public List<Certificate> findCertsBySubjectRFC2253(String subject) {
        LOG.debug("looking for certificate by subject (by RFC 2253) '" + subject + "'");
        List issuingCertList = this.certificateRepository.findByAttributeValue("SUBJECT_RFC_2253", subject);
        if (issuingCertList.isEmpty()) {
            LOG.debug("no certificate found for subject '{}'", (Object)subject);
        }
        return issuingCertList;
    }

    public Set<GeneralName> getSANList(X509CertificateHolder x509CertHolder) {
        HashSet<GeneralName> generalNameSet = new HashSet<GeneralName>();
        Extensions exts = x509CertHolder.getExtensions();
        for (ASN1ObjectIdentifier objId : exts.getExtensionOIDs()) {
            if (!Extension.subjectAlternativeName.equals((ASN1Primitive)objId)) continue;
            ASN1OctetString octString = exts.getExtension(objId).getExtnValue();
            GeneralNames names = GeneralNames.getInstance((Object)octString);
            LOG.debug("Attribute value SAN" + names);
            LOG.debug("SAN values #" + names.getNames().length);
            for (GeneralName gnSAN : names.getNames()) {
                LOG.debug("GN " + gnSAN.toString());
                generalNameSet.add(gnSAN);
            }
        }
        return generalNameSet;
    }

    public Set<GeneralName> getSANList(Pkcs10RequestHolder p10ReqHolder) {
        HashSet<GeneralName> generalNameSet = new HashSet<GeneralName>();
        for (Attribute attr : p10ReqHolder.getReqAttributes()) {
            if (!PKCSObjectIdentifiers.pkcs_9_at_extensionRequest.equals((ASN1Primitive)attr.getAttrType())) continue;
            ASN1Set valueSet = attr.getAttrValues();
            LOG.debug("ExtensionRequest / AttrValues has {} elements", (Object)valueSet.size());
            for (ASN1Encodable asn1Enc : valueSet) {
                DERSequence derSeq = (DERSequence)asn1Enc;
                LOG.debug("ExtensionRequest / DERSequence has {} elements", (Object)derSeq.size());
                LOG.debug("ExtensionRequest / DERSequence[0] is a  {}", (Object)derSeq.getObjectAt(0).getClass().getName());
                DERSequence derSeq2 = (DERSequence)derSeq.getObjectAt(0);
                LOG.debug("ExtensionRequest / DERSequence2 has {} elements", (Object)derSeq2.size());
                LOG.debug("ExtensionRequest / DERSequence2[0] is a  {}", (Object)derSeq2.getObjectAt(0).getClass().getName());
                ASN1ObjectIdentifier objId = (ASN1ObjectIdentifier)derSeq2.getObjectAt(0);
                if (Extension.subjectAlternativeName.equals((ASN1Primitive)objId)) {
                    DEROctetString derStr = (DEROctetString)derSeq2.getObjectAt(1);
                    GeneralNames names = GeneralNames.getInstance((Object)derStr.getOctets());
                    LOG.debug("Attribute value SAN" + names);
                    LOG.debug("SAN values #" + names.getNames().length);
                    for (GeneralName gnSAN : names.getNames()) {
                        LOG.debug("GN " + gnSAN.toString());
                        generalNameSet.add(gnSAN);
                    }
                    continue;
                }
                LOG.info("Unexpected Extensions Attribute value " + objId.getId());
            }
        }
        return generalNameSet;
    }

    public void storePrivateKey(CSR csr, KeyPair keyPair) throws IOException {
        StringWriter sw = this.keyToPEM(keyPair);
        ProtectedContent pt = this.protUtil.createProtectedContent(sw.toString(), ProtectedContentType.KEY, ContentRelationType.CSR, csr.getId().longValue());
        this.protContentRepository.save((Object)pt);
    }

    public void storePrivateKey(Certificate cert, KeyPair keyPair) throws IOException {
        StringWriter sw = this.keyToPEM(keyPair);
        ProtectedContent pt = this.protUtil.createProtectedContent(sw.toString(), ProtectedContentType.KEY, ContentRelationType.CERTIFICATE, cert.getId().longValue());
        this.protContentRepository.save((Object)pt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringWriter keyToPEM(KeyPair keyPair) throws IOException {
        StringWriter sw = new StringWriter();
        PemObject pemObject = new PemObject("PRIVATE KEY", keyPair.getPrivate().getEncoded());
        try (PemWriter pemWriter = new PemWriter((Writer)sw);){
            pemWriter.writeObject((PemObjectGenerator)pemObject);
        }
        LOG.debug("new private key as PEM : " + sw.toString());
        return sw;
    }

    public PrivateKey getPrivateKey(CSR csr) {
        PrivateKey priKey = null;
        try {
            List pcList = this.protContentRepository.findByCertificateId(csr.getId());
            if (pcList.isEmpty()) {
                LOG.error("retrieval of private key for csr '{}' returns not key!", (Object)csr.getId());
            } else {
                if (pcList.size() > 1) {
                    LOG.warn("retrieval of private key for certificate '{}' returns more than one key ({}) !", (Object)csr.getId(), (Object)pcList.size());
                }
                String content = this.protUtil.unprotectString(((ProtectedContent)pcList.get(0)).getContentBase64());
                priKey = this.cryptoUtil.convertPemToPrivateKey(content);
                LOG.debug("getPrivateKey() returns " + priKey.toString());
            }
        }
        catch (GeneralSecurityException e) {
            LOG.warn("getPrivateKey", (Throwable)e);
        }
        return priKey;
    }

    public PrivateKey getPrivateKey(Certificate cert) {
        PrivateKey priKey = null;
        try {
            List pcList = this.protContentRepository.findByCertificateId(cert.getId());
            if (pcList.isEmpty()) {
                LOG.error("retrieval of private key for certificate '{}' returns not key!", (Object)cert.getId());
            } else {
                if (pcList.size() > 1) {
                    LOG.warn("retrieval of private key for certificate '{}' returns more than one key ({}) !", (Object)cert.getId(), (Object)pcList.size());
                }
                String content = this.protUtil.unprotectString(((ProtectedContent)pcList.get(0)).getContentBase64());
                priKey = this.cryptoUtil.convertPemToPrivateKey(content);
                LOG.debug("getPrivateKey() returns " + priKey.toString());
            }
        }
        catch (GeneralSecurityException e) {
            LOG.warn("getPrivateKey", (Throwable)e);
        }
        return priKey;
    }

    public PrivateKey getPrivateKey(ProtectedContentType type, ContentRelationType relationType, Long id) {
        PrivateKey priKey = null;
        try {
            List pcList = this.protContentRepository.findByTypeRelationId(type, relationType, id);
            if (pcList.isEmpty()) {
                LOG.error("retrieval of private key for element with id '{}' returns not key!", (Object)id);
            } else {
                if (pcList.size() > 1) {
                    LOG.warn("retrieval of private key for element with id '{}' returns more than one key ({}) !", (Object)id, (Object)pcList.size());
                }
                String content = this.protUtil.unprotectString(((ProtectedContent)pcList.get(0)).getContentBase64());
                priKey = this.cryptoUtil.convertPemToPrivateKey(content);
                LOG.debug("getPrivateKey() returns " + priKey.toString());
            }
        }
        catch (GeneralSecurityException e) {
            LOG.warn("getPrivateKey", (Throwable)e);
        }
        return priKey;
    }

    public List<String> getCrlDistributionPoints(X509Certificate cert) throws CertificateParsingException, IOException {
        ArrayList<String> crlUrls = new ArrayList<String>();
        byte[] crldpExt = cert.getExtensionValue(X509Extensions.CRLDistributionPoints.getId());
        if (crldpExt != null && crldpExt.length > 0) {
            ASN1InputStream oAsnInStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(crldpExt));
            ASN1Primitive derObjCrlDP = oAsnInStream.readObject();
            DEROctetString dosCrlDP = (DEROctetString)derObjCrlDP;
            byte[] crldpExtOctets = dosCrlDP.getOctets();
            ASN1InputStream oAsnInStream2 = new ASN1InputStream((InputStream)new ByteArrayInputStream(crldpExtOctets));
            ASN1Primitive derObj2 = oAsnInStream2.readObject();
            CRLDistPoint distPoint = CRLDistPoint.getInstance((Object)derObj2);
            for (DistributionPoint dp : distPoint.getDistributionPoints()) {
                System.out.println(dp);
                DistributionPointName dpn = dp.getDistributionPoint();
                if (dpn == null || dpn.getType() != 0) continue;
                GeneralName[] genNames = GeneralNames.getInstance((Object)dpn.getName()).getNames();
                for (int j = 0; j < genNames.length; ++j) {
                    if (genNames[j].getTagNo() != 6) continue;
                    String url = DERIA5String.getInstance((Object)genNames[j].getName()).getString();
                    crlUrls.add(url);
                }
            }
            oAsnInStream.close();
            oAsnInStream2.close();
        }
        return crlUrls;
    }

    public void setRevocationStatus(Certificate cert, String revocationReason, Date revocationDate) {
        this.setRevocationStatus(cert, revocationReason, DateUtil.asInstant((Date)revocationDate));
    }

    public void setRevocationStatus(Certificate cert, String revocationReason, Instant revocationDate) {
        cert.setActive(Boolean.valueOf(false));
        cert.setRevoked(Boolean.valueOf(true));
        if (revocationReason == null || revocationReason.trim().isEmpty()) {
            cert.setRevocationReason("unspecified");
        } else {
            cert.setRevocationReason(revocationReason);
        }
        cert.setRevokedSince(revocationDate);
    }

    public List<Certificate> findReplaceCandidates(String[] sanArr) {
        ArrayList<String> sans = new ArrayList<String>();
        for (String san : sanArr) {
            LOG.debug("SAN present: {} ", (Object)san);
            sans.add(san);
        }
        return this.findReplaceCandidates(sans);
    }

    public List<Certificate> findReplaceCandidates(List<String> sans) {
        LOG.debug("sans list contains {} elements", (Object)sans.size());
        ArrayList<Certificate> candidateList = new ArrayList<Certificate>();
        if (sans.size() == 0) {
            return candidateList;
        }
        List matchingCertList = this.certificateRepository.findActiveCertificatesBySANs(Instant.now(), sans);
        LOG.debug("objArrList contains {} elements", (Object)matchingCertList.size());
        for (Certificate cert : matchingCertList) {
            LOG.debug("replacement candidate {}: {} ", (Object)cert.getId(), (Object)cert.getSubject());
            boolean matches = true;
            for (CertificateAttribute certAttr : cert.getCertificateAttributes()) {
                String san;
                if (!certAttr.getName().equals("TYPED_SAN") && !certAttr.getName().equals("TYPED_VSAN") || sans.contains(san = certAttr.getValue())) continue;
                matches = false;
                LOG.debug("candidate san {} NOT in provided san list", (Object)san, (Object)cert.getSubject());
                break;
            }
            if (!matches) continue;
            candidateList.add(cert);
            LOG.debug("replacement candidate {}: contains all SANs", (Object)cert.getId());
        }
        return candidateList;
    }

    public static String getDownloadFilename(Certificate cert) {
        String downloadFilename = cert.getSubject().replaceAll("[^a-zA-Z0-9\\.\\-]", "_");
        if (downloadFilename.trim().isEmpty()) {
            downloadFilename = "cert" + cert.getSerial();
        }
        return downloadFilename;
    }

    static {
        lenSet.add(256);
        lenSet.add(512);
        lenSet.add(1024);
        lenSet.add(2048);
        lenSet.add(3072);
        lenSet.add(4096);
        lenSet.add(6144);
        lenSet.add(8192);
        LOG = LoggerFactory.getLogger(CertificateUtil.class);
    }
}

