/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.repository;

import de.trustable.ca3s.core.domain.CSR_;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.CertificateAttribute;
import de.trustable.ca3s.core.domain.CertificateAttribute_;
import de.trustable.ca3s.core.domain.CertificateComment_;
import de.trustable.ca3s.core.domain.Certificate_;
import de.trustable.ca3s.core.repository.SelectionData;
import de.trustable.ca3s.core.repository.SpecificationsHelper;
import de.trustable.ca3s.core.service.dto.CertificateView;
import de.trustable.ca3s.core.service.dto.Selector;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import java.io.Serializable;
import java.math.BigInteger;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.ldap.Rdn;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.SetJoin;
import javax.persistence.criteria.Subquery;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;

/*
 * Exception performing whole class analysis ignored.
 */
public final class CertificateSpecifications {
    static Logger logger = LoggerFactory.getLogger(CertificateSpecifications.class);
    static final String SORT = "sort";
    static final String ORDER = "order";
    static final String DEFAULT_FILTER = "id,issuer,subject";

    private CertificateSpecifications() {
    }

    public static Specification<Certificate> subjectOrIssuer(String searchTerm) {
        return (Specification & Serializable)(root, query, cb) -> {
            String containsLikePattern = SpecificationsHelper.getContainsLikePattern((String)searchTerm);
            return cb.or((Expression)cb.like(cb.lower((Expression)root.get(Certificate_.subject)), containsLikePattern), (Expression)cb.like(cb.lower((Expression)root.get(Certificate_.issuer)), containsLikePattern));
        };
    }

    public static String getStringValue(String[] inArr) {
        return CertificateSpecifications.getStringValue((String[])inArr, (String)"");
    }

    public static String getStringValue(String[] inArr, String defaultValue) {
        if (inArr == null || inArr.length == 0) {
            return defaultValue;
        }
        return inArr[0];
    }

    public static int getIntValue(String[] inArr, int defaultValue) {
        if (inArr == null || inArr.length == 0) {
            return defaultValue;
        }
        return Integer.parseInt(inArr[0]);
    }

    public static List<Certificate> findCertificatesBySubject(EntityManager entityManager, CriteriaBuilder cb, List<Rdn> rdnList) {
        CriteriaQuery query = cb.createQuery(Certificate.class);
        Root root = query.from(Certificate.class);
        Predicate pred = cb.conjunction();
        for (Rdn rdn : rdnList) {
            String rdnExpression = rdn.getType() + "=" + rdn.getValue();
            logger.debug("single rdn representation '{}' ", (Object)rdnExpression);
            Subquery certAttSubquery = query.subquery(CertificateAttribute.class);
            Root certAttRoot = certAttSubquery.from(CertificateAttribute.class);
            Predicate predPart = cb.exists(certAttSubquery.select((Expression)certAttRoot).where((Expression)cb.and(new Predicate[]{cb.equal((Expression)certAttRoot.get("certificate"), (Expression)root.get("id")), cb.equal((Expression)certAttRoot.get("name"), (Object)"SUBJECT"), SpecificationsHelper.buildPredicateString((String)Selector.EQUAL.toString(), (CriteriaBuilder)cb, (Expression)certAttRoot.get(CertificateAttribute_.value), (String)rdnExpression)})));
            pred = cb.and((Expression)pred, (Expression)predPart);
        }
        query.where((Expression)pred);
        TypedQuery typedQuery = entityManager.createQuery(query);
        try {
            logger.debug("assembled query: " + ((Query)typedQuery.unwrap(Query.class)).getQueryString());
        }
        catch (Exception e) {
            logger.debug("failed in retrieve sql query", (Throwable)e);
        }
        long queryStartTime = System.currentTimeMillis();
        List listResponse = typedQuery.getResultList();
        logger.debug("typedQuery.getResultList() return {} items took {} msecs", (Object)listResponse.size(), (Object)(System.currentTimeMillis() - queryStartTime));
        return listResponse;
    }

    public static Page<CertificateView> handleQueryParamsCertificateView(EntityManager entityManager, CriteriaBuilder cb, Map<String, String[]> parameterMap, List<String> certificateSelectionAttributes) {
        Object selDataList;
        String[] paramArr;
        long startTime = System.currentTimeMillis();
        CriteriaQuery query = cb.createQuery(Object[].class);
        Root root = query.from(Certificate.class);
        String sortCol = CertificateSpecifications.getStringValue((String[])parameterMap.get("sort"), (String)"id").trim();
        Selection orderSelection = null;
        String orderDirection = CertificateSpecifications.getStringValue((String[])parameterMap.get("order"), (String)"asc");
        int pageOffset = CertificateSpecifications.getIntValue((String[])parameterMap.get("offset"), (int)0);
        int pagesize = CertificateSpecifications.getIntValue((String[])parameterMap.get("limit"), (int)20);
        logger.debug("buildPredicate: offset '{}', limit '{}' ", (Object)pageOffset, (Object)pagesize);
        ArrayList selectionList = new ArrayList();
        ArrayList<String> colList = new ArrayList<String>();
        Map selectionMap = CertificateSpecifications.getSelectionMap(parameterMap);
        String[] columnArr = "id,issuer,subject".split(",");
        boolean idOnly = true;
        if (parameterMap.containsKey("filter") && (paramArr = parameterMap.get("filter")).length > 0) {
            idOnly = false;
            columnArr = paramArr[0].split(",");
        }
        ArrayList<Predicate> predList = new ArrayList<Predicate>();
        for (String col : columnArr) {
            logger.debug("handleQueryParamsCertificateView handles column '{}' ", (Object)col);
            colList.add(col);
            if (selectionMap.containsKey(col)) {
                selDataList = (List)selectionMap.get(col);
                Iterator iterator = selDataList.iterator();
                while (iterator.hasNext()) {
                    SelectionData selDataItem = (SelectionData)iterator.next();
                    logger.debug("buildPredicate for '{}', selector '{}', value '{}' ", new Object[]{col, selDataItem.selector, selDataItem.value});
                    predList.add(CertificateSpecifications.buildPredicate((Root)root, (CriteriaBuilder)cb, (CriteriaQuery)query, (String)col, (String)selDataItem.selector, (String)selDataItem.value, selectionList, certificateSelectionAttributes));
                }
            } else {
                logger.debug("buildPredicate for '{}' without selector ", (Object)col);
                predList.add(CertificateSpecifications.buildPredicate((Root)root, (CriteriaBuilder)cb, (CriteriaQuery)query, (String)col, null, (String)"", selectionList, certificateSelectionAttributes));
            }
            if (!col.equals(sortCol)) continue;
            orderSelection = (Selection)selectionList.get(selectionList.size() - 1);
        }
        ArrayList selectionListDummy = new ArrayList();
        for (String selection : selectionMap.keySet()) {
            boolean handled = false;
            for (String col : columnArr) {
                if (!selection.equals(col)) continue;
                handled = true;
            }
            if (handled) continue;
            selDataList = (List)selectionMap.get(selection);
            Iterator iterator = selDataList.iterator();
            while (iterator.hasNext()) {
                SelectionData selDataItem = (SelectionData)iterator.next();
                predList.add(CertificateSpecifications.buildPredicate((Root)root, (CriteriaBuilder)cb, (CriteriaQuery)query, (String)selection, (String)selDataItem.selector, (String)selDataItem.value, selectionListDummy, certificateSelectionAttributes));
            }
        }
        Predicate pred = null;
        for (Predicate predPart : predList) {
            if (pred == null) {
                pred = predPart;
                continue;
            }
            pred = cb.and((Expression)pred, (Expression)predPart);
        }
        query.where(pred);
        Sort.Direction sortDir = Sort.Direction.ASC;
        if ("asc".equalsIgnoreCase(orderDirection)) {
            query.orderBy(new Order[]{cb.asc((Expression)orderSelection)});
        } else {
            query.orderBy(new Order[]{cb.desc((Expression)orderSelection)});
            sortDir = Sort.Direction.DESC;
        }
        query.multiselect(selectionList);
        TypedQuery typedQuery = entityManager.createQuery(query);
        typedQuery.setMaxResults(pagesize);
        typedQuery.setFirstResult(pageOffset);
        try {
            logger.debug("assembled query: " + ((Query)typedQuery.unwrap(Query.class)).getQueryString());
        }
        catch (Exception e) {
            logger.debug("failed in retrieve sql query", (Throwable)e);
        }
        long queryStartTime = System.currentTimeMillis();
        List listResponse = typedQuery.getResultList();
        logger.debug("typedQuery.getResultList() took {} msecs", (Object)(System.currentTimeMillis() - queryStartTime));
        ArrayList<CertificateView> certViewList = new ArrayList<CertificateView>();
        for (Object[] objArr : listResponse) {
            if (logger.isDebugEnabled() && objArr.length != colList.size()) {
                logger.debug("objArr len {}, colList len {}", (Object)objArr.length, (Object)colList.size());
            }
            CertificateView cv = CertificateSpecifications.buildCertificateViewFromObjArr(colList, (Object[])objArr);
            certViewList.add(cv);
        }
        PageRequest pageable = PageRequest.of((int)(pageOffset / pagesize), (int)pagesize, (Sort.Direction)sortDir, (String[])new String[]{sortCol});
        Long nTotalElements = 1000L;
        CriteriaQuery queryCount = cb.createQuery(Long.class);
        Root iRoot = queryCount.from(Certificate.class);
        ArrayList<Predicate> predCountList = new ArrayList<Predicate>();
        Predicate predCount = null;
        ArrayList selectionListCount = new ArrayList();
        for (String string : columnArr) {
            colList.add(string);
            if (selectionMap.containsKey(string)) {
                List selDataList2 = (List)selectionMap.get(string);
                for (SelectionData selDataItem : selDataList2) {
                    logger.debug("buildPredicate for '{}', selector '{}', value '{}' ", new Object[]{string, selDataItem.selector, selDataItem.value});
                    predCountList.add(CertificateSpecifications.buildPredicate((Root)iRoot, (CriteriaBuilder)cb, (CriteriaQuery)queryCount, (String)string, (String)selDataItem.selector, (String)selDataItem.value, selectionListCount, certificateSelectionAttributes));
                }
                continue;
            }
            logger.debug("buildPredicate for '{}' without selector ", (Object)string);
            predCountList.add(CertificateSpecifications.buildPredicate((Root)iRoot, (CriteriaBuilder)cb, (CriteriaQuery)queryCount, (String)string, null, (String)"", selectionListCount, certificateSelectionAttributes));
        }
        selectionListDummy.clear();
        for (String selection : selectionMap.keySet()) {
            boolean handled = false;
            for (String col : columnArr) {
                if (!selection.equals(col)) continue;
                handled = true;
            }
            if (handled) continue;
            List list = (List)selectionMap.get(selection);
            for (SelectionData selDataItem : list) {
                predCountList.add(CertificateSpecifications.buildPredicate((Root)iRoot, (CriteriaBuilder)cb, (CriteriaQuery)queryCount, (String)selection, (String)selDataItem.selector, (String)selDataItem.value, selectionListDummy, certificateSelectionAttributes));
            }
        }
        for (Predicate predPart : predCountList) {
            if (predCount == null) {
                predCount = predPart;
                continue;
            }
            predCount = cb.and((Expression)predCount, (Expression)predPart);
        }
        queryCount.select((Selection)cb.count((Expression)iRoot));
        queryCount.where((Expression)predCount);
        try {
            TypedQuery typedCountQuery = entityManager.createQuery(queryCount);
            logger.debug("assembled count query: " + ((Query)typedCountQuery.unwrap(Query.class)).getQueryString());
        }
        catch (Exception e) {
            logger.debug("failed in retrieve sql query", (Throwable)e);
        }
        long countStartTime = System.currentTimeMillis();
        nTotalElements = (Long)entityManager.createQuery(queryCount).getSingleResult();
        logger.debug("count getSingleResult() took {} msecs", (Object)(System.currentTimeMillis() - countStartTime));
        logger.debug("buildPredicate selects {} elements in {} msecs", (Object)nTotalElements, (Object)(System.currentTimeMillis() - startTime));
        return new PageImpl(certViewList, (Pageable)pageable, nTotalElements.longValue());
    }

    private static CertificateView buildCertificateViewFromObjArr(ArrayList<String> colList, Object[] objArr) {
        CertificateView cv = new CertificateView();
        int i = 0;
        for (String attribute : colList) {
            if ("id".equalsIgnoreCase(attribute)) {
                cv.setId((Long)objArr[i]);
            } else if ("tbsDigest".equalsIgnoreCase(attribute)) {
                cv.setTbsDigest((String)objArr[i]);
            } else if ("subject".equalsIgnoreCase(attribute)) {
                cv.setSubject((String)objArr[i]);
            } else if ("sans".equalsIgnoreCase(attribute)) {
                cv.setSans((String)objArr[i]);
            } else if ("issuer".equalsIgnoreCase(attribute)) {
                cv.setIssuer((String)objArr[i]);
            } else if ("type".equalsIgnoreCase(attribute)) {
                cv.setType((String)objArr[i]);
            } else if ("keyLength".equalsIgnoreCase(attribute)) {
                cv.setKeyLength(objArr[i].toString());
            } else if ("description".equalsIgnoreCase(attribute)) {
                cv.setDescription((String)objArr[i]);
            } else if ("serial".equalsIgnoreCase(attribute)) {
                cv.setSerial((String)objArr[i]);
            } else if ("validFrom".equalsIgnoreCase(attribute)) {
                cv.setValidFrom((Instant)objArr[i]);
            } else if ("validTo".equalsIgnoreCase(attribute)) {
                cv.setValidTo((Instant)objArr[i]);
            } else if ("contentAddedAt".equalsIgnoreCase(attribute)) {
                cv.setContentAddedAt((Instant)objArr[i]);
            } else if ("revokedSince".equalsIgnoreCase(attribute)) {
                cv.setRevokedSince((Instant)objArr[i]);
            } else if ("revocationReason".equalsIgnoreCase(attribute)) {
                cv.setRevocationReason((String)objArr[i]);
            } else if ("revoked".equalsIgnoreCase(attribute)) {
                cv.setRevoked((Boolean)objArr[i]);
            } else if ("keyAlgorithm".equalsIgnoreCase(attribute)) {
                cv.setKeyAlgorithm((String)objArr[i]);
            } else if ("signingAlgorithm".equalsIgnoreCase(attribute)) {
                cv.setSigningAlgorithm((String)objArr[i]);
            } else if ("paddingAlgorithm".equalsIgnoreCase(attribute)) {
                cv.setPaddingAlgorithm((String)objArr[i]);
            } else if ("hashAlgorithm".equalsIgnoreCase(attribute)) {
                cv.setHashAlgorithm((String)objArr[i]);
            } else if ("comment".equalsIgnoreCase(attribute)) {
                cv.setComment((String)objArr[i]);
            } else if ("csrComment".equalsIgnoreCase(attribute)) {
                cv.setCsrComment((String)objArr[i]);
            } else if ("ca".equalsIgnoreCase(attribute)) {
                cv.setCa(Boolean.valueOf(Boolean.parseBoolean((String)objArr[i])));
            } else if ("selfSigned".equalsIgnoreCase(attribute)) {
                cv.setSelfsigned(Boolean.valueOf(Boolean.parseBoolean((String)objArr[i])));
            } else if ("trusted".equalsIgnoreCase(attribute)) {
                cv.setTrusted(Boolean.valueOf(Boolean.parseBoolean((String)objArr[i])));
            } else if ("endEntity".equalsIgnoreCase(attribute)) {
                cv.setEndEntity(Boolean.valueOf(Boolean.parseBoolean((String)objArr[i])));
            } else if ("chainlength".equalsIgnoreCase(attribute)) {
                cv.setChainLength(Long.valueOf(Long.parseLong((String)objArr[i])));
            } else if ("crlurl".equalsIgnoreCase(attribute)) {
                cv.setCrlUrl((String)objArr[i]);
            } else {
                logger.warn("unexpected attribute '{}' from query", (Object)attribute);
            }
            ++i;
        }
        return cv;
    }

    static Map<String, List<SelectionData>> getSelectionMap(Map<String, String[]> parameterMap) {
        HashMap<String, List<SelectionData>> selectorMap = new HashMap<String, List<SelectionData>>();
        for (int n = 1; n < 20; ++n) {
            String paramNameAttribute = "attributeName_" + n;
            logger.debug("paramNameAttribute {} ", (Object)paramNameAttribute);
            if (!parameterMap.containsKey(paramNameAttribute)) break;
            String attribute = CertificateSpecifications.getStringValue((String[])parameterMap.get(paramNameAttribute));
            if (attribute.length() == 0) {
                logger.debug("paramNameAttribute {} has no value", (Object)paramNameAttribute);
                continue;
            }
            String paramNameAttributeSelector = "attributeSelector_" + n;
            String attributeSelector = CertificateSpecifications.getStringValue((String[])parameterMap.get(paramNameAttributeSelector));
            if (attributeSelector.length() == 0) {
                logger.debug("paramNameAttributeSelector {} has no value", (Object)paramNameAttributeSelector);
                continue;
            }
            String paramNameAttributeValue = "attributeValue_" + n;
            String attributeValue = CertificateSpecifications.getStringValue((String[])parameterMap.get(paramNameAttributeValue));
            if (attributeValue.length() == 0 && Selector.requiresValue((String)attributeSelector)) {
                logger.debug("paramNameAttributeValue {} has no value", (Object)paramNameAttributeValue);
                continue;
            }
            logger.debug("Attribute {} selecting by {} for value {}", new Object[]{attribute, attributeSelector, attributeValue});
            SelectionData selData = new SelectionData(attributeSelector, attributeValue);
            if (selectorMap.containsKey(attribute)) {
                logger.debug("adding selector to exiting list for '{}'", (Object)attribute);
                ((List)selectorMap.get(attribute)).add(selData);
                continue;
            }
            logger.debug("creating new selector list for '{}'", (Object)attribute);
            ArrayList<SelectionData> selectorList = new ArrayList<SelectionData>();
            selectorList.add(selData);
            selectorMap.put(attribute, selectorList);
        }
        return selectorMap;
    }

    private static Predicate buildPredicate(Root<Certificate> root, CriteriaBuilder cb, CriteriaQuery<?> certQuery, String attribute, String attributeSelector, String attributeValue, List<Selection<?>> selectionList, List<String> certificateSelectionAttributes) {
        Predicate pred = cb.conjunction();
        if ("id".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(Certificate_.id));
            pred = SpecificationsHelper.buildPredicateLong((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(Certificate_.id), (String)attributeValue);
        } else if (!("csrComment".equals(attribute) || "extUsage".equals(attribute) || "processingCa".equals(attribute) || "requestedBy".equals(attribute) || "revokedBy".equals(attribute) || "uploadedBy".equals(attribute))) {
            if ("selfSigned".equals(attribute)) {
                SetJoin attJoin = root.join(Certificate_.certificateAttributes, JoinType.LEFT);
                SpecificationsHelper.addNewColumn(selectionList, (Selection)attJoin.get(CertificateAttribute_.value));
                pred = cb.and((Expression)cb.equal((Expression)attJoin.get(CertificateAttribute_.name), (Object)"CA3S:SELFSIGNED"), (Expression)SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)attJoin.get(CertificateAttribute_.value), (String)attributeValue.toLowerCase()));
            } else if ("intermediate".equals(attribute)) {
                SetJoin attJoin = root.join(Certificate_.certificateAttributes, JoinType.LEFT);
                SpecificationsHelper.addNewColumn(selectionList, (Selection)attJoin.get(CertificateAttribute_.value));
                pred = cb.and((Expression)cb.equal((Expression)attJoin.get(CertificateAttribute_.name), (Object)"CA3S:INTERMEDIATE"), (Expression)SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)attJoin.get(CertificateAttribute_.value), (String)attributeValue.toLowerCase()));
            } else if ("endEntity".equals(attribute)) {
                SetJoin attJoin = root.join(Certificate_.certificateAttributes, JoinType.LEFT);
                SpecificationsHelper.addNewColumn(selectionList, (Selection)attJoin.get(CertificateAttribute_.value));
                pred = cb.and((Expression)cb.equal((Expression)attJoin.get(CertificateAttribute_.name), (Object)"CA3S:END_ENTITY"), (Expression)SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)attJoin.get(CertificateAttribute_.value), (String)attributeValue.toLowerCase()));
            } else if ("crlurl".equals(attribute)) {
                SetJoin attJoin = root.join(Certificate_.certificateAttributes, JoinType.LEFT);
                SpecificationsHelper.addNewColumn(selectionList, (Selection)attJoin.get(CertificateAttribute_.value));
                pred = cb.and((Expression)cb.equal((Expression)attJoin.get(CertificateAttribute_.name), (Object)"CRL_URL"), (Expression)SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)attJoin.get(CertificateAttribute_.value), (String)attributeValue.toLowerCase()));
            } else if ("chainlength".equals(attribute)) {
                SetJoin attJoin = root.join(Certificate_.certificateAttributes, JoinType.LEFT);
                SpecificationsHelper.addNewColumn(selectionList, (Selection)attJoin.get(CertificateAttribute_.value));
                pred = cb.and((Expression)cb.equal((Expression)attJoin.get(CertificateAttribute_.name), (Object)"CA3S:CHAIN_LENGTH"), (Expression)SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)attJoin.get(CertificateAttribute_.value), (String)attributeValue.toLowerCase()));
            } else if ("ca".equals(attribute)) {
                SetJoin attJoin = root.join(Certificate_.certificateAttributes, JoinType.LEFT);
                SpecificationsHelper.addNewColumn(selectionList, (Selection)attJoin.get(CertificateAttribute_.value));
                pred = cb.and((Expression)cb.equal((Expression)attJoin.get(CertificateAttribute_.name), (Object)"CA3S:CA"), (Expression)SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)attJoin.get(CertificateAttribute_.value), (String)attributeValue.toLowerCase()));
            } else if ("subject".equals(attribute)) {
                SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(Certificate_.subject));
                if (attributeValue.trim().length() > 0) {
                    Subquery certAttSubquery = certQuery.subquery(CertificateAttribute.class);
                    Root certAttRoot = certAttSubquery.from(CertificateAttribute.class);
                    pred = cb.exists(certAttSubquery.select((Expression)certAttRoot).where((Expression)cb.and(new Predicate[]{cb.equal((Expression)certAttRoot.get("certificate"), (Expression)root.get("id")), cb.equal((Expression)certAttRoot.get("name"), (Object)"SUBJECT"), SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)certAttRoot.get(CertificateAttribute_.value), (String)attributeValue.toLowerCase())})));
                }
            } else if ("cn".equals(attribute)) {
                SetJoin attJoin = root.join(Certificate_.certificateAttributes, JoinType.LEFT);
                SpecificationsHelper.addNewColumn(selectionList, (Selection)attJoin.get(CertificateAttribute_.value));
                pred = cb.and((Expression)cb.equal((Expression)attJoin.get(CertificateAttribute_.name), (Object)"RDN_COMMONNAME"), (Expression)SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)attJoin.get(CertificateAttribute_.value), (String)attributeValue.toLowerCase()));
            } else if ("sans".equals(attribute)) {
                SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(Certificate_.sans));
                if (attributeValue.trim().length() > 0) {
                    Subquery certAttSubquery = certQuery.subquery(CertificateAttribute.class);
                    Root certAttRoot = certAttSubquery.from(CertificateAttribute.class);
                    pred = cb.exists(certAttSubquery.select((Expression)certAttRoot).where((Expression)cb.and(new Predicate[]{cb.equal((Expression)certAttRoot.get("certificate"), (Expression)root.get("id")), cb.equal((Expression)certAttRoot.get("name"), (Object)"SAN"), SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)certAttRoot.get(CertificateAttribute_.value), (String)attributeValue.toLowerCase())})));
                }
            } else if ("issuer".equals(attribute)) {
                SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(Certificate_.issuer));
                if (attributeValue.trim().length() > 0) {
                    Subquery certAttSubquery = certQuery.subquery(CertificateAttribute.class);
                    Root certAttRoot = certAttSubquery.from(CertificateAttribute.class);
                    pred = cb.exists(certAttSubquery.select((Expression)certAttRoot).where((Expression)cb.and(new Predicate[]{cb.equal((Expression)certAttRoot.get("certificate"), (Expression)root.get("id")), cb.equal((Expression)certAttRoot.get("name"), (Object)"ISSUER"), SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)certAttRoot.get(CertificateAttribute_.value), (String)attributeValue.toLowerCase())})));
                }
            } else if ("root".equals(attribute)) {
                SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(Certificate_.root));
                if (attributeValue.trim().length() > 0) {
                    Subquery certAttSubquery = certQuery.subquery(CertificateAttribute.class);
                    Root certAttRoot = certAttSubquery.from(CertificateAttribute.class);
                    pred = cb.exists(certAttSubquery.select((Expression)certAttRoot).where((Expression)cb.and(new Predicate[]{cb.equal((Expression)certAttRoot.get("certificate"), (Expression)root.get("id")), cb.equal((Expression)certAttRoot.get("name"), (Object)"ROOT"), SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)certAttRoot.get(CertificateAttribute_.value), (String)attributeValue.toLowerCase())})));
                }
            } else if ("san".equals(attribute)) {
                SetJoin attJoin = root.join(Certificate_.certificateAttributes, JoinType.LEFT);
                SpecificationsHelper.addNewColumn(selectionList, (Selection)attJoin.get(CertificateAttribute_.value));
                pred = cb.and((Expression)cb.equal((Expression)attJoin.get(CertificateAttribute_.name), (Object)"SAN"), (Expression)SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)attJoin.get(CertificateAttribute_.value), (String)attributeValue.toLowerCase()));
            } else if ("usage".equals(attribute)) {
                SetJoin attJoin = root.join(Certificate_.certificateAttributes, JoinType.LEFT);
                SpecificationsHelper.addNewColumn(selectionList, (Selection)attJoin.get(CertificateAttribute_.value));
                pred = cb.and((Expression)cb.equal((Expression)attJoin.get(CertificateAttribute_.name), (Object)"USAGE"), (Expression)SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)attJoin.get(CertificateAttribute_.value), (String)attributeValue.toLowerCase()));
            } else if ("ski".equals(attribute)) {
                SetJoin attJoin = root.join(Certificate_.certificateAttributes, JoinType.LEFT);
                SpecificationsHelper.addNewColumn(selectionList, (Selection)attJoin.get(CertificateAttribute_.value));
                pred = cb.and((Expression)cb.equal((Expression)attJoin.get(CertificateAttribute_.name), (Object)"SKI"), (Expression)SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)attJoin.get(CertificateAttribute_.value), (String)attributeValue));
            } else if ("fingerprint".equals(attribute)) {
                SetJoin attJoin = root.join(Certificate_.certificateAttributes, JoinType.LEFT);
                SpecificationsHelper.addNewColumn(selectionList, (Selection)attJoin.get(CertificateAttribute_.value));
                pred = cb.and((Expression)cb.equal((Expression)attJoin.get(CertificateAttribute_.name), (Object)"FINGERPRINT_SHA1"), (Expression)SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)attJoin.get(CertificateAttribute_.value), (String)attributeValue.toLowerCase()));
            } else if ("pkiLevel".equals(attribute)) {
                SetJoin attJoin = root.join(Certificate_.certificateAttributes, JoinType.LEFT);
                SpecificationsHelper.addNewColumn(selectionList, (Selection)attJoin.get(CertificateAttribute_.value));
                String attrName = "CA3S:END_ENTITY";
                if ("root".equalsIgnoreCase(attributeValue)) {
                    attrName = "CA3S:SELFSIGNED";
                } else if ("intermediate".equalsIgnoreCase(attributeValue)) {
                    attrName = "CA3S:CA";
                }
                pred = cb.and((Expression)cb.equal((Expression)attJoin.get(CertificateAttribute_.name), (Object)attrName), (Expression)SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)attJoin.get(CertificateAttribute_.value), (String)"true"));
            } else if ("hashAlgorithm".equals(attribute)) {
                SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(Certificate_.hashingAlgorithm));
                pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(Certificate_.hashingAlgorithm), (String)attributeValue);
            } else if ("type".equals(attribute)) {
                SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(Certificate_.type));
                pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(Certificate_.type), (String)attributeValue);
            } else if ("signingAlgorithm".equals(attribute)) {
                SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(Certificate_.signingAlgorithm));
                pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(Certificate_.signingAlgorithm), (String)attributeValue);
            } else if ("paddingAlgorithm".equals(attribute)) {
                SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(Certificate_.paddingAlgorithm));
                pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(Certificate_.paddingAlgorithm), (String)attributeValue);
            } else if ("keyAlgorithm".equals(attribute)) {
                SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(Certificate_.keyAlgorithm));
                pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(Certificate_.keyAlgorithm), (String)attributeValue);
            } else if ("keyLength".equals(attribute)) {
                SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(Certificate_.keyLength));
                pred = SpecificationsHelper.buildPredicateInteger((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(Certificate_.keyLength), (String)attributeValue);
            } else if ("serial".equals(attribute)) {
                BigInteger serialBI;
                SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(Certificate_.serial));
                String decSerial = attributeValue;
                if (attributeValue.startsWith("#")) {
                    decSerial = attributeValue.substring(1);
                } else if (attributeValue.startsWith("$")) {
                    serialBI = new BigInteger(attributeValue.substring(1).replaceAll(" ", ""), 16);
                    decSerial = serialBI.toString();
                } else if (attributeValue.toLowerCase().startsWith("0x")) {
                    serialBI = new BigInteger(attributeValue.substring(2).replaceAll(" ", ""), 16);
                    decSerial = serialBI.toString();
                }
                String paddedSerial = CertificateUtil.getPaddedSerial((String)decSerial);
                logger.debug("serial used for search {} ", (Object)paddedSerial);
                SetJoin attJoin = root.join(Certificate_.certificateAttributes, JoinType.LEFT);
                pred = cb.and((Expression)cb.equal((Expression)attJoin.get(CertificateAttribute_.name), (Object)"SERIAL_PADDED"), (Expression)SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)attJoin.get(CertificateAttribute_.value), (String)paddedSerial));
            } else if ("validFrom".equals(attribute)) {
                SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(Certificate_.validFrom));
                pred = SpecificationsHelper.buildDatePredicate((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(Certificate_.validFrom), (String)attributeValue);
            } else if ("validTo".equals(attribute)) {
                SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(Certificate_.validTo));
                pred = SpecificationsHelper.buildDatePredicate((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(Certificate_.validTo), (String)attributeValue);
            } else if ("active".equals(attribute)) {
                SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(Certificate_.active));
                pred = SpecificationsHelper.buildBooleanPredicate((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(Certificate_.active), (String)attributeValue);
            } else if ("revoked".equals(attribute)) {
                SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(Certificate_.revoked));
                pred = SpecificationsHelper.buildBooleanPredicate((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(Certificate_.revoked), (String)attributeValue);
            } else if ("trusted".equals(attribute)) {
                SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(Certificate_.trusted));
                pred = SpecificationsHelper.buildBooleanPredicate((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(Certificate_.trusted), (String)attributeValue);
            } else if ("revokedSince".equals(attribute)) {
                SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(Certificate_.revokedSince));
                pred = SpecificationsHelper.buildDatePredicate((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(Certificate_.revokedSince), (String)attributeValue);
            } else if ("revocationReason".equals(attribute)) {
                SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(Certificate_.revocationReason));
                pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(Certificate_.revocationReason), (String)attributeValue);
            } else if ("requestedBy".equals(attribute)) {
                if (attributeValue.trim().length() > 0) {
                    Join attJoin = root.join(Certificate_.csr, JoinType.LEFT);
                    SpecificationsHelper.addNewColumn(selectionList, (Selection)attJoin.get(CSR_.requestedBy));
                    pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)attJoin.get(CSR_.requestedBy), (String)attributeValue);
                }
            } else if ("comment".equals(attribute)) {
                Join attJoin = root.join(Certificate_.comment, JoinType.LEFT);
                SpecificationsHelper.addNewColumn(selectionList, (Selection)attJoin.get(CertificateComment_.comment));
                pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)attJoin.get(CertificateComment_.comment), (String)attributeValue.toLowerCase());
            } else if (certificateSelectionAttributes.contains(attribute)) {
                SetJoin attJoin = root.join(Certificate_.certificateAttributes, JoinType.LEFT);
                pred = cb.and((Expression)cb.equal((Expression)attJoin.get(CertificateAttribute_.name), (Object)("_ARA_" + attribute)), (Expression)SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)attJoin.get(CertificateAttribute_.value), (String)attributeValue.toLowerCase()));
            } else {
                logger.warn("fall-thru clause adding 'true' condition for {} ", (Object)attribute);
            }
        }
        return pred;
    }
}

