/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.impl;

import de.trustable.ca3s.core.domain.ProtectedContent;
import de.trustable.ca3s.core.repository.ProtectedContentRepository;
import de.trustable.ca3s.core.service.ProtectedContentService;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ProtectedContentServiceImpl
implements ProtectedContentService {
    private final Logger log = LoggerFactory.getLogger(ProtectedContentServiceImpl.class);
    private final ProtectedContentRepository protectedContentRepository;

    public ProtectedContentServiceImpl(ProtectedContentRepository protectedContentRepository) {
        this.protectedContentRepository = protectedContentRepository;
    }

    public ProtectedContent save(ProtectedContent protectedContent) {
        this.log.debug("Request to save ProtectedContent : {}", (Object)protectedContent);
        return (ProtectedContent)this.protectedContentRepository.save((Object)protectedContent);
    }

    @Transactional(readOnly=true)
    public List<ProtectedContent> findAll() {
        this.log.debug("Request to get all ProtectedContents");
        return this.protectedContentRepository.findAll();
    }

    @Transactional(readOnly=true)
    public Optional<ProtectedContent> findOne(Long id) {
        this.log.debug("Request to get ProtectedContent : {}", (Object)id);
        return this.protectedContentRepository.findById((Object)id);
    }

    public void delete(Long id) {
        this.log.debug("Request to delete ProtectedContent : {}", (Object)id);
        this.protectedContentRepository.deleteById((Object)id);
    }
}

