/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.support;

import de.trustable.ca3s.core.domain.BPMNProcessInfo;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.dto.BPMNUpload;
import de.trustable.ca3s.core.service.util.BPMNUtil;
import de.trustable.ca3s.core.web.rest.support.NotFoundException;
import javax.validation.Valid;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/api"})
public class BPMNUpDownloadController {
    private static final Logger LOG = LoggerFactory.getLogger(BPMNUpDownloadController.class);
    final BPMNUtil bpmnUtil;
    final AuditService auditService;

    public BPMNUpDownloadController(BPMNUtil bpmnUtil, AuditService auditService) {
        this.bpmnUtil = bpmnUtil;
        this.auditService = auditService;
    }

    @RequestMapping(value={"/bpmn/{processId}"}, method={RequestMethod.GET}, produces={"application/xml"})
    public ResponseEntity<InputStreamResource> getBPMN(@PathVariable String processId) throws NotFoundException {
        LOG.info("Received bpmn download request for id {} ", (Object)processId);
        for (ProcessDefinition pd : this.bpmnUtil.getProcessDefinitions()) {
            LOG.info("process definition present : id {}, name {} ", (Object)pd.getId(), (Object)pd.getName());
        }
        InputStreamResource inputStreamResource = new InputStreamResource(this.bpmnUtil.getProcessContent(processId));
        return new ResponseEntity((Object)inputStreamResource, HttpStatus.OK);
    }

    @PostMapping(value={"/bpmn"})
    @Transactional
    public ResponseEntity<InputStreamResource> postBPMN(@Valid @RequestBody BPMNUpload bpmnUpload) throws NotFoundException {
        LOG.info("Received bpmn upload request with name {} ", (Object)bpmnUpload.getName());
        if (bpmnUpload.getContentXML().trim().isEmpty()) {
            LOG.warn("Received bpmn upload request with name {} has no XML content!", (Object)bpmnUpload.getName());
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        String modelId = this.bpmnUtil.addModel(bpmnUpload.getContentXML(), bpmnUpload.getName());
        LOG.debug("Deployed bpmn document with modelName {} successfully", (Object)modelId);
        BPMNProcessInfo bpmnProcessInfo = this.bpmnUtil.buildBPMNProcessInfo(modelId, bpmnUpload.getName(), bpmnUpload.getType());
        for (ProcessDefinition pd : this.bpmnUtil.getProcessDefinitions()) {
            LOG.info("process definition present : id {}, name {} ", (Object)pd.getId(), (Object)pd.getName());
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }
}

